package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiOffice {

    /**
     * 💼
     */
    Emoji BRIEFCASE = new Emoji("💼", "\uD83D\uDCBC", Collections.singletonList(":briefcase:"), Collections.singletonList(":briefcase:"), Collections.singletonList(":briefcase:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "briefcase", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, false);

    /**
     * 📁
     */
    Emoji FILE_FOLDER = new Emoji("📁", "\uD83D\uDCC1", Collections.singletonList(":file_folder:"), Collections.singletonList(":file_folder:"), Collections.singletonList(":file_folder:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "file folder", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, false);

    /**
     * 📂
     */
    Emoji OPEN_FILE_FOLDER = new Emoji("📂", "\uD83D\uDCC2", Collections.singletonList(":open_file_folder:"), Collections.singletonList(":open_file_folder:"), Collections.singletonList(":open_file_folder:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "open file folder", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, false);

    /**
     * 🗂️
     */
    Emoji CARD_INDEX_DIVIDERS = new Emoji("🗂️", "\uD83D\uDDC2\uFE0F", Collections.unmodifiableList(Arrays.asList(":dividers:", ":card_index_dividers:")), Collections.singletonList(":card_index_dividers:"), Collections.singletonList(":card_index_dividers:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "card index dividers", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, false);

    /**
     * 🗂
     */
    Emoji CARD_INDEX_DIVIDERS_UNQUALIFIED = new Emoji("🗂", "\uD83D\uDDC2", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":card_index_dividers:"), false, false, 0.7, Qualification.fromString("unqualified"), "card index dividers", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, true);

    /**
     * 📅
     */
    Emoji CALENDAR = new Emoji("📅", "\uD83D\uDCC5", Collections.singletonList(":date:"), Collections.singletonList(":date:"), Collections.singletonList(":date:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "calendar", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, false);

    /**
     * 📆
     */
    Emoji TEAR_OFF_CALENDAR = new Emoji("📆", "\uD83D\uDCC6", Collections.singletonList(":calendar:"), Collections.singletonList(":calendar:"), Collections.singletonList(":calendar:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "tear-off calendar", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, false);

    /**
     * 🗒️
     */
    Emoji SPIRAL_NOTEPAD = new Emoji("🗒️", "\uD83D\uDDD2\uFE0F", Collections.unmodifiableList(Arrays.asList(":notepad_spiral:", ":spiral_note_pad:")), Collections.singletonList(":spiral_note_pad:"), Collections.singletonList(":spiral_notepad:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "spiral notepad", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, false);

    /**
     * 🗒
     */
    Emoji SPIRAL_NOTEPAD_UNQUALIFIED = new Emoji("🗒", "\uD83D\uDDD2", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":spiral_notepad:"), false, false, 0.7, Qualification.fromString("unqualified"), "spiral notepad", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, true);

    /**
     * 🗓️
     */
    Emoji SPIRAL_CALENDAR = new Emoji("🗓️", "\uD83D\uDDD3\uFE0F", Collections.unmodifiableList(Arrays.asList(":calendar_spiral:", ":spiral_calendar_pad:")), Collections.singletonList(":spiral_calendar_pad:"), Collections.singletonList(":spiral_calendar:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "spiral calendar", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, false);

    /**
     * 🗓
     */
    Emoji SPIRAL_CALENDAR_UNQUALIFIED = new Emoji("🗓", "\uD83D\uDDD3", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":spiral_calendar:"), false, false, 0.7, Qualification.fromString("unqualified"), "spiral calendar", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, true);

    /**
     * 📇
     */
    Emoji CARD_INDEX = new Emoji("📇", "\uD83D\uDCC7", Collections.singletonList(":card_index:"), Collections.singletonList(":card_index:"), Collections.singletonList(":card_index:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "card index", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, false);

    /**
     * 📈
     */
    Emoji CHART_INCREASING = new Emoji("📈", "\uD83D\uDCC8", Collections.singletonList(":chart_with_upwards_trend:"), Collections.singletonList(":chart_with_upwards_trend:"), Collections.singletonList(":chart_with_upwards_trend:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "chart increasing", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, false);

    /**
     * 📉
     */
    Emoji CHART_DECREASING = new Emoji("📉", "\uD83D\uDCC9", Collections.singletonList(":chart_with_downwards_trend:"), Collections.singletonList(":chart_with_downwards_trend:"), Collections.singletonList(":chart_with_downwards_trend:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "chart decreasing", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, false);

    /**
     * 📊
     */
    Emoji BAR_CHART = new Emoji("📊", "\uD83D\uDCCA", Collections.singletonList(":bar_chart:"), Collections.singletonList(":bar_chart:"), Collections.singletonList(":bar_chart:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "bar chart", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, false);

    /**
     * 📋
     */
    Emoji CLIPBOARD = new Emoji("📋", "\uD83D\uDCCB", Collections.singletonList(":clipboard:"), Collections.singletonList(":clipboard:"), Collections.singletonList(":clipboard:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "clipboard", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, true);

    /**
     * 📌
     */
    Emoji PUSHPIN = new Emoji("📌", "\uD83D\uDCCC", Collections.singletonList(":pushpin:"), Collections.singletonList(":pushpin:"), Collections.singletonList(":pushpin:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "pushpin", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, false);

    /**
     * 📍
     */
    Emoji ROUND_PUSHPIN = new Emoji("📍", "\uD83D\uDCCD", Collections.singletonList(":round_pushpin:"), Collections.singletonList(":round_pushpin:"), Collections.singletonList(":round_pushpin:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "round pushpin", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, false);

    /**
     * 📎
     */
    Emoji PAPERCLIP = new Emoji("📎", "\uD83D\uDCCE", Collections.singletonList(":paperclip:"), Collections.singletonList(":paperclip:"), Collections.singletonList(":paperclip:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "paperclip", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, false);

    /**
     * 🖇️
     */
    Emoji LINKED_PAPERCLIPS = new Emoji("🖇️", "\uD83D\uDD87\uFE0F", Collections.unmodifiableList(Arrays.asList(":paperclips:", ":linked_paperclips:")), Collections.singletonList(":linked_paperclips:"), Collections.singletonList(":paperclips:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "linked paperclips", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, false);

    /**
     * 🖇
     */
    Emoji LINKED_PAPERCLIPS_UNQUALIFIED = new Emoji("🖇", "\uD83D\uDD87", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":paperclips:"), false, false, 0.7, Qualification.fromString("unqualified"), "linked paperclips", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, true);

    /**
     * 📏
     */
    Emoji STRAIGHT_RULER = new Emoji("📏", "\uD83D\uDCCF", Collections.singletonList(":straight_ruler:"), Collections.singletonList(":straight_ruler:"), Collections.singletonList(":straight_ruler:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "straight ruler", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, false);

    /**
     * 📐
     */
    Emoji TRIANGULAR_RULER = new Emoji("📐", "\uD83D\uDCD0", Collections.singletonList(":triangular_ruler:"), Collections.singletonList(":triangular_ruler:"), Collections.singletonList(":triangular_ruler:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "triangular ruler", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, false);

    /**
     * ✂️
     */
    Emoji SCISSORS = new Emoji("✂️", "\u2702\uFE0F", Collections.singletonList(":scissors:"), Collections.singletonList(":scissors:"), Collections.singletonList(":scissors:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "scissors", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, false);

    /**
     * ✂
     */
    Emoji SCISSORS_UNQUALIFIED = new Emoji("✂", "\u2702", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":scissors:"), false, false, 0.6, Qualification.fromString("unqualified"), "scissors", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, true);

    /**
     * 🗃️
     */
    Emoji CARD_FILE_BOX = new Emoji("🗃️", "\uD83D\uDDC3\uFE0F", Collections.unmodifiableList(Arrays.asList(":card_box:", ":card_file_box:")), Collections.singletonList(":card_file_box:"), Collections.singletonList(":card_file_box:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "card file box", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, false);

    /**
     * 🗃
     */
    Emoji CARD_FILE_BOX_UNQUALIFIED = new Emoji("🗃", "\uD83D\uDDC3", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":card_file_box:"), false, false, 0.7, Qualification.fromString("unqualified"), "card file box", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, true);

    /**
     * 🗄️
     */
    Emoji FILE_CABINET = new Emoji("🗄️", "\uD83D\uDDC4\uFE0F", Collections.singletonList(":file_cabinet:"), Collections.singletonList(":file_cabinet:"), Collections.singletonList(":file_cabinet:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "file cabinet", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, false);

    /**
     * 🗄
     */
    Emoji FILE_CABINET_UNQUALIFIED = new Emoji("🗄", "\uD83D\uDDC4", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":file_cabinet:"), false, false, 0.7, Qualification.fromString("unqualified"), "file cabinet", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, true);

    /**
     * 🗑️
     */
    Emoji WASTEBASKET = new Emoji("🗑️", "\uD83D\uDDD1\uFE0F", Collections.singletonList(":wastebasket:"), Collections.singletonList(":wastebasket:"), Collections.singletonList(":wastebasket:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "wastebasket", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, false);

    /**
     * 🗑
     */
    Emoji WASTEBASKET_UNQUALIFIED = new Emoji("🗑", "\uD83D\uDDD1", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":wastebasket:"), false, false, 0.7, Qualification.fromString("unqualified"), "wastebasket", EmojiGroup.OBJECTS, EmojiSubGroup.OFFICE, true);
}
