package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiMusicalInstrument {

    /**
     * 🎷
     */
    Emoji SAXOPHONE = new Emoji("🎷", "\uD83C\uDFB7", Collections.singletonList(":saxophone:"), Collections.singletonList(":saxophone:"), Collections.singletonList(":saxophone:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "saxophone", EmojiGroup.OBJECTS, EmojiSubGroup.MUSICAL_INSTRUMENT, false);

    /**
     * 🪗
     */
    Emoji ACCORDION = new Emoji("🪗", "\uD83E\uDE97", Collections.singletonList(":accordion:"), Collections.singletonList(":accordion:"), Collections.singletonList(":accordion:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "accordion", EmojiGroup.OBJECTS, EmojiSubGroup.MUSICAL_INSTRUMENT, false);

    /**
     * 🎸
     */
    Emoji GUITAR = new Emoji("🎸", "\uD83C\uDFB8", Collections.singletonList(":guitar:"), Collections.singletonList(":guitar:"), Collections.singletonList(":guitar:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "guitar", EmojiGroup.OBJECTS, EmojiSubGroup.MUSICAL_INSTRUMENT, false);

    /**
     * 🎹
     */
    Emoji MUSICAL_KEYBOARD = new Emoji("🎹", "\uD83C\uDFB9", Collections.singletonList(":musical_keyboard:"), Collections.singletonList(":musical_keyboard:"), Collections.singletonList(":musical_keyboard:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "musical keyboard", EmojiGroup.OBJECTS, EmojiSubGroup.MUSICAL_INSTRUMENT, false);

    /**
     * 🎺
     */
    Emoji TRUMPET = new Emoji("🎺", "\uD83C\uDFBA", Collections.singletonList(":trumpet:"), Collections.singletonList(":trumpet:"), Collections.singletonList(":trumpet:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "trumpet", EmojiGroup.OBJECTS, EmojiSubGroup.MUSICAL_INSTRUMENT, false);

    /**
     * 🎻
     */
    Emoji VIOLIN = new Emoji("🎻", "\uD83C\uDFBB", Collections.singletonList(":violin:"), Collections.singletonList(":violin:"), Collections.singletonList(":violin:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "violin", EmojiGroup.OBJECTS, EmojiSubGroup.MUSICAL_INSTRUMENT, false);

    /**
     * 🪕
     */
    Emoji BANJO = new Emoji("🪕", "\uD83E\uDE95", Collections.singletonList(":banjo:"), Collections.singletonList(":banjo:"), Collections.singletonList(":banjo:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "banjo", EmojiGroup.OBJECTS, EmojiSubGroup.MUSICAL_INSTRUMENT, false);

    /**
     * 🥁
     */
    Emoji DRUM = new Emoji("🥁", "\uD83E\uDD41", Collections.unmodifiableList(Arrays.asList(":drum:", ":drum_with_drumsticks:")), Collections.singletonList(":drum_with_drumsticks:"), Collections.singletonList(":drum:"), false, false, 3.0, Qualification.fromString("fully-qualified"), "drum", EmojiGroup.OBJECTS, EmojiSubGroup.MUSICAL_INSTRUMENT, false);

    /**
     * 🪘
     */
    Emoji LONG_DRUM = new Emoji("🪘", "\uD83E\uDE98", Collections.singletonList(":long_drum:"), Collections.singletonList(":long_drum:"), Collections.singletonList(":long_drum:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "long drum", EmojiGroup.OBJECTS, EmojiSubGroup.MUSICAL_INSTRUMENT, false);

    /**
     * 🪇
     */
    Emoji MARACAS = new Emoji("🪇", "\uD83E\uDE87", Collections.singletonList(":maracas:"), Collections.emptyList(), Collections.singletonList(":maracas:"), false, false, 15.0, Qualification.fromString("fully-qualified"), "maracas", EmojiGroup.OBJECTS, EmojiSubGroup.MUSICAL_INSTRUMENT, false);

    /**
     * 🪈
     */
    Emoji FLUTE = new Emoji("🪈", "\uD83E\uDE88", Collections.singletonList(":flute:"), Collections.emptyList(), Collections.singletonList(":flute:"), false, false, 15.0, Qualification.fromString("fully-qualified"), "flute", EmojiGroup.OBJECTS, EmojiSubGroup.MUSICAL_INSTRUMENT, false);
}
