package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiMusic {

    /**
     * 🎼
     */
    Emoji MUSICAL_SCORE = new Emoji("🎼", "\uD83C\uDFBC", Collections.singletonList(":musical_score:"), Collections.singletonList(":musical_score:"), Collections.singletonList(":musical_score:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "musical score", EmojiGroup.OBJECTS, EmojiSubGroup.MUSIC, false);

    /**
     * 🎵
     */
    Emoji MUSICAL_NOTE = new Emoji("🎵", "\uD83C\uDFB5", Collections.singletonList(":musical_note:"), Collections.singletonList(":musical_note:"), Collections.singletonList(":musical_note:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "musical note", EmojiGroup.OBJECTS, EmojiSubGroup.MUSIC, false);

    /**
     * 🎶
     */
    Emoji MUSICAL_NOTES = new Emoji("🎶", "\uD83C\uDFB6", Collections.unmodifiableList(Arrays.asList(":notes:", ":musical_notes:")), Collections.singletonList(":notes:"), Collections.singletonList(":notes:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "musical notes", EmojiGroup.OBJECTS, EmojiSubGroup.MUSIC, false);

    /**
     * 🎙️
     */
    Emoji STUDIO_MICROPHONE = new Emoji("🎙️", "\uD83C\uDF99\uFE0F", Collections.unmodifiableList(Arrays.asList(":microphone2:", ":studio_microphone:")), Collections.singletonList(":studio_microphone:"), Collections.singletonList(":studio_microphone:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "studio microphone", EmojiGroup.OBJECTS, EmojiSubGroup.MUSIC, false);

    /**
     * 🎙
     */
    Emoji STUDIO_MICROPHONE_UNQUALIFIED = new Emoji("🎙", "\uD83C\uDF99", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":studio_microphone:"), false, false, 0.7, Qualification.fromString("unqualified"), "studio microphone", EmojiGroup.OBJECTS, EmojiSubGroup.MUSIC, true);

    /**
     * 🎚️
     */
    Emoji LEVEL_SLIDER = new Emoji("🎚️", "\uD83C\uDF9A\uFE0F", Collections.singletonList(":level_slider:"), Collections.singletonList(":level_slider:"), Collections.singletonList(":level_slider:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "level slider", EmojiGroup.OBJECTS, EmojiSubGroup.MUSIC, false);

    /**
     * 🎚
     */
    Emoji LEVEL_SLIDER_UNQUALIFIED = new Emoji("🎚", "\uD83C\uDF9A", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":level_slider:"), false, false, 0.7, Qualification.fromString("unqualified"), "level slider", EmojiGroup.OBJECTS, EmojiSubGroup.MUSIC, true);

    /**
     * 🎛️
     */
    Emoji CONTROL_KNOBS = new Emoji("🎛️", "\uD83C\uDF9B\uFE0F", Collections.singletonList(":control_knobs:"), Collections.singletonList(":control_knobs:"), Collections.singletonList(":control_knobs:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "control knobs", EmojiGroup.OBJECTS, EmojiSubGroup.MUSIC, false);

    /**
     * 🎛
     */
    Emoji CONTROL_KNOBS_UNQUALIFIED = new Emoji("🎛", "\uD83C\uDF9B", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":control_knobs:"), false, false, 0.7, Qualification.fromString("unqualified"), "control knobs", EmojiGroup.OBJECTS, EmojiSubGroup.MUSIC, true);

    /**
     * 🎤
     */
    Emoji MICROPHONE = new Emoji("🎤", "\uD83C\uDFA4", Collections.singletonList(":microphone:"), Collections.singletonList(":microphone:"), Collections.singletonList(":microphone:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "microphone", EmojiGroup.OBJECTS, EmojiSubGroup.MUSIC, false);

    /**
     * 🎧
     */
    Emoji HEADPHONE = new Emoji("🎧", "\uD83C\uDFA7", Collections.unmodifiableList(Arrays.asList(":headphones:", ":headphone:")), Collections.singletonList(":headphones:"), Collections.singletonList(":headphones:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "headphone", EmojiGroup.OBJECTS, EmojiSubGroup.MUSIC, true);

    /**
     * 📻
     */
    Emoji RADIO = new Emoji("📻", "\uD83D\uDCFB", Collections.singletonList(":radio:"), Collections.singletonList(":radio:"), Collections.singletonList(":radio:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "radio", EmojiGroup.OBJECTS, EmojiSubGroup.MUSIC, true);
}
