package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiMoney {

    /**
     * 💰
     */
    Emoji MONEY_BAG = new Emoji("💰", "\uD83D\uDCB0", Collections.unmodifiableList(Arrays.asList(":moneybag:", ":money_bag:")), Collections.singletonList(":moneybag:"), Collections.singletonList(":moneybag:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "money bag", EmojiGroup.OBJECTS, EmojiSubGroup.MONEY, true);

    /**
     * 🪙
     */
    Emoji COIN = new Emoji("🪙", "\uD83E\uDE99", Collections.singletonList(":coin:"), Collections.singletonList(":coin:"), Collections.singletonList(":coin:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "coin", EmojiGroup.OBJECTS, EmojiSubGroup.MONEY, false);

    /**
     * 💴
     */
    Emoji YEN_BANKNOTE = new Emoji("💴", "\uD83D\uDCB4", Collections.unmodifiableList(Arrays.asList(":yen:", ":yen_banknote:")), Collections.singletonList(":yen:"), Collections.singletonList(":yen:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "yen banknote", EmojiGroup.OBJECTS, EmojiSubGroup.MONEY, false);

    /**
     * 💵
     */
    Emoji DOLLAR_BANKNOTE = new Emoji("💵", "\uD83D\uDCB5", Collections.singletonList(":dollar:"), Collections.singletonList(":dollar:"), Collections.singletonList(":dollar:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "dollar banknote", EmojiGroup.OBJECTS, EmojiSubGroup.MONEY, false);

    /**
     * 💶
     */
    Emoji EURO_BANKNOTE = new Emoji("💶", "\uD83D\uDCB6", Collections.unmodifiableList(Arrays.asList(":euro:", ":euro_banknote:")), Collections.singletonList(":euro:"), Collections.singletonList(":euro:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "euro banknote", EmojiGroup.OBJECTS, EmojiSubGroup.MONEY, false);

    /**
     * 💷
     */
    Emoji POUND_BANKNOTE = new Emoji("💷", "\uD83D\uDCB7", Collections.singletonList(":pound:"), Collections.singletonList(":pound:"), Collections.singletonList(":pound:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "pound banknote", EmojiGroup.OBJECTS, EmojiSubGroup.MONEY, false);

    /**
     * 💸
     */
    Emoji MONEY_WITH_WINGS = new Emoji("💸", "\uD83D\uDCB8", Collections.singletonList(":money_with_wings:"), Collections.singletonList(":money_with_wings:"), Collections.singletonList(":money_with_wings:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "money with wings", EmojiGroup.OBJECTS, EmojiSubGroup.MONEY, false);

    /**
     * 💳
     */
    Emoji CREDIT_CARD = new Emoji("💳", "\uD83D\uDCB3", Collections.singletonList(":credit_card:"), Collections.singletonList(":credit_card:"), Collections.singletonList(":credit_card:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "credit card", EmojiGroup.OBJECTS, EmojiSubGroup.MONEY, true);

    /**
     * 🧾
     */
    Emoji RECEIPT = new Emoji("🧾", "\uD83E\uDDFE", Collections.singletonList(":receipt:"), Collections.singletonList(":receipt:"), Collections.singletonList(":receipt:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "receipt", EmojiGroup.OBJECTS, EmojiSubGroup.MONEY, false);

    /**
     * 💹
     */
    Emoji CHART_INCREASING_WITH_YEN = new Emoji("💹", "\uD83D\uDCB9", Collections.singletonList(":chart:"), Collections.singletonList(":chart:"), Collections.singletonList(":chart:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "chart increasing with yen", EmojiGroup.OBJECTS, EmojiSubGroup.MONEY, false);
}
