package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiMath {

    /**
     * ✖️
     */
    Emoji MULTIPLY = new Emoji("✖️", "\u2716\uFE0F", Collections.singletonList(":heavy_multiplication_x:"), Collections.singletonList(":heavy_multiplication_x:"), Collections.singletonList(":heavy_multiplication_x:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "multiply", EmojiGroup.SYMBOLS, EmojiSubGroup.MATH, false);

    /**
     * ✖
     */
    Emoji MULTIPLY_UNQUALIFIED = new Emoji("✖", "\u2716", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":heavy_multiplication_x:"), false, false, 0.6, Qualification.fromString("unqualified"), "multiply", EmojiGroup.SYMBOLS, EmojiSubGroup.MATH, true);

    /**
     * ➕
     */
    Emoji PLUS = new Emoji("➕", "\u2795", Collections.singletonList(":heavy_plus_sign:"), Collections.singletonList(":heavy_plus_sign:"), Collections.singletonList(":heavy_plus_sign:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "plus", EmojiGroup.SYMBOLS, EmojiSubGroup.MATH, true);

    /**
     * ➖
     */
    Emoji MINUS = new Emoji("➖", "\u2796", Collections.singletonList(":heavy_minus_sign:"), Collections.singletonList(":heavy_minus_sign:"), Collections.singletonList(":heavy_minus_sign:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "minus", EmojiGroup.SYMBOLS, EmojiSubGroup.MATH, true);

    /**
     * ➗
     */
    Emoji DIVIDE = new Emoji("➗", "\u2797", Collections.singletonList(":heavy_division_sign:"), Collections.singletonList(":heavy_division_sign:"), Collections.singletonList(":heavy_division_sign:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "divide", EmojiGroup.SYMBOLS, EmojiSubGroup.MATH, true);

    /**
     * 🟰
     */
    Emoji HEAVY_EQUALS_SIGN = new Emoji("🟰", "\uD83D\uDFF0", Collections.singletonList(":heavy_equals_sign:"), Collections.emptyList(), Collections.singletonList(":heavy_equals_sign:"), false, false, 14.0, Qualification.fromString("fully-qualified"), "heavy equals sign", EmojiGroup.SYMBOLS, EmojiSubGroup.MATH, false);

    /**
     * ♾️
     */
    Emoji INFINITY = new Emoji("♾️", "\u267E\uFE0F", Collections.singletonList(":infinity:"), Collections.singletonList(":infinity:"), Collections.singletonList(":infinity:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "infinity", EmojiGroup.SYMBOLS, EmojiSubGroup.MATH, false);

    /**
     * ♾
     */
    Emoji INFINITY_UNQUALIFIED = new Emoji("♾", "\u267E", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":infinity:"), false, false, 11.0, Qualification.fromString("unqualified"), "infinity", EmojiGroup.SYMBOLS, EmojiSubGroup.MATH, true);
}
