package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiHeart {

    /**
     * 💌
     */
    Emoji LOVE_LETTER = new Emoji("💌", "\uD83D\uDC8C", Collections.singletonList(":love_letter:"), Collections.singletonList(":love_letter:"), Collections.singletonList(":love_letter:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "love letter", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, false);

    /**
     * 💘
     */
    Emoji HEART_WITH_ARROW = new Emoji("💘", "\uD83D\uDC98", Collections.singletonList(":cupid:"), Collections.singletonList(":cupid:"), Collections.singletonList(":cupid:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "heart with arrow", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, false);

    /**
     * 💝
     */
    Emoji HEART_WITH_RIBBON = new Emoji("💝", "\uD83D\uDC9D", Collections.singletonList(":gift_heart:"), Collections.singletonList(":gift_heart:"), Collections.singletonList(":gift_heart:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "heart with ribbon", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, false);

    /**
     * 💖
     */
    Emoji SPARKLING_HEART = new Emoji("💖", "\uD83D\uDC96", Collections.singletonList(":sparkling_heart:"), Collections.singletonList(":sparkling_heart:"), Collections.singletonList(":sparkling_heart:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "sparkling heart", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, false);

    /**
     * 💗
     */
    Emoji GROWING_HEART = new Emoji("💗", "\uD83D\uDC97", Collections.unmodifiableList(Arrays.asList(":heartpulse:", ":growing_heart:")), Collections.singletonList(":heartpulse:"), Collections.singletonList(":heartpulse:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "growing heart", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, false);

    /**
     * 💓
     */
    Emoji BEATING_HEART = new Emoji("💓", "\uD83D\uDC93", Collections.unmodifiableList(Arrays.asList(":heartbeat:", ":beating_heart:")), Collections.singletonList(":heartbeat:"), Collections.singletonList(":heartbeat:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "beating heart", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, false);

    /**
     * 💞
     */
    Emoji REVOLVING_HEARTS = new Emoji("💞", "\uD83D\uDC9E", Collections.singletonList(":revolving_hearts:"), Collections.singletonList(":revolving_hearts:"), Collections.singletonList(":revolving_hearts:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "revolving hearts", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, false);

    /**
     * 💕
     */
    Emoji TWO_HEARTS = new Emoji("💕", "\uD83D\uDC95", Collections.singletonList(":two_hearts:"), Collections.singletonList(":two_hearts:"), Collections.singletonList(":two_hearts:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "two hearts", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, false);

    /**
     * 💟
     */
    Emoji HEART_DECORATION = new Emoji("💟", "\uD83D\uDC9F", Collections.singletonList(":heart_decoration:"), Collections.singletonList(":heart_decoration:"), Collections.singletonList(":heart_decoration:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "heart decoration", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, false);

    /**
     * ❣️
     */
    Emoji HEART_EXCLAMATION = new Emoji("❣️", "\u2763\uFE0F", Collections.unmodifiableList(Arrays.asList(":heart_exclamation:", ":heavy_heart_exclamation_mark_ornament:")), Collections.singletonList(":heavy_heart_exclamation_mark_ornament:"), Collections.singletonList(":heavy_heart_exclamation:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "heart exclamation", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, false);

    /**
     * ❣
     */
    Emoji HEART_EXCLAMATION_UNQUALIFIED = new Emoji("❣", "\u2763", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":heavy_heart_exclamation:"), false, false, 1.0, Qualification.fromString("unqualified"), "heart exclamation", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, true);

    /**
     * 💔
     */
    Emoji BROKEN_HEART = new Emoji("💔", "\uD83D\uDC94", Collections.unmodifiableList(Arrays.asList(":broken_heart:", "</3", "<\\3")), Collections.singletonList(":broken_heart:"), Collections.singletonList(":broken_heart:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "broken heart", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, false);

    /**
     * ❤️‍🔥
     */
    Emoji HEART_ON_FIRE = new Emoji("❤️‍🔥", "\u2764\uFE0F\u200D\uD83D\uDD25", Collections.singletonList(":heart_on_fire:"), Collections.emptyList(), Collections.singletonList(":heart_on_fire:"), false, false, 13.1, Qualification.fromString("fully-qualified"), "heart on fire", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, false);

    /**
     * ❤‍🔥
     */
    Emoji HEART_ON_FIRE_UNQUALIFIED = new Emoji("❤‍🔥", "\u2764\u200D\uD83D\uDD25", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 13.1, Qualification.fromString("unqualified"), "heart on fire", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, false);

    /**
     * ❤️‍🩹
     */
    Emoji MENDING_HEART = new Emoji("❤️‍🩹", "\u2764\uFE0F\u200D\uD83E\uDE79", Collections.singletonList(":mending_heart:"), Collections.emptyList(), Collections.singletonList(":mending_heart:"), false, false, 13.1, Qualification.fromString("fully-qualified"), "mending heart", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, false);

    /**
     * ❤‍🩹
     */
    Emoji MENDING_HEART_UNQUALIFIED = new Emoji("❤‍🩹", "\u2764\u200D\uD83E\uDE79", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 13.1, Qualification.fromString("unqualified"), "mending heart", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, false);

    /**
     * ❤️
     */
    Emoji RED_HEART = new Emoji("❤️", "\u2764\uFE0F", Collections.unmodifiableList(Arrays.asList(":heart:", ":red_heart:", "<3", "♡")), Collections.singletonList(":heart:"), Collections.singletonList(":heart:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "red heart", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, false);

    /**
     * ❤
     */
    Emoji RED_HEART_UNQUALIFIED = new Emoji("❤", "\u2764", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":heart:"), false, false, 0.6, Qualification.fromString("unqualified"), "red heart", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, true);

    /**
     * 🩷
     */
    Emoji PINK_HEART = new Emoji("🩷", "\uD83E\uDE77", Collections.singletonList(":pink_heart:"), Collections.emptyList(), Collections.singletonList(":pink_heart:"), false, false, 15.0, Qualification.fromString("fully-qualified"), "pink heart", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, false);

    /**
     * 🧡
     */
    Emoji ORANGE_HEART = new Emoji("🧡", "\uD83E\uDDE1", Collections.singletonList(":orange_heart:"), Collections.singletonList(":orange_heart:"), Collections.singletonList(":orange_heart:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "orange heart", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, false);

    /**
     * 💛
     */
    Emoji YELLOW_HEART = new Emoji("💛", "\uD83D\uDC9B", Collections.singletonList(":yellow_heart:"), Collections.singletonList(":yellow_heart:"), Collections.singletonList(":yellow_heart:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "yellow heart", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, false);

    /**
     * 💚
     */
    Emoji GREEN_HEART = new Emoji("💚", "\uD83D\uDC9A", Collections.singletonList(":green_heart:"), Collections.singletonList(":green_heart:"), Collections.singletonList(":green_heart:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "green heart", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, false);

    /**
     * 💙
     */
    Emoji BLUE_HEART = new Emoji("💙", "\uD83D\uDC99", Collections.singletonList(":blue_heart:"), Collections.singletonList(":blue_heart:"), Collections.singletonList(":blue_heart:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "blue heart", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, false);

    /**
     * 🩵
     */
    Emoji LIGHT_BLUE_HEART = new Emoji("🩵", "\uD83E\uDE75", Collections.singletonList(":light_blue_heart:"), Collections.emptyList(), Collections.singletonList(":light_blue_heart:"), false, false, 15.0, Qualification.fromString("fully-qualified"), "light blue heart", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, false);

    /**
     * 💜
     */
    Emoji PURPLE_HEART = new Emoji("💜", "\uD83D\uDC9C", Collections.singletonList(":purple_heart:"), Collections.singletonList(":purple_heart:"), Collections.singletonList(":purple_heart:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "purple heart", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, false);

    /**
     * 🤎
     */
    Emoji BROWN_HEART = new Emoji("🤎", "\uD83E\uDD0E", Collections.singletonList(":brown_heart:"), Collections.singletonList(":brown_heart:"), Collections.singletonList(":brown_heart:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "brown heart", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, false);

    /**
     * 🖤
     */
    Emoji BLACK_HEART = new Emoji("🖤", "\uD83D\uDDA4", Collections.singletonList(":black_heart:"), Collections.singletonList(":black_heart:"), Collections.singletonList(":black_heart:"), false, false, 3.0, Qualification.fromString("fully-qualified"), "black heart", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, false);

    /**
     * 🩶
     */
    Emoji GREY_HEART = new Emoji("🩶", "\uD83E\uDE76", Collections.singletonList(":grey_heart:"), Collections.emptyList(), Collections.singletonList(":grey_heart:"), false, false, 15.0, Qualification.fromString("fully-qualified"), "grey heart", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, false);

    /**
     * 🤍
     */
    Emoji WHITE_HEART = new Emoji("🤍", "\uD83E\uDD0D", Collections.singletonList(":white_heart:"), Collections.singletonList(":white_heart:"), Collections.singletonList(":white_heart:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "white heart", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.HEART, false);
}
