package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiHandSingleFinger {

    /**
     * 👈
     */
    Emoji BACKHAND_INDEX_POINTING_LEFT = new Emoji("👈", "\uD83D\uDC48", Collections.singletonList(":point_left:"), Collections.singletonList(":point_left:"), Collections.singletonList(":point_left:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "backhand index pointing left", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, true);

    /**
     * 👈🏻
     */
    Emoji BACKHAND_INDEX_POINTING_LEFT_LIGHT_SKIN_TONE = new Emoji("👈🏻", "\uD83D\uDC48\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":point_left_tone1:", ":point_left::skin-tone-1:")), Collections.singletonList(":point_left::skin-tone-2:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "backhand index pointing left: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 👈🏼
     */
    Emoji BACKHAND_INDEX_POINTING_LEFT_MEDIUM_LIGHT_SKIN_TONE = new Emoji("👈🏼", "\uD83D\uDC48\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":point_left_tone2:", ":point_left::skin-tone-2:")), Collections.singletonList(":point_left::skin-tone-3:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "backhand index pointing left: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 👈🏽
     */
    Emoji BACKHAND_INDEX_POINTING_LEFT_MEDIUM_SKIN_TONE = new Emoji("👈🏽", "\uD83D\uDC48\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":point_left_tone3:", ":point_left::skin-tone-3:")), Collections.singletonList(":point_left::skin-tone-4:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "backhand index pointing left: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 👈🏾
     */
    Emoji BACKHAND_INDEX_POINTING_LEFT_MEDIUM_DARK_SKIN_TONE = new Emoji("👈🏾", "\uD83D\uDC48\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":point_left_tone4:", ":point_left::skin-tone-4:")), Collections.singletonList(":point_left::skin-tone-5:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "backhand index pointing left: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 👈🏿
     */
    Emoji BACKHAND_INDEX_POINTING_LEFT_DARK_SKIN_TONE = new Emoji("👈🏿", "\uD83D\uDC48\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":point_left_tone5:", ":point_left::skin-tone-5:")), Collections.singletonList(":point_left::skin-tone-6:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "backhand index pointing left: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 👉
     */
    Emoji BACKHAND_INDEX_POINTING_RIGHT = new Emoji("👉", "\uD83D\uDC49", Collections.singletonList(":point_right:"), Collections.singletonList(":point_right:"), Collections.singletonList(":point_right:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "backhand index pointing right", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, true);

    /**
     * 👉🏻
     */
    Emoji BACKHAND_INDEX_POINTING_RIGHT_LIGHT_SKIN_TONE = new Emoji("👉🏻", "\uD83D\uDC49\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":point_right_tone1:", ":point_right::skin-tone-1:")), Collections.singletonList(":point_right::skin-tone-2:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "backhand index pointing right: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 👉🏼
     */
    Emoji BACKHAND_INDEX_POINTING_RIGHT_MEDIUM_LIGHT_SKIN_TONE = new Emoji("👉🏼", "\uD83D\uDC49\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":point_right_tone2:", ":point_right::skin-tone-2:")), Collections.singletonList(":point_right::skin-tone-3:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "backhand index pointing right: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 👉🏽
     */
    Emoji BACKHAND_INDEX_POINTING_RIGHT_MEDIUM_SKIN_TONE = new Emoji("👉🏽", "\uD83D\uDC49\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":point_right_tone3:", ":point_right::skin-tone-3:")), Collections.singletonList(":point_right::skin-tone-4:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "backhand index pointing right: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 👉🏾
     */
    Emoji BACKHAND_INDEX_POINTING_RIGHT_MEDIUM_DARK_SKIN_TONE = new Emoji("👉🏾", "\uD83D\uDC49\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":point_right_tone4:", ":point_right::skin-tone-4:")), Collections.singletonList(":point_right::skin-tone-5:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "backhand index pointing right: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 👉🏿
     */
    Emoji BACKHAND_INDEX_POINTING_RIGHT_DARK_SKIN_TONE = new Emoji("👉🏿", "\uD83D\uDC49\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":point_right_tone5:", ":point_right::skin-tone-5:")), Collections.singletonList(":point_right::skin-tone-6:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "backhand index pointing right: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 👆
     */
    Emoji BACKHAND_INDEX_POINTING_UP = new Emoji("👆", "\uD83D\uDC46", Collections.singletonList(":point_up_2:"), Collections.singletonList(":point_up_2:"), Collections.singletonList(":point_up_2:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "backhand index pointing up", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, true);

    /**
     * 👆🏻
     */
    Emoji BACKHAND_INDEX_POINTING_UP_LIGHT_SKIN_TONE = new Emoji("👆🏻", "\uD83D\uDC46\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":point_up_2_tone1:", ":point_up_2::skin-tone-1:")), Collections.singletonList(":point_up_2::skin-tone-2:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "backhand index pointing up: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 👆🏼
     */
    Emoji BACKHAND_INDEX_POINTING_UP_MEDIUM_LIGHT_SKIN_TONE = new Emoji("👆🏼", "\uD83D\uDC46\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":point_up_2_tone2:", ":point_up_2::skin-tone-2:")), Collections.singletonList(":point_up_2::skin-tone-3:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "backhand index pointing up: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 👆🏽
     */
    Emoji BACKHAND_INDEX_POINTING_UP_MEDIUM_SKIN_TONE = new Emoji("👆🏽", "\uD83D\uDC46\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":point_up_2_tone3:", ":point_up_2::skin-tone-3:")), Collections.singletonList(":point_up_2::skin-tone-4:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "backhand index pointing up: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 👆🏾
     */
    Emoji BACKHAND_INDEX_POINTING_UP_MEDIUM_DARK_SKIN_TONE = new Emoji("👆🏾", "\uD83D\uDC46\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":point_up_2_tone4:", ":point_up_2::skin-tone-4:")), Collections.singletonList(":point_up_2::skin-tone-5:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "backhand index pointing up: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 👆🏿
     */
    Emoji BACKHAND_INDEX_POINTING_UP_DARK_SKIN_TONE = new Emoji("👆🏿", "\uD83D\uDC46\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":point_up_2_tone5:", ":point_up_2::skin-tone-5:")), Collections.singletonList(":point_up_2::skin-tone-6:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "backhand index pointing up: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 🖕
     */
    Emoji MIDDLE_FINGER = new Emoji("🖕", "\uD83D\uDD95", Collections.unmodifiableList(Arrays.asList(":middle_finger:", ":reversed_hand_with_middle_finger_extended:")), Collections.singletonList(":middle_finger:"), Collections.unmodifiableList(Arrays.asList(":fu:", ":middle_finger:")), false, false, 1.0, Qualification.fromString("fully-qualified"), "middle finger", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 🖕🏻
     */
    Emoji MIDDLE_FINGER_LIGHT_SKIN_TONE = new Emoji("🖕🏻", "\uD83D\uDD95\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":middle_finger_tone1:", ":reversed_hand_with_middle_finger_extended_tone1:", ":middle_finger::skin-tone-1:", ":reversed_hand_with_middle_finger_extended::skin-tone-1:")), Collections.singletonList(":middle_finger::skin-tone-2:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "middle finger: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 🖕🏼
     */
    Emoji MIDDLE_FINGER_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🖕🏼", "\uD83D\uDD95\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":middle_finger_tone2:", ":reversed_hand_with_middle_finger_extended_tone2:", ":middle_finger::skin-tone-2:", ":reversed_hand_with_middle_finger_extended::skin-tone-2:")), Collections.singletonList(":middle_finger::skin-tone-3:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "middle finger: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 🖕🏽
     */
    Emoji MIDDLE_FINGER_MEDIUM_SKIN_TONE = new Emoji("🖕🏽", "\uD83D\uDD95\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":middle_finger_tone3:", ":reversed_hand_with_middle_finger_extended_tone3:", ":middle_finger::skin-tone-3:", ":reversed_hand_with_middle_finger_extended::skin-tone-3:")), Collections.singletonList(":middle_finger::skin-tone-4:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "middle finger: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 🖕🏾
     */
    Emoji MIDDLE_FINGER_MEDIUM_DARK_SKIN_TONE = new Emoji("🖕🏾", "\uD83D\uDD95\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":middle_finger_tone4:", ":reversed_hand_with_middle_finger_extended_tone4:", ":middle_finger::skin-tone-4:", ":reversed_hand_with_middle_finger_extended::skin-tone-4:")), Collections.singletonList(":middle_finger::skin-tone-5:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "middle finger: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 🖕🏿
     */
    Emoji MIDDLE_FINGER_DARK_SKIN_TONE = new Emoji("🖕🏿", "\uD83D\uDD95\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":middle_finger_tone5:", ":reversed_hand_with_middle_finger_extended_tone5:", ":middle_finger::skin-tone-5:", ":reversed_hand_with_middle_finger_extended::skin-tone-5:")), Collections.singletonList(":middle_finger::skin-tone-6:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "middle finger: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 👇
     */
    Emoji BACKHAND_INDEX_POINTING_DOWN = new Emoji("👇", "\uD83D\uDC47", Collections.singletonList(":point_down:"), Collections.singletonList(":point_down:"), Collections.singletonList(":point_down:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "backhand index pointing down", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, true);

    /**
     * 👇🏻
     */
    Emoji BACKHAND_INDEX_POINTING_DOWN_LIGHT_SKIN_TONE = new Emoji("👇🏻", "\uD83D\uDC47\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":point_down_tone1:", ":point_down::skin-tone-1:")), Collections.singletonList(":point_down::skin-tone-2:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "backhand index pointing down: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 👇🏼
     */
    Emoji BACKHAND_INDEX_POINTING_DOWN_MEDIUM_LIGHT_SKIN_TONE = new Emoji("👇🏼", "\uD83D\uDC47\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":point_down_tone2:", ":point_down::skin-tone-2:")), Collections.singletonList(":point_down::skin-tone-3:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "backhand index pointing down: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 👇🏽
     */
    Emoji BACKHAND_INDEX_POINTING_DOWN_MEDIUM_SKIN_TONE = new Emoji("👇🏽", "\uD83D\uDC47\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":point_down_tone3:", ":point_down::skin-tone-3:")), Collections.singletonList(":point_down::skin-tone-4:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "backhand index pointing down: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 👇🏾
     */
    Emoji BACKHAND_INDEX_POINTING_DOWN_MEDIUM_DARK_SKIN_TONE = new Emoji("👇🏾", "\uD83D\uDC47\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":point_down_tone4:", ":point_down::skin-tone-4:")), Collections.singletonList(":point_down::skin-tone-5:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "backhand index pointing down: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 👇🏿
     */
    Emoji BACKHAND_INDEX_POINTING_DOWN_DARK_SKIN_TONE = new Emoji("👇🏿", "\uD83D\uDC47\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":point_down_tone5:", ":point_down::skin-tone-5:")), Collections.singletonList(":point_down::skin-tone-6:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "backhand index pointing down: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * ☝️
     */
    Emoji INDEX_POINTING_UP = new Emoji("☝️", "\u261D\uFE0F", Collections.singletonList(":point_up:"), Collections.singletonList(":point_up:"), Collections.singletonList(":point_up:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "index pointing up", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * ☝
     */
    Emoji INDEX_POINTING_UP_UNQUALIFIED = new Emoji("☝", "\u261D", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":point_up:"), false, false, 0.6, Qualification.fromString("unqualified"), "index pointing up", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, true);

    /**
     * ☝🏻
     */
    Emoji INDEX_POINTING_UP_LIGHT_SKIN_TONE = new Emoji("☝🏻", "\u261D\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":point_up_tone1:", ":point_up::skin-tone-1:")), Collections.singletonList(":point_up::skin-tone-2:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "index pointing up: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * ☝🏼
     */
    Emoji INDEX_POINTING_UP_MEDIUM_LIGHT_SKIN_TONE = new Emoji("☝🏼", "\u261D\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":point_up_tone2:", ":point_up::skin-tone-2:")), Collections.singletonList(":point_up::skin-tone-3:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "index pointing up: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * ☝🏽
     */
    Emoji INDEX_POINTING_UP_MEDIUM_SKIN_TONE = new Emoji("☝🏽", "\u261D\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":point_up_tone3:", ":point_up::skin-tone-3:")), Collections.singletonList(":point_up::skin-tone-4:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "index pointing up: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * ☝🏾
     */
    Emoji INDEX_POINTING_UP_MEDIUM_DARK_SKIN_TONE = new Emoji("☝🏾", "\u261D\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":point_up_tone4:", ":point_up::skin-tone-4:")), Collections.singletonList(":point_up::skin-tone-5:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "index pointing up: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * ☝🏿
     */
    Emoji INDEX_POINTING_UP_DARK_SKIN_TONE = new Emoji("☝🏿", "\u261D\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":point_up_tone5:", ":point_up::skin-tone-5:")), Collections.singletonList(":point_up::skin-tone-6:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "index pointing up: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 🫵
     */
    Emoji INDEX_POINTING_AT_THE_VIEWER = new Emoji("🫵", "\uD83E\uDEF5", Collections.singletonList(":index_pointing_at_the_viewer:"), Collections.emptyList(), Collections.singletonList(":index_pointing_at_the_viewer:"), false, false, 14.0, Qualification.fromString("fully-qualified"), "index pointing at the viewer", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 🫵🏻
     */
    Emoji INDEX_POINTING_AT_THE_VIEWER_LIGHT_SKIN_TONE = new Emoji("🫵🏻", "\uD83E\uDEF5\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":index_pointing_at_the_viewer_tone1:", ":index_pointing_at_the_viewer_light_skin_tone:", ":index_pointing_at_the_viewer::skin-tone-1:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "index pointing at the viewer: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 🫵🏼
     */
    Emoji INDEX_POINTING_AT_THE_VIEWER_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🫵🏼", "\uD83E\uDEF5\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":index_pointing_at_the_viewer_tone2:", ":index_pointing_at_the_viewer_medium_light_skin_tone:", ":index_pointing_at_the_viewer::skin-tone-2:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "index pointing at the viewer: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 🫵🏽
     */
    Emoji INDEX_POINTING_AT_THE_VIEWER_MEDIUM_SKIN_TONE = new Emoji("🫵🏽", "\uD83E\uDEF5\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":index_pointing_at_the_viewer_tone3:", ":index_pointing_at_the_viewer_medium_skin_tone:", ":index_pointing_at_the_viewer::skin-tone-3:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "index pointing at the viewer: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 🫵🏾
     */
    Emoji INDEX_POINTING_AT_THE_VIEWER_MEDIUM_DARK_SKIN_TONE = new Emoji("🫵🏾", "\uD83E\uDEF5\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":index_pointing_at_the_viewer_tone4:", ":index_pointing_at_the_viewer_medium_dark_skin_tone:", ":index_pointing_at_the_viewer::skin-tone-4:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "index pointing at the viewer: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);

    /**
     * 🫵🏿
     */
    Emoji INDEX_POINTING_AT_THE_VIEWER_DARK_SKIN_TONE = new Emoji("🫵🏿", "\uD83E\uDEF5\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":index_pointing_at_the_viewer_tone5:", ":index_pointing_at_the_viewer_dark_skin_tone:", ":index_pointing_at_the_viewer::skin-tone-5:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "index pointing at the viewer: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_SINGLE_FINGER, false);
}
