package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiHandFingersPartial {

    /**
     * 👌
     */
    Emoji OK_HAND = new Emoji("👌", "\uD83D\uDC4C", Collections.singletonList(":ok_hand:"), Collections.singletonList(":ok_hand:"), Collections.singletonList(":ok_hand:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "OK hand", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 👌🏻
     */
    Emoji OK_HAND_LIGHT_SKIN_TONE = new Emoji("👌🏻", "\uD83D\uDC4C\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":ok_hand_tone1:", ":ok_hand::skin-tone-1:")), Collections.singletonList(":ok_hand::skin-tone-2:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "OK hand: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 👌🏼
     */
    Emoji OK_HAND_MEDIUM_LIGHT_SKIN_TONE = new Emoji("👌🏼", "\uD83D\uDC4C\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":ok_hand_tone2:", ":ok_hand::skin-tone-2:")), Collections.singletonList(":ok_hand::skin-tone-3:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "OK hand: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 👌🏽
     */
    Emoji OK_HAND_MEDIUM_SKIN_TONE = new Emoji("👌🏽", "\uD83D\uDC4C\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":ok_hand_tone3:", ":ok_hand::skin-tone-3:")), Collections.singletonList(":ok_hand::skin-tone-4:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "OK hand: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 👌🏾
     */
    Emoji OK_HAND_MEDIUM_DARK_SKIN_TONE = new Emoji("👌🏾", "\uD83D\uDC4C\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":ok_hand_tone4:", ":ok_hand::skin-tone-4:")), Collections.singletonList(":ok_hand::skin-tone-5:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "OK hand: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 👌🏿
     */
    Emoji OK_HAND_DARK_SKIN_TONE = new Emoji("👌🏿", "\uD83D\uDC4C\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":ok_hand_tone5:", ":ok_hand::skin-tone-5:")), Collections.singletonList(":ok_hand::skin-tone-6:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "OK hand: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤌
     */
    Emoji PINCHED_FINGERS = new Emoji("🤌", "\uD83E\uDD0C", Collections.singletonList(":pinched_fingers:"), Collections.singletonList(":pinched_fingers:"), Collections.singletonList(":pinched_fingers:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "pinched fingers", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤌🏻
     */
    Emoji PINCHED_FINGERS_LIGHT_SKIN_TONE = new Emoji("🤌🏻", "\uD83E\uDD0C\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":pinched_fingers_tone1:", ":pinched_fingers_light_skin_tone:", ":pinched_fingers::skin-tone-1:")), Collections.singletonList(":pinched_fingers::skin-tone-2:"), Collections.emptyList(), true, false, 13.0, Qualification.fromString("fully-qualified"), "pinched fingers: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤌🏼
     */
    Emoji PINCHED_FINGERS_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🤌🏼", "\uD83E\uDD0C\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":pinched_fingers_tone2:", ":pinched_fingers_medium_light_skin_tone:", ":pinched_fingers::skin-tone-2:")), Collections.singletonList(":pinched_fingers::skin-tone-3:"), Collections.emptyList(), true, false, 13.0, Qualification.fromString("fully-qualified"), "pinched fingers: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤌🏽
     */
    Emoji PINCHED_FINGERS_MEDIUM_SKIN_TONE = new Emoji("🤌🏽", "\uD83E\uDD0C\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":pinched_fingers_tone3:", ":pinched_fingers_medium_skin_tone:", ":pinched_fingers::skin-tone-3:")), Collections.singletonList(":pinched_fingers::skin-tone-4:"), Collections.emptyList(), true, false, 13.0, Qualification.fromString("fully-qualified"), "pinched fingers: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤌🏾
     */
    Emoji PINCHED_FINGERS_MEDIUM_DARK_SKIN_TONE = new Emoji("🤌🏾", "\uD83E\uDD0C\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":pinched_fingers_tone4:", ":pinched_fingers_medium_dark_skin_tone:", ":pinched_fingers::skin-tone-4:")), Collections.singletonList(":pinched_fingers::skin-tone-5:"), Collections.emptyList(), true, false, 13.0, Qualification.fromString("fully-qualified"), "pinched fingers: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤌🏿
     */
    Emoji PINCHED_FINGERS_DARK_SKIN_TONE = new Emoji("🤌🏿", "\uD83E\uDD0C\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":pinched_fingers_tone5:", ":pinched_fingers_dark_skin_tone:", ":pinched_fingers::skin-tone-5:")), Collections.singletonList(":pinched_fingers::skin-tone-6:"), Collections.emptyList(), true, false, 13.0, Qualification.fromString("fully-qualified"), "pinched fingers: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤏
     */
    Emoji PINCHING_HAND = new Emoji("🤏", "\uD83E\uDD0F", Collections.singletonList(":pinching_hand:"), Collections.singletonList(":pinching_hand:"), Collections.singletonList(":pinching_hand:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "pinching hand", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤏🏻
     */
    Emoji PINCHING_HAND_LIGHT_SKIN_TONE = new Emoji("🤏🏻", "\uD83E\uDD0F\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":pinching_hand_tone1:", ":pinching_hand_light_skin_tone:", ":pinching_hand::skin-tone-1:")), Collections.singletonList(":pinching_hand::skin-tone-2:"), Collections.emptyList(), true, false, 12.0, Qualification.fromString("fully-qualified"), "pinching hand: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤏🏼
     */
    Emoji PINCHING_HAND_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🤏🏼", "\uD83E\uDD0F\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":pinching_hand_tone2:", ":pinching_hand_medium_light_skin_tone:", ":pinching_hand::skin-tone-2:")), Collections.singletonList(":pinching_hand::skin-tone-3:"), Collections.emptyList(), true, false, 12.0, Qualification.fromString("fully-qualified"), "pinching hand: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤏🏽
     */
    Emoji PINCHING_HAND_MEDIUM_SKIN_TONE = new Emoji("🤏🏽", "\uD83E\uDD0F\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":pinching_hand_tone3:", ":pinching_hand_medium_skin_tone:", ":pinching_hand::skin-tone-3:")), Collections.singletonList(":pinching_hand::skin-tone-4:"), Collections.emptyList(), true, false, 12.0, Qualification.fromString("fully-qualified"), "pinching hand: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤏🏾
     */
    Emoji PINCHING_HAND_MEDIUM_DARK_SKIN_TONE = new Emoji("🤏🏾", "\uD83E\uDD0F\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":pinching_hand_tone4:", ":pinching_hand_medium_dark_skin_tone:", ":pinching_hand::skin-tone-4:")), Collections.singletonList(":pinching_hand::skin-tone-5:"), Collections.emptyList(), true, false, 12.0, Qualification.fromString("fully-qualified"), "pinching hand: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤏🏿
     */
    Emoji PINCHING_HAND_DARK_SKIN_TONE = new Emoji("🤏🏿", "\uD83E\uDD0F\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":pinching_hand_tone5:", ":pinching_hand_dark_skin_tone:", ":pinching_hand::skin-tone-5:")), Collections.singletonList(":pinching_hand::skin-tone-6:"), Collections.emptyList(), true, false, 12.0, Qualification.fromString("fully-qualified"), "pinching hand: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * ✌️
     */
    Emoji VICTORY_HAND = new Emoji("✌️", "\u270C\uFE0F", Collections.unmodifiableList(Arrays.asList(":v:", ":victory_hand:")), Collections.singletonList(":v:"), Collections.singletonList(":v:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "victory hand", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * ✌
     */
    Emoji VICTORY_HAND_UNQUALIFIED = new Emoji("✌", "\u270C", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":v:"), false, false, 0.6, Qualification.fromString("unqualified"), "victory hand", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, true);

    /**
     * ✌🏻
     */
    Emoji VICTORY_HAND_LIGHT_SKIN_TONE = new Emoji("✌🏻", "\u270C\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":v_tone1:", ":v::skin-tone-1:", ":victory_hand::skin-tone-1:")), Collections.singletonList(":v::skin-tone-2:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "victory hand: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * ✌🏼
     */
    Emoji VICTORY_HAND_MEDIUM_LIGHT_SKIN_TONE = new Emoji("✌🏼", "\u270C\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":v_tone2:", ":v::skin-tone-2:", ":victory_hand::skin-tone-2:")), Collections.singletonList(":v::skin-tone-3:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "victory hand: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * ✌🏽
     */
    Emoji VICTORY_HAND_MEDIUM_SKIN_TONE = new Emoji("✌🏽", "\u270C\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":v_tone3:", ":v::skin-tone-3:", ":victory_hand::skin-tone-3:")), Collections.singletonList(":v::skin-tone-4:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "victory hand: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * ✌🏾
     */
    Emoji VICTORY_HAND_MEDIUM_DARK_SKIN_TONE = new Emoji("✌🏾", "\u270C\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":v_tone4:", ":v::skin-tone-4:", ":victory_hand::skin-tone-4:")), Collections.singletonList(":v::skin-tone-5:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "victory hand: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * ✌🏿
     */
    Emoji VICTORY_HAND_DARK_SKIN_TONE = new Emoji("✌🏿", "\u270C\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":v_tone5:", ":v::skin-tone-5:", ":victory_hand::skin-tone-5:")), Collections.singletonList(":v::skin-tone-6:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "victory hand: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤞
     */
    Emoji CROSSED_FINGERS = new Emoji("🤞", "\uD83E\uDD1E", Collections.unmodifiableList(Arrays.asList(":fingers_crossed:", ":hand_with_index_and_middle_finger_crossed:")), Collections.singletonList(":crossed_fingers:"), Collections.singletonList(":crossed_fingers:"), false, false, 3.0, Qualification.fromString("fully-qualified"), "crossed fingers", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤞🏻
     */
    Emoji CROSSED_FINGERS_LIGHT_SKIN_TONE = new Emoji("🤞🏻", "\uD83E\uDD1E\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":fingers_crossed_tone1:", ":hand_with_index_and_middle_fingers_crossed_tone1:", ":fingers_crossed::skin-tone-1:", ":hand_with_index_and_middle_finger_crossed::skin-tone-1:")), Collections.singletonList(":crossed_fingers::skin-tone-2:"), Collections.emptyList(), true, false, 3.0, Qualification.fromString("fully-qualified"), "crossed fingers: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤞🏼
     */
    Emoji CROSSED_FINGERS_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🤞🏼", "\uD83E\uDD1E\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":fingers_crossed_tone2:", ":hand_with_index_and_middle_fingers_crossed_tone2:", ":fingers_crossed::skin-tone-2:", ":hand_with_index_and_middle_finger_crossed::skin-tone-2:")), Collections.singletonList(":crossed_fingers::skin-tone-3:"), Collections.emptyList(), true, false, 3.0, Qualification.fromString("fully-qualified"), "crossed fingers: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤞🏽
     */
    Emoji CROSSED_FINGERS_MEDIUM_SKIN_TONE = new Emoji("🤞🏽", "\uD83E\uDD1E\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":fingers_crossed_tone3:", ":hand_with_index_and_middle_fingers_crossed_tone3:", ":fingers_crossed::skin-tone-3:", ":hand_with_index_and_middle_finger_crossed::skin-tone-3:")), Collections.singletonList(":crossed_fingers::skin-tone-4:"), Collections.emptyList(), true, false, 3.0, Qualification.fromString("fully-qualified"), "crossed fingers: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤞🏾
     */
    Emoji CROSSED_FINGERS_MEDIUM_DARK_SKIN_TONE = new Emoji("🤞🏾", "\uD83E\uDD1E\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":fingers_crossed_tone4:", ":hand_with_index_and_middle_fingers_crossed_tone4:", ":fingers_crossed::skin-tone-4:", ":hand_with_index_and_middle_finger_crossed::skin-tone-4:")), Collections.singletonList(":crossed_fingers::skin-tone-5:"), Collections.emptyList(), true, false, 3.0, Qualification.fromString("fully-qualified"), "crossed fingers: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤞🏿
     */
    Emoji CROSSED_FINGERS_DARK_SKIN_TONE = new Emoji("🤞🏿", "\uD83E\uDD1E\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":fingers_crossed_tone5:", ":hand_with_index_and_middle_fingers_crossed_tone5:", ":fingers_crossed::skin-tone-5:", ":hand_with_index_and_middle_finger_crossed::skin-tone-5:")), Collections.singletonList(":crossed_fingers::skin-tone-6:"), Collections.emptyList(), true, false, 3.0, Qualification.fromString("fully-qualified"), "crossed fingers: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🫰
     */
    Emoji HAND_WITH_INDEX_FINGER_AND_THUMB_CROSSED = new Emoji("🫰", "\uD83E\uDEF0", Collections.singletonList(":hand_with_index_finger_and_thumb_crossed:"), Collections.emptyList(), Collections.singletonList(":hand_with_index_finger_and_thumb_crossed:"), false, false, 14.0, Qualification.fromString("fully-qualified"), "hand with index finger and thumb crossed", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🫰🏻
     */
    Emoji HAND_WITH_INDEX_FINGER_AND_THUMB_CROSSED_LIGHT_SKIN_TONE = new Emoji("🫰🏻", "\uD83E\uDEF0\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":hand_with_index_finger_and_thumb_crossed_tone1:", ":hand_with_index_finger_and_thumb_crossed_light_skin_tone:", ":hand_with_index_finger_and_thumb_crossed::skin-tone-1:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "hand with index finger and thumb crossed: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🫰🏼
     */
    Emoji HAND_WITH_INDEX_FINGER_AND_THUMB_CROSSED_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🫰🏼", "\uD83E\uDEF0\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":hand_with_index_finger_and_thumb_crossed_tone2:", ":hand_with_index_finger_and_thumb_crossed_medium_light_skin_tone:", ":hand_with_index_finger_and_thumb_crossed::skin-tone-2:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "hand with index finger and thumb crossed: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🫰🏽
     */
    Emoji HAND_WITH_INDEX_FINGER_AND_THUMB_CROSSED_MEDIUM_SKIN_TONE = new Emoji("🫰🏽", "\uD83E\uDEF0\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":hand_with_index_finger_and_thumb_crossed_tone3:", ":hand_with_index_finger_and_thumb_crossed_medium_skin_tone:", ":hand_with_index_finger_and_thumb_crossed::skin-tone-3:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "hand with index finger and thumb crossed: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🫰🏾
     */
    Emoji HAND_WITH_INDEX_FINGER_AND_THUMB_CROSSED_MEDIUM_DARK_SKIN_TONE = new Emoji("🫰🏾", "\uD83E\uDEF0\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":hand_with_index_finger_and_thumb_crossed_tone4:", ":hand_with_index_finger_and_thumb_crossed_medium_dark_skin_tone:", ":hand_with_index_finger_and_thumb_crossed::skin-tone-4:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "hand with index finger and thumb crossed: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🫰🏿
     */
    Emoji HAND_WITH_INDEX_FINGER_AND_THUMB_CROSSED_DARK_SKIN_TONE = new Emoji("🫰🏿", "\uD83E\uDEF0\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":hand_with_index_finger_and_thumb_crossed_tone5:", ":hand_with_index_finger_and_thumb_crossed_dark_skin_tone:", ":hand_with_index_finger_and_thumb_crossed::skin-tone-5:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "hand with index finger and thumb crossed: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤟
     */
    Emoji LOVE_YOU_GESTURE = new Emoji("🤟", "\uD83E\uDD1F", Collections.singletonList(":love_you_gesture:"), Collections.singletonList(":i_love_you_hand_sign:"), Collections.singletonList(":love_you_gesture:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "love-you gesture", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤟🏻
     */
    Emoji LOVE_YOU_GESTURE_LIGHT_SKIN_TONE = new Emoji("🤟🏻", "\uD83E\uDD1F\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":love_you_gesture_tone1:", ":love_you_gesture_light_skin_tone:", ":love_you_gesture::skin-tone-1:")), Collections.singletonList(":i_love_you_hand_sign::skin-tone-2:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "love-you gesture: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤟🏼
     */
    Emoji LOVE_YOU_GESTURE_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🤟🏼", "\uD83E\uDD1F\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":love_you_gesture_tone2:", ":love_you_gesture_medium_light_skin_tone:", ":love_you_gesture::skin-tone-2:")), Collections.singletonList(":i_love_you_hand_sign::skin-tone-3:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "love-you gesture: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤟🏽
     */
    Emoji LOVE_YOU_GESTURE_MEDIUM_SKIN_TONE = new Emoji("🤟🏽", "\uD83E\uDD1F\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":love_you_gesture_tone3:", ":love_you_gesture_medium_skin_tone:", ":love_you_gesture::skin-tone-3:")), Collections.singletonList(":i_love_you_hand_sign::skin-tone-4:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "love-you gesture: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤟🏾
     */
    Emoji LOVE_YOU_GESTURE_MEDIUM_DARK_SKIN_TONE = new Emoji("🤟🏾", "\uD83E\uDD1F\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":love_you_gesture_tone4:", ":love_you_gesture_medium_dark_skin_tone:", ":love_you_gesture::skin-tone-4:")), Collections.singletonList(":i_love_you_hand_sign::skin-tone-5:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "love-you gesture: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤟🏿
     */
    Emoji LOVE_YOU_GESTURE_DARK_SKIN_TONE = new Emoji("🤟🏿", "\uD83E\uDD1F\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":love_you_gesture_tone5:", ":love_you_gesture_dark_skin_tone:", ":love_you_gesture::skin-tone-5:")), Collections.singletonList(":i_love_you_hand_sign::skin-tone-6:"), Collections.emptyList(), true, false, 5.0, Qualification.fromString("fully-qualified"), "love-you gesture: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤘
     */
    Emoji SIGN_OF_THE_HORNS = new Emoji("🤘", "\uD83E\uDD18", Collections.unmodifiableList(Arrays.asList(":metal:", ":sign_of_the_horns:")), Collections.singletonList(":the_horns:"), Collections.singletonList(":metal:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "sign of the horns", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤘🏻
     */
    Emoji SIGN_OF_THE_HORNS_LIGHT_SKIN_TONE = new Emoji("🤘🏻", "\uD83E\uDD18\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":metal_tone1:", ":sign_of_the_horns_tone1:", ":metal::skin-tone-1:", ":sign_of_the_horns::skin-tone-1:")), Collections.singletonList(":the_horns::skin-tone-2:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "sign of the horns: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤘🏼
     */
    Emoji SIGN_OF_THE_HORNS_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🤘🏼", "\uD83E\uDD18\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":metal_tone2:", ":sign_of_the_horns_tone2:", ":metal::skin-tone-2:", ":sign_of_the_horns::skin-tone-2:")), Collections.singletonList(":the_horns::skin-tone-3:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "sign of the horns: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤘🏽
     */
    Emoji SIGN_OF_THE_HORNS_MEDIUM_SKIN_TONE = new Emoji("🤘🏽", "\uD83E\uDD18\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":metal_tone3:", ":sign_of_the_horns_tone3:", ":metal::skin-tone-3:", ":sign_of_the_horns::skin-tone-3:")), Collections.singletonList(":the_horns::skin-tone-4:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "sign of the horns: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤘🏾
     */
    Emoji SIGN_OF_THE_HORNS_MEDIUM_DARK_SKIN_TONE = new Emoji("🤘🏾", "\uD83E\uDD18\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":metal_tone4:", ":sign_of_the_horns_tone4:", ":metal::skin-tone-4:", ":sign_of_the_horns::skin-tone-4:")), Collections.singletonList(":the_horns::skin-tone-5:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "sign of the horns: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤘🏿
     */
    Emoji SIGN_OF_THE_HORNS_DARK_SKIN_TONE = new Emoji("🤘🏿", "\uD83E\uDD18\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":metal_tone5:", ":sign_of_the_horns_tone5:", ":metal::skin-tone-5:", ":sign_of_the_horns::skin-tone-5:")), Collections.singletonList(":the_horns::skin-tone-6:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "sign of the horns: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤙
     */
    Emoji CALL_ME_HAND = new Emoji("🤙", "\uD83E\uDD19", Collections.unmodifiableList(Arrays.asList(":call_me:", ":call_me_hand:")), Collections.singletonList(":call_me_hand:"), Collections.singletonList(":call_me_hand:"), false, false, 3.0, Qualification.fromString("fully-qualified"), "call me hand", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤙🏻
     */
    Emoji CALL_ME_HAND_LIGHT_SKIN_TONE = new Emoji("🤙🏻", "\uD83E\uDD19\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":call_me_tone1:", ":call_me_hand_tone1:", ":call_me::skin-tone-1:", ":call_me_hand::skin-tone-1:")), Collections.singletonList(":call_me_hand::skin-tone-2:"), Collections.emptyList(), true, false, 3.0, Qualification.fromString("fully-qualified"), "call me hand: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤙🏼
     */
    Emoji CALL_ME_HAND_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🤙🏼", "\uD83E\uDD19\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":call_me_tone2:", ":call_me_hand_tone2:", ":call_me::skin-tone-2:", ":call_me_hand::skin-tone-2:")), Collections.singletonList(":call_me_hand::skin-tone-3:"), Collections.emptyList(), true, false, 3.0, Qualification.fromString("fully-qualified"), "call me hand: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤙🏽
     */
    Emoji CALL_ME_HAND_MEDIUM_SKIN_TONE = new Emoji("🤙🏽", "\uD83E\uDD19\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":call_me_tone3:", ":call_me_hand_tone3:", ":call_me::skin-tone-3:", ":call_me_hand::skin-tone-3:")), Collections.singletonList(":call_me_hand::skin-tone-4:"), Collections.emptyList(), true, false, 3.0, Qualification.fromString("fully-qualified"), "call me hand: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤙🏾
     */
    Emoji CALL_ME_HAND_MEDIUM_DARK_SKIN_TONE = new Emoji("🤙🏾", "\uD83E\uDD19\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":call_me_tone4:", ":call_me_hand_tone4:", ":call_me::skin-tone-4:", ":call_me_hand::skin-tone-4:")), Collections.singletonList(":call_me_hand::skin-tone-5:"), Collections.emptyList(), true, false, 3.0, Qualification.fromString("fully-qualified"), "call me hand: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);

    /**
     * 🤙🏿
     */
    Emoji CALL_ME_HAND_DARK_SKIN_TONE = new Emoji("🤙🏿", "\uD83E\uDD19\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":call_me_tone5:", ":call_me_hand_tone5:", ":call_me::skin-tone-5:", ":call_me_hand::skin-tone-5:")), Collections.singletonList(":call_me_hand::skin-tone-6:"), Collections.emptyList(), true, false, 3.0, Qualification.fromString("fully-qualified"), "call me hand: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_PARTIAL, false);
}
