package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiHandFingersOpen {

    /**
     * 👋
     */
    Emoji WAVING_HAND = new Emoji("👋", "\uD83D\uDC4B", Collections.unmodifiableList(Arrays.asList(":wave:", ":waving_hand:")), Collections.singletonList(":wave:"), Collections.singletonList(":wave:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "waving hand", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 👋🏻
     */
    Emoji WAVING_HAND_LIGHT_SKIN_TONE = new Emoji("👋🏻", "\uD83D\uDC4B\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":wave_tone1:", ":wave::skin-tone-1:", ":waving_hand::skin-tone-1:")), Collections.singletonList(":wave::skin-tone-2:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "waving hand: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 👋🏼
     */
    Emoji WAVING_HAND_MEDIUM_LIGHT_SKIN_TONE = new Emoji("👋🏼", "\uD83D\uDC4B\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":wave_tone2:", ":wave::skin-tone-2:", ":waving_hand::skin-tone-2:")), Collections.singletonList(":wave::skin-tone-3:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "waving hand: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 👋🏽
     */
    Emoji WAVING_HAND_MEDIUM_SKIN_TONE = new Emoji("👋🏽", "\uD83D\uDC4B\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":wave_tone3:", ":wave::skin-tone-3:", ":waving_hand::skin-tone-3:")), Collections.singletonList(":wave::skin-tone-4:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "waving hand: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 👋🏾
     */
    Emoji WAVING_HAND_MEDIUM_DARK_SKIN_TONE = new Emoji("👋🏾", "\uD83D\uDC4B\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":wave_tone4:", ":wave::skin-tone-4:", ":waving_hand::skin-tone-4:")), Collections.singletonList(":wave::skin-tone-5:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "waving hand: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 👋🏿
     */
    Emoji WAVING_HAND_DARK_SKIN_TONE = new Emoji("👋🏿", "\uD83D\uDC4B\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":wave_tone5:", ":wave::skin-tone-5:", ":waving_hand::skin-tone-5:")), Collections.singletonList(":wave::skin-tone-6:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "waving hand: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🤚
     */
    Emoji RAISED_BACK_OF_HAND = new Emoji("🤚", "\uD83E\uDD1A", Collections.unmodifiableList(Arrays.asList(":raised_back_of_hand:", ":back_of_hand:")), Collections.singletonList(":raised_back_of_hand:"), Collections.singletonList(":raised_back_of_hand:"), false, false, 3.0, Qualification.fromString("fully-qualified"), "raised back of hand", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🤚🏻
     */
    Emoji RAISED_BACK_OF_HAND_LIGHT_SKIN_TONE = new Emoji("🤚🏻", "\uD83E\uDD1A\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":raised_back_of_hand_tone1:", ":back_of_hand_tone1:", ":raised_back_of_hand::skin-tone-1:", ":back_of_hand::skin-tone-1:")), Collections.singletonList(":raised_back_of_hand::skin-tone-2:"), Collections.emptyList(), true, false, 3.0, Qualification.fromString("fully-qualified"), "raised back of hand: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🤚🏼
     */
    Emoji RAISED_BACK_OF_HAND_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🤚🏼", "\uD83E\uDD1A\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":raised_back_of_hand_tone2:", ":back_of_hand_tone2:", ":raised_back_of_hand::skin-tone-2:", ":back_of_hand::skin-tone-2:")), Collections.singletonList(":raised_back_of_hand::skin-tone-3:"), Collections.emptyList(), true, false, 3.0, Qualification.fromString("fully-qualified"), "raised back of hand: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🤚🏽
     */
    Emoji RAISED_BACK_OF_HAND_MEDIUM_SKIN_TONE = new Emoji("🤚🏽", "\uD83E\uDD1A\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":raised_back_of_hand_tone3:", ":back_of_hand_tone3:", ":raised_back_of_hand::skin-tone-3:", ":back_of_hand::skin-tone-3:")), Collections.singletonList(":raised_back_of_hand::skin-tone-4:"), Collections.emptyList(), true, false, 3.0, Qualification.fromString("fully-qualified"), "raised back of hand: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🤚🏾
     */
    Emoji RAISED_BACK_OF_HAND_MEDIUM_DARK_SKIN_TONE = new Emoji("🤚🏾", "\uD83E\uDD1A\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":raised_back_of_hand_tone4:", ":back_of_hand_tone4:", ":raised_back_of_hand::skin-tone-4:", ":back_of_hand::skin-tone-4:")), Collections.singletonList(":raised_back_of_hand::skin-tone-5:"), Collections.emptyList(), true, false, 3.0, Qualification.fromString("fully-qualified"), "raised back of hand: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🤚🏿
     */
    Emoji RAISED_BACK_OF_HAND_DARK_SKIN_TONE = new Emoji("🤚🏿", "\uD83E\uDD1A\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":raised_back_of_hand_tone5:", ":back_of_hand_tone5:", ":raised_back_of_hand::skin-tone-5:", ":back_of_hand::skin-tone-5:")), Collections.singletonList(":raised_back_of_hand::skin-tone-6:"), Collections.emptyList(), true, false, 3.0, Qualification.fromString("fully-qualified"), "raised back of hand: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🖐️
     */
    Emoji HAND_WITH_FINGERS_SPLAYED = new Emoji("🖐️", "\uD83D\uDD90\uFE0F", Collections.unmodifiableList(Arrays.asList(":hand_splayed:", ":raised_hand_with_fingers_splayed:")), Collections.singletonList(":raised_hand_with_fingers_splayed:"), Collections.singletonList(":raised_hand_with_fingers_splayed:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "hand with fingers splayed", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🖐
     */
    Emoji HAND_WITH_FINGERS_SPLAYED_UNQUALIFIED = new Emoji("🖐", "\uD83D\uDD90", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":raised_hand_with_fingers_splayed:"), false, false, 0.7, Qualification.fromString("unqualified"), "hand with fingers splayed", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, true);

    /**
     * 🖐🏻
     */
    Emoji HAND_WITH_FINGERS_SPLAYED_LIGHT_SKIN_TONE = new Emoji("🖐🏻", "\uD83D\uDD90\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":hand_splayed_tone1:", ":raised_hand_with_fingers_splayed_tone1:", ":hand_splayed::skin-tone-1:", ":raised_hand_with_fingers_splayed::skin-tone-1:")), Collections.singletonList(":raised_hand_with_fingers_splayed::skin-tone-2:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "hand with fingers splayed: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🖐🏼
     */
    Emoji HAND_WITH_FINGERS_SPLAYED_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🖐🏼", "\uD83D\uDD90\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":hand_splayed_tone2:", ":raised_hand_with_fingers_splayed_tone2:", ":hand_splayed::skin-tone-2:", ":raised_hand_with_fingers_splayed::skin-tone-2:")), Collections.singletonList(":raised_hand_with_fingers_splayed::skin-tone-3:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "hand with fingers splayed: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🖐🏽
     */
    Emoji HAND_WITH_FINGERS_SPLAYED_MEDIUM_SKIN_TONE = new Emoji("🖐🏽", "\uD83D\uDD90\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":hand_splayed_tone3:", ":raised_hand_with_fingers_splayed_tone3:", ":hand_splayed::skin-tone-3:", ":raised_hand_with_fingers_splayed::skin-tone-3:")), Collections.singletonList(":raised_hand_with_fingers_splayed::skin-tone-4:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "hand with fingers splayed: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🖐🏾
     */
    Emoji HAND_WITH_FINGERS_SPLAYED_MEDIUM_DARK_SKIN_TONE = new Emoji("🖐🏾", "\uD83D\uDD90\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":hand_splayed_tone4:", ":raised_hand_with_fingers_splayed_tone4:", ":hand_splayed::skin-tone-4:", ":raised_hand_with_fingers_splayed::skin-tone-4:")), Collections.singletonList(":raised_hand_with_fingers_splayed::skin-tone-5:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "hand with fingers splayed: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🖐🏿
     */
    Emoji HAND_WITH_FINGERS_SPLAYED_DARK_SKIN_TONE = new Emoji("🖐🏿", "\uD83D\uDD90\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":hand_splayed_tone5:", ":raised_hand_with_fingers_splayed_tone5:", ":hand_splayed::skin-tone-5:", ":raised_hand_with_fingers_splayed::skin-tone-5:")), Collections.singletonList(":raised_hand_with_fingers_splayed::skin-tone-6:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "hand with fingers splayed: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * ✋
     */
    Emoji RAISED_HAND = new Emoji("✋", "\u270B", Collections.singletonList(":raised_hand:"), Collections.singletonList(":hand:"), Collections.unmodifiableList(Arrays.asList(":hand:", ":raised_hand:")), false, false, 0.6, Qualification.fromString("fully-qualified"), "raised hand", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, true);

    /**
     * ✋🏻
     */
    Emoji RAISED_HAND_LIGHT_SKIN_TONE = new Emoji("✋🏻", "\u270B\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":raised_hand_tone1:", ":raised_hand::skin-tone-1:")), Collections.singletonList(":hand::skin-tone-2:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "raised hand: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * ✋🏼
     */
    Emoji RAISED_HAND_MEDIUM_LIGHT_SKIN_TONE = new Emoji("✋🏼", "\u270B\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":raised_hand_tone2:", ":raised_hand::skin-tone-2:")), Collections.singletonList(":hand::skin-tone-3:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "raised hand: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * ✋🏽
     */
    Emoji RAISED_HAND_MEDIUM_SKIN_TONE = new Emoji("✋🏽", "\u270B\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":raised_hand_tone3:", ":raised_hand::skin-tone-3:")), Collections.singletonList(":hand::skin-tone-4:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "raised hand: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * ✋🏾
     */
    Emoji RAISED_HAND_MEDIUM_DARK_SKIN_TONE = new Emoji("✋🏾", "\u270B\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":raised_hand_tone4:", ":raised_hand::skin-tone-4:")), Collections.singletonList(":hand::skin-tone-5:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "raised hand: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * ✋🏿
     */
    Emoji RAISED_HAND_DARK_SKIN_TONE = new Emoji("✋🏿", "\u270B\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":raised_hand_tone5:", ":raised_hand::skin-tone-5:")), Collections.singletonList(":hand::skin-tone-6:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "raised hand: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🖖
     */
    Emoji VULCAN_SALUTE = new Emoji("🖖", "\uD83D\uDD96", Collections.unmodifiableList(Arrays.asList(":vulcan:", ":raised_hand_with_part_between_middle_and_ring_fingers:", ":vulcan_salute:")), Collections.singletonList(":spock-hand:"), Collections.singletonList(":vulcan_salute:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "vulcan salute", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🖖🏻
     */
    Emoji VULCAN_SALUTE_LIGHT_SKIN_TONE = new Emoji("🖖🏻", "\uD83D\uDD96\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":vulcan_tone1:", ":raised_hand_with_part_between_middle_and_ring_fingers_tone1:", ":vulcan::skin-tone-1:", ":raised_hand_with_part_between_middle_and_ring_fingers::skin-tone-1:", ":vulcan_salute::skin-tone-1:")), Collections.singletonList(":spock-hand::skin-tone-2:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "vulcan salute: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🖖🏼
     */
    Emoji VULCAN_SALUTE_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🖖🏼", "\uD83D\uDD96\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":vulcan_tone2:", ":raised_hand_with_part_between_middle_and_ring_fingers_tone2:", ":vulcan::skin-tone-2:", ":raised_hand_with_part_between_middle_and_ring_fingers::skin-tone-2:", ":vulcan_salute::skin-tone-2:")), Collections.singletonList(":spock-hand::skin-tone-3:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "vulcan salute: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🖖🏽
     */
    Emoji VULCAN_SALUTE_MEDIUM_SKIN_TONE = new Emoji("🖖🏽", "\uD83D\uDD96\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":vulcan_tone3:", ":raised_hand_with_part_between_middle_and_ring_fingers_tone3:", ":vulcan::skin-tone-3:", ":raised_hand_with_part_between_middle_and_ring_fingers::skin-tone-3:", ":vulcan_salute::skin-tone-3:")), Collections.singletonList(":spock-hand::skin-tone-4:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "vulcan salute: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🖖🏾
     */
    Emoji VULCAN_SALUTE_MEDIUM_DARK_SKIN_TONE = new Emoji("🖖🏾", "\uD83D\uDD96\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":vulcan_tone4:", ":raised_hand_with_part_between_middle_and_ring_fingers_tone4:", ":vulcan::skin-tone-4:", ":raised_hand_with_part_between_middle_and_ring_fingers::skin-tone-4:", ":vulcan_salute::skin-tone-4:")), Collections.singletonList(":spock-hand::skin-tone-5:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "vulcan salute: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🖖🏿
     */
    Emoji VULCAN_SALUTE_DARK_SKIN_TONE = new Emoji("🖖🏿", "\uD83D\uDD96\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":vulcan_tone5:", ":raised_hand_with_part_between_middle_and_ring_fingers_tone5:", ":vulcan::skin-tone-5:", ":raised_hand_with_part_between_middle_and_ring_fingers::skin-tone-5:", ":vulcan_salute::skin-tone-5:")), Collections.singletonList(":spock-hand::skin-tone-6:"), Collections.emptyList(), true, false, 1.0, Qualification.fromString("fully-qualified"), "vulcan salute: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫱
     */
    Emoji RIGHTWARDS_HAND = new Emoji("🫱", "\uD83E\uDEF1", Collections.singletonList(":rightwards_hand:"), Collections.emptyList(), Collections.singletonList(":rightwards_hand:"), false, false, 14.0, Qualification.fromString("fully-qualified"), "rightwards hand", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫱🏻
     */
    Emoji RIGHTWARDS_HAND_LIGHT_SKIN_TONE = new Emoji("🫱🏻", "\uD83E\uDEF1\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":rightwards_hand_tone1:", ":rightwards_hand_light_skin_tone:", ":rightwards_hand::skin-tone-1:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "rightwards hand: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫱🏼
     */
    Emoji RIGHTWARDS_HAND_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🫱🏼", "\uD83E\uDEF1\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":rightwards_hand_tone2:", ":rightwards_hand_medium_light_skin_tone:", ":rightwards_hand::skin-tone-2:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "rightwards hand: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫱🏽
     */
    Emoji RIGHTWARDS_HAND_MEDIUM_SKIN_TONE = new Emoji("🫱🏽", "\uD83E\uDEF1\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":rightwards_hand_tone3:", ":rightwards_hand_medium_skin_tone:", ":rightwards_hand::skin-tone-3:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "rightwards hand: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫱🏾
     */
    Emoji RIGHTWARDS_HAND_MEDIUM_DARK_SKIN_TONE = new Emoji("🫱🏾", "\uD83E\uDEF1\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":rightwards_hand_tone4:", ":rightwards_hand_medium_dark_skin_tone:", ":rightwards_hand::skin-tone-4:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "rightwards hand: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫱🏿
     */
    Emoji RIGHTWARDS_HAND_DARK_SKIN_TONE = new Emoji("🫱🏿", "\uD83E\uDEF1\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":rightwards_hand_tone5:", ":rightwards_hand_dark_skin_tone:", ":rightwards_hand::skin-tone-5:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "rightwards hand: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫲
     */
    Emoji LEFTWARDS_HAND = new Emoji("🫲", "\uD83E\uDEF2", Collections.singletonList(":leftwards_hand:"), Collections.emptyList(), Collections.singletonList(":leftwards_hand:"), false, false, 14.0, Qualification.fromString("fully-qualified"), "leftwards hand", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫲🏻
     */
    Emoji LEFTWARDS_HAND_LIGHT_SKIN_TONE = new Emoji("🫲🏻", "\uD83E\uDEF2\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":leftwards_hand_tone1:", ":leftwards_hand_light_skin_tone:", ":leftwards_hand::skin-tone-1:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "leftwards hand: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫲🏼
     */
    Emoji LEFTWARDS_HAND_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🫲🏼", "\uD83E\uDEF2\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":leftwards_hand_tone2:", ":leftwards_hand_medium_light_skin_tone:", ":leftwards_hand::skin-tone-2:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "leftwards hand: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫲🏽
     */
    Emoji LEFTWARDS_HAND_MEDIUM_SKIN_TONE = new Emoji("🫲🏽", "\uD83E\uDEF2\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":leftwards_hand_tone3:", ":leftwards_hand_medium_skin_tone:", ":leftwards_hand::skin-tone-3:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "leftwards hand: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫲🏾
     */
    Emoji LEFTWARDS_HAND_MEDIUM_DARK_SKIN_TONE = new Emoji("🫲🏾", "\uD83E\uDEF2\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":leftwards_hand_tone4:", ":leftwards_hand_medium_dark_skin_tone:", ":leftwards_hand::skin-tone-4:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "leftwards hand: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫲🏿
     */
    Emoji LEFTWARDS_HAND_DARK_SKIN_TONE = new Emoji("🫲🏿", "\uD83E\uDEF2\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":leftwards_hand_tone5:", ":leftwards_hand_dark_skin_tone:", ":leftwards_hand::skin-tone-5:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "leftwards hand: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫳
     */
    Emoji PALM_DOWN_HAND = new Emoji("🫳", "\uD83E\uDEF3", Collections.singletonList(":palm_down_hand:"), Collections.emptyList(), Collections.singletonList(":palm_down_hand:"), false, false, 14.0, Qualification.fromString("fully-qualified"), "palm down hand", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫳🏻
     */
    Emoji PALM_DOWN_HAND_LIGHT_SKIN_TONE = new Emoji("🫳🏻", "\uD83E\uDEF3\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":palm_down_hand_tone1:", ":palm_down_hand_light_skin_tone:", ":palm_down_hand::skin-tone-1:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "palm down hand: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫳🏼
     */
    Emoji PALM_DOWN_HAND_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🫳🏼", "\uD83E\uDEF3\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":palm_down_hand_tone2:", ":palm_down_hand_medium_light_skin_tone:", ":palm_down_hand::skin-tone-2:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "palm down hand: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫳🏽
     */
    Emoji PALM_DOWN_HAND_MEDIUM_SKIN_TONE = new Emoji("🫳🏽", "\uD83E\uDEF3\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":palm_down_hand_tone3:", ":palm_down_hand_medium_skin_tone:", ":palm_down_hand::skin-tone-3:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "palm down hand: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫳🏾
     */
    Emoji PALM_DOWN_HAND_MEDIUM_DARK_SKIN_TONE = new Emoji("🫳🏾", "\uD83E\uDEF3\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":palm_down_hand_tone4:", ":palm_down_hand_medium_dark_skin_tone:", ":palm_down_hand::skin-tone-4:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "palm down hand: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫳🏿
     */
    Emoji PALM_DOWN_HAND_DARK_SKIN_TONE = new Emoji("🫳🏿", "\uD83E\uDEF3\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":palm_down_hand_tone5:", ":palm_down_hand_dark_skin_tone:", ":palm_down_hand::skin-tone-5:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "palm down hand: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫴
     */
    Emoji PALM_UP_HAND = new Emoji("🫴", "\uD83E\uDEF4", Collections.singletonList(":palm_up_hand:"), Collections.emptyList(), Collections.singletonList(":palm_up_hand:"), false, false, 14.0, Qualification.fromString("fully-qualified"), "palm up hand", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫴🏻
     */
    Emoji PALM_UP_HAND_LIGHT_SKIN_TONE = new Emoji("🫴🏻", "\uD83E\uDEF4\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":palm_up_hand_tone1:", ":palm_up_hand_light_skin_tone:", ":palm_up_hand::skin-tone-1:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "palm up hand: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫴🏼
     */
    Emoji PALM_UP_HAND_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🫴🏼", "\uD83E\uDEF4\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":palm_up_hand_tone2:", ":palm_up_hand_medium_light_skin_tone:", ":palm_up_hand::skin-tone-2:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "palm up hand: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫴🏽
     */
    Emoji PALM_UP_HAND_MEDIUM_SKIN_TONE = new Emoji("🫴🏽", "\uD83E\uDEF4\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":palm_up_hand_tone3:", ":palm_up_hand_medium_skin_tone:", ":palm_up_hand::skin-tone-3:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "palm up hand: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫴🏾
     */
    Emoji PALM_UP_HAND_MEDIUM_DARK_SKIN_TONE = new Emoji("🫴🏾", "\uD83E\uDEF4\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":palm_up_hand_tone4:", ":palm_up_hand_medium_dark_skin_tone:", ":palm_up_hand::skin-tone-4:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "palm up hand: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫴🏿
     */
    Emoji PALM_UP_HAND_DARK_SKIN_TONE = new Emoji("🫴🏿", "\uD83E\uDEF4\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":palm_up_hand_tone5:", ":palm_up_hand_dark_skin_tone:", ":palm_up_hand::skin-tone-5:")), Collections.emptyList(), Collections.emptyList(), true, false, 14.0, Qualification.fromString("fully-qualified"), "palm up hand: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫷
     */
    Emoji LEFTWARDS_PUSHING_HAND = new Emoji("🫷", "\uD83E\uDEF7", Collections.singletonList(":leftwards_pushing_hand:"), Collections.emptyList(), Collections.singletonList(":leftwards_pushing_hand:"), false, false, 15.0, Qualification.fromString("fully-qualified"), "leftwards pushing hand", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫷🏻
     */
    Emoji LEFTWARDS_PUSHING_HAND_LIGHT_SKIN_TONE = new Emoji("🫷🏻", "\uD83E\uDEF7\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":leftwards_pushing_hand_tone1:", ":leftwards_pushing_hand_light_skin_tone:", ":leftwards_pushing_hand::skin-tone-1:")), Collections.emptyList(), Collections.emptyList(), true, false, 15.0, Qualification.fromString("fully-qualified"), "leftwards pushing hand: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫷🏼
     */
    Emoji LEFTWARDS_PUSHING_HAND_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🫷🏼", "\uD83E\uDEF7\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":leftwards_pushing_hand_tone2:", ":leftwards_pushing_hand_medium_light_skin_tone:", ":leftwards_pushing_hand::skin-tone-2:")), Collections.emptyList(), Collections.emptyList(), true, false, 15.0, Qualification.fromString("fully-qualified"), "leftwards pushing hand: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫷🏽
     */
    Emoji LEFTWARDS_PUSHING_HAND_MEDIUM_SKIN_TONE = new Emoji("🫷🏽", "\uD83E\uDEF7\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":leftwards_pushing_hand_tone3:", ":leftwards_pushing_hand_medium_skin_tone:", ":leftwards_pushing_hand::skin-tone-3:")), Collections.emptyList(), Collections.emptyList(), true, false, 15.0, Qualification.fromString("fully-qualified"), "leftwards pushing hand: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫷🏾
     */
    Emoji LEFTWARDS_PUSHING_HAND_MEDIUM_DARK_SKIN_TONE = new Emoji("🫷🏾", "\uD83E\uDEF7\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":leftwards_pushing_hand_tone4:", ":leftwards_pushing_hand_medium_dark_skin_tone:", ":leftwards_pushing_hand::skin-tone-4:")), Collections.emptyList(), Collections.emptyList(), true, false, 15.0, Qualification.fromString("fully-qualified"), "leftwards pushing hand: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫷🏿
     */
    Emoji LEFTWARDS_PUSHING_HAND_DARK_SKIN_TONE = new Emoji("🫷🏿", "\uD83E\uDEF7\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":leftwards_pushing_hand_tone5:", ":leftwards_pushing_hand_dark_skin_tone:", ":leftwards_pushing_hand::skin-tone-5:")), Collections.emptyList(), Collections.emptyList(), true, false, 15.0, Qualification.fromString("fully-qualified"), "leftwards pushing hand: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫸
     */
    Emoji RIGHTWARDS_PUSHING_HAND = new Emoji("🫸", "\uD83E\uDEF8", Collections.singletonList(":rightwards_pushing_hand:"), Collections.emptyList(), Collections.singletonList(":rightwards_pushing_hand:"), false, false, 15.0, Qualification.fromString("fully-qualified"), "rightwards pushing hand", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫸🏻
     */
    Emoji RIGHTWARDS_PUSHING_HAND_LIGHT_SKIN_TONE = new Emoji("🫸🏻", "\uD83E\uDEF8\uD83C\uDFFB", Collections.unmodifiableList(Arrays.asList(":rightwards_pushing_hand_tone1:", ":rightwards_pushing_hand_light_skin_tone:", ":rightwards_pushing_hand::skin-tone-1:")), Collections.emptyList(), Collections.emptyList(), true, false, 15.0, Qualification.fromString("fully-qualified"), "rightwards pushing hand: light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫸🏼
     */
    Emoji RIGHTWARDS_PUSHING_HAND_MEDIUM_LIGHT_SKIN_TONE = new Emoji("🫸🏼", "\uD83E\uDEF8\uD83C\uDFFC", Collections.unmodifiableList(Arrays.asList(":rightwards_pushing_hand_tone2:", ":rightwards_pushing_hand_medium_light_skin_tone:", ":rightwards_pushing_hand::skin-tone-2:")), Collections.emptyList(), Collections.emptyList(), true, false, 15.0, Qualification.fromString("fully-qualified"), "rightwards pushing hand: medium-light skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫸🏽
     */
    Emoji RIGHTWARDS_PUSHING_HAND_MEDIUM_SKIN_TONE = new Emoji("🫸🏽", "\uD83E\uDEF8\uD83C\uDFFD", Collections.unmodifiableList(Arrays.asList(":rightwards_pushing_hand_tone3:", ":rightwards_pushing_hand_medium_skin_tone:", ":rightwards_pushing_hand::skin-tone-3:")), Collections.emptyList(), Collections.emptyList(), true, false, 15.0, Qualification.fromString("fully-qualified"), "rightwards pushing hand: medium skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫸🏾
     */
    Emoji RIGHTWARDS_PUSHING_HAND_MEDIUM_DARK_SKIN_TONE = new Emoji("🫸🏾", "\uD83E\uDEF8\uD83C\uDFFE", Collections.unmodifiableList(Arrays.asList(":rightwards_pushing_hand_tone4:", ":rightwards_pushing_hand_medium_dark_skin_tone:", ":rightwards_pushing_hand::skin-tone-4:")), Collections.emptyList(), Collections.emptyList(), true, false, 15.0, Qualification.fromString("fully-qualified"), "rightwards pushing hand: medium-dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);

    /**
     * 🫸🏿
     */
    Emoji RIGHTWARDS_PUSHING_HAND_DARK_SKIN_TONE = new Emoji("🫸🏿", "\uD83E\uDEF8\uD83C\uDFFF", Collections.unmodifiableList(Arrays.asList(":rightwards_pushing_hand_tone5:", ":rightwards_pushing_hand_dark_skin_tone:", ":rightwards_pushing_hand::skin-tone-5:")), Collections.emptyList(), Collections.emptyList(), true, false, 15.0, Qualification.fromString("fully-qualified"), "rightwards pushing hand: dark skin tone", EmojiGroup.PEOPLE_AND_BODY, EmojiSubGroup.HAND_FINGERS_OPEN, false);
}
