package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiGeometric {

    /**
     * 🔴
     */
    Emoji RED_CIRCLE = new Emoji("🔴", "\uD83D\uDD34", Collections.singletonList(":red_circle:"), Collections.singletonList(":red_circle:"), Collections.singletonList(":red_circle:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "red circle", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, false);

    /**
     * 🟠
     */
    Emoji ORANGE_CIRCLE = new Emoji("🟠", "\uD83D\uDFE0", Collections.singletonList(":orange_circle:"), Collections.singletonList(":large_orange_circle:"), Collections.singletonList(":orange_circle:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "orange circle", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, false);

    /**
     * 🟡
     */
    Emoji YELLOW_CIRCLE = new Emoji("🟡", "\uD83D\uDFE1", Collections.singletonList(":yellow_circle:"), Collections.singletonList(":large_yellow_circle:"), Collections.singletonList(":yellow_circle:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "yellow circle", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, false);

    /**
     * 🟢
     */
    Emoji GREEN_CIRCLE = new Emoji("🟢", "\uD83D\uDFE2", Collections.singletonList(":green_circle:"), Collections.singletonList(":large_green_circle:"), Collections.singletonList(":green_circle:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "green circle", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, false);

    /**
     * 🔵
     */
    Emoji BLUE_CIRCLE = new Emoji("🔵", "\uD83D\uDD35", Collections.singletonList(":blue_circle:"), Collections.singletonList(":large_blue_circle:"), Collections.singletonList(":large_blue_circle:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "blue circle", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, false);

    /**
     * 🟣
     */
    Emoji PURPLE_CIRCLE = new Emoji("🟣", "\uD83D\uDFE3", Collections.singletonList(":purple_circle:"), Collections.singletonList(":large_purple_circle:"), Collections.singletonList(":purple_circle:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "purple circle", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, false);

    /**
     * 🟤
     */
    Emoji BROWN_CIRCLE = new Emoji("🟤", "\uD83D\uDFE4", Collections.singletonList(":brown_circle:"), Collections.singletonList(":large_brown_circle:"), Collections.singletonList(":brown_circle:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "brown circle", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, false);

    /**
     * ⚫
     */
    Emoji BLACK_CIRCLE = new Emoji("⚫", "\u26AB", Collections.singletonList(":black_circle:"), Collections.singletonList(":black_circle:"), Collections.singletonList(":black_circle:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "black circle", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, true);

    /**
     * ⚪
     */
    Emoji WHITE_CIRCLE = new Emoji("⚪", "\u26AA", Collections.singletonList(":white_circle:"), Collections.singletonList(":white_circle:"), Collections.singletonList(":white_circle:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "white circle", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, true);

    /**
     * 🟥
     */
    Emoji RED_SQUARE = new Emoji("🟥", "\uD83D\uDFE5", Collections.singletonList(":red_square:"), Collections.singletonList(":large_red_square:"), Collections.singletonList(":red_square:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "red square", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, false);

    /**
     * 🟧
     */
    Emoji ORANGE_SQUARE = new Emoji("🟧", "\uD83D\uDFE7", Collections.singletonList(":orange_square:"), Collections.singletonList(":large_orange_square:"), Collections.singletonList(":orange_square:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "orange square", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, false);

    /**
     * 🟨
     */
    Emoji YELLOW_SQUARE = new Emoji("🟨", "\uD83D\uDFE8", Collections.singletonList(":yellow_square:"), Collections.singletonList(":large_yellow_square:"), Collections.singletonList(":yellow_square:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "yellow square", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, false);

    /**
     * 🟩
     */
    Emoji GREEN_SQUARE = new Emoji("🟩", "\uD83D\uDFE9", Collections.singletonList(":green_square:"), Collections.singletonList(":large_green_square:"), Collections.singletonList(":green_square:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "green square", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, false);

    /**
     * 🟦
     */
    Emoji BLUE_SQUARE = new Emoji("🟦", "\uD83D\uDFE6", Collections.singletonList(":blue_square:"), Collections.singletonList(":large_blue_square:"), Collections.singletonList(":blue_square:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "blue square", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, false);

    /**
     * 🟪
     */
    Emoji PURPLE_SQUARE = new Emoji("🟪", "\uD83D\uDFEA", Collections.singletonList(":purple_square:"), Collections.singletonList(":large_purple_square:"), Collections.singletonList(":purple_square:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "purple square", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, false);

    /**
     * 🟫
     */
    Emoji BROWN_SQUARE = new Emoji("🟫", "\uD83D\uDFEB", Collections.singletonList(":brown_square:"), Collections.singletonList(":large_brown_square:"), Collections.singletonList(":brown_square:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "brown square", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, false);

    /**
     * ⬛
     */
    Emoji BLACK_LARGE_SQUARE = new Emoji("⬛", "\u2B1B", Collections.singletonList(":black_large_square:"), Collections.singletonList(":black_large_square:"), Collections.singletonList(":black_large_square:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "black large square", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, true);

    /**
     * ⬜
     */
    Emoji WHITE_LARGE_SQUARE = new Emoji("⬜", "\u2B1C", Collections.singletonList(":white_large_square:"), Collections.singletonList(":white_large_square:"), Collections.singletonList(":white_large_square:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "white large square", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, true);

    /**
     * ◼️
     */
    Emoji BLACK_MEDIUM_SQUARE = new Emoji("◼️", "\u25FC\uFE0F", Collections.singletonList(":black_medium_square:"), Collections.singletonList(":black_medium_square:"), Collections.singletonList(":black_medium_square:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "black medium square", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, false);

    /**
     * ◼
     */
    Emoji BLACK_MEDIUM_SQUARE_UNQUALIFIED = new Emoji("◼", "\u25FC", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":black_medium_square:"), false, false, 0.6, Qualification.fromString("unqualified"), "black medium square", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, true);

    /**
     * ◻️
     */
    Emoji WHITE_MEDIUM_SQUARE = new Emoji("◻️", "\u25FB\uFE0F", Collections.singletonList(":white_medium_square:"), Collections.singletonList(":white_medium_square:"), Collections.singletonList(":white_medium_square:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "white medium square", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, false);

    /**
     * ◻
     */
    Emoji WHITE_MEDIUM_SQUARE_UNQUALIFIED = new Emoji("◻", "\u25FB", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":white_medium_square:"), false, false, 0.6, Qualification.fromString("unqualified"), "white medium square", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, true);

    /**
     * ◾
     */
    Emoji BLACK_MEDIUM_SMALL_SQUARE = new Emoji("◾", "\u25FE", Collections.singletonList(":black_medium_small_square:"), Collections.singletonList(":black_medium_small_square:"), Collections.singletonList(":black_medium_small_square:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "black medium-small square", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, true);

    /**
     * ◽
     */
    Emoji WHITE_MEDIUM_SMALL_SQUARE = new Emoji("◽", "\u25FD", Collections.singletonList(":white_medium_small_square:"), Collections.singletonList(":white_medium_small_square:"), Collections.singletonList(":white_medium_small_square:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "white medium-small square", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, true);

    /**
     * ▪️
     */
    Emoji BLACK_SMALL_SQUARE = new Emoji("▪️", "\u25AA\uFE0F", Collections.singletonList(":black_small_square:"), Collections.singletonList(":black_small_square:"), Collections.singletonList(":black_small_square:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "black small square", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, false);

    /**
     * ▪
     */
    Emoji BLACK_SMALL_SQUARE_UNQUALIFIED = new Emoji("▪", "\u25AA", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":black_small_square:"), false, false, 0.6, Qualification.fromString("unqualified"), "black small square", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, true);

    /**
     * ▫️
     */
    Emoji WHITE_SMALL_SQUARE = new Emoji("▫️", "\u25AB\uFE0F", Collections.singletonList(":white_small_square:"), Collections.singletonList(":white_small_square:"), Collections.singletonList(":white_small_square:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "white small square", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, false);

    /**
     * ▫
     */
    Emoji WHITE_SMALL_SQUARE_UNQUALIFIED = new Emoji("▫", "\u25AB", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":white_small_square:"), false, false, 0.6, Qualification.fromString("unqualified"), "white small square", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, true);

    /**
     * 🔶
     */
    Emoji LARGE_ORANGE_DIAMOND = new Emoji("🔶", "\uD83D\uDD36", Collections.singletonList(":large_orange_diamond:"), Collections.singletonList(":large_orange_diamond:"), Collections.singletonList(":large_orange_diamond:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "large orange diamond", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, false);

    /**
     * 🔷
     */
    Emoji LARGE_BLUE_DIAMOND = new Emoji("🔷", "\uD83D\uDD37", Collections.singletonList(":large_blue_diamond:"), Collections.singletonList(":large_blue_diamond:"), Collections.singletonList(":large_blue_diamond:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "large blue diamond", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, false);

    /**
     * 🔸
     */
    Emoji SMALL_ORANGE_DIAMOND = new Emoji("🔸", "\uD83D\uDD38", Collections.singletonList(":small_orange_diamond:"), Collections.singletonList(":small_orange_diamond:"), Collections.singletonList(":small_orange_diamond:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "small orange diamond", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, false);

    /**
     * 🔹
     */
    Emoji SMALL_BLUE_DIAMOND = new Emoji("🔹", "\uD83D\uDD39", Collections.singletonList(":small_blue_diamond:"), Collections.singletonList(":small_blue_diamond:"), Collections.singletonList(":small_blue_diamond:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "small blue diamond", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, false);

    /**
     * 🔺
     */
    Emoji RED_TRIANGLE_POINTED_UP = new Emoji("🔺", "\uD83D\uDD3A", Collections.singletonList(":small_red_triangle:"), Collections.singletonList(":small_red_triangle:"), Collections.singletonList(":small_red_triangle:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "red triangle pointed up", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, false);

    /**
     * 🔻
     */
    Emoji RED_TRIANGLE_POINTED_DOWN = new Emoji("🔻", "\uD83D\uDD3B", Collections.singletonList(":small_red_triangle_down:"), Collections.singletonList(":small_red_triangle_down:"), Collections.singletonList(":small_red_triangle_down:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "red triangle pointed down", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, false);

    /**
     * 💠
     */
    Emoji DIAMOND_WITH_A_DOT = new Emoji("💠", "\uD83D\uDCA0", Collections.singletonList(":diamond_shape_with_a_dot_inside:"), Collections.singletonList(":diamond_shape_with_a_dot_inside:"), Collections.singletonList(":diamond_shape_with_a_dot_inside:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "diamond with a dot", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, false);

    /**
     * 🔘
     */
    Emoji RADIO_BUTTON = new Emoji("🔘", "\uD83D\uDD18", Collections.singletonList(":radio_button:"), Collections.singletonList(":radio_button:"), Collections.singletonList(":radio_button:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "radio button", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, false);

    /**
     * 🔳
     */
    Emoji WHITE_SQUARE_BUTTON = new Emoji("🔳", "\uD83D\uDD33", Collections.singletonList(":white_square_button:"), Collections.singletonList(":white_square_button:"), Collections.singletonList(":white_square_button:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "white square button", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, false);

    /**
     * 🔲
     */
    Emoji BLACK_SQUARE_BUTTON = new Emoji("🔲", "\uD83D\uDD32", Collections.singletonList(":black_square_button:"), Collections.singletonList(":black_square_button:"), Collections.singletonList(":black_square_button:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "black square button", EmojiGroup.SYMBOLS, EmojiSubGroup.GEOMETRIC, false);
}
