package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiGender {

    /**
     * ♀️
     */
    Emoji FEMALE_SIGN = new Emoji("♀️", "\u2640\uFE0F", Collections.singletonList(":female_sign:"), Collections.singletonList(":female_sign:"), Collections.singletonList(":female_sign:"), false, false, 4.0, Qualification.fromString("fully-qualified"), "female sign", EmojiGroup.SYMBOLS, EmojiSubGroup.GENDER, false);

    /**
     * ♀
     */
    Emoji FEMALE_SIGN_UNQUALIFIED = new Emoji("♀", "\u2640", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":female_sign:"), false, false, 4.0, Qualification.fromString("unqualified"), "female sign", EmojiGroup.SYMBOLS, EmojiSubGroup.GENDER, true);

    /**
     * ♂️
     */
    Emoji MALE_SIGN = new Emoji("♂️", "\u2642\uFE0F", Collections.singletonList(":male_sign:"), Collections.singletonList(":male_sign:"), Collections.singletonList(":male_sign:"), false, false, 4.0, Qualification.fromString("fully-qualified"), "male sign", EmojiGroup.SYMBOLS, EmojiSubGroup.GENDER, false);

    /**
     * ♂
     */
    Emoji MALE_SIGN_UNQUALIFIED = new Emoji("♂", "\u2642", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":male_sign:"), false, false, 4.0, Qualification.fromString("unqualified"), "male sign", EmojiGroup.SYMBOLS, EmojiSubGroup.GENDER, true);

    /**
     * ⚧️
     */
    Emoji TRANSGENDER_SYMBOL = new Emoji("⚧️", "\u26A7\uFE0F", Collections.emptyList(), Collections.singletonList(":transgender_symbol:"), Collections.singletonList(":transgender_symbol:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "transgender symbol", EmojiGroup.SYMBOLS, EmojiSubGroup.GENDER, false);

    /**
     * ⚧
     */
    Emoji TRANSGENDER_SYMBOL_UNQUALIFIED = new Emoji("⚧", "\u26A7", Collections.singletonList(":transgender_symbol:"), Collections.emptyList(), Collections.singletonList(":transgender_symbol:"), false, false, 13.0, Qualification.fromString("unqualified"), "transgender symbol", EmojiGroup.SYMBOLS, EmojiSubGroup.GENDER, true);
}
