package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiFlag {

    /**
     * 🏁
     */
    Emoji CHEQUERED_FLAG = new Emoji("🏁", "\uD83C\uDFC1", Collections.singletonList(":checkered_flag:"), Collections.singletonList(":checkered_flag:"), Collections.singletonList(":checkered_flag:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "chequered flag", EmojiGroup.FLAGS, EmojiSubGroup.FLAG, false);

    /**
     * 🚩
     */
    Emoji TRIANGULAR_FLAG = new Emoji("🚩", "\uD83D\uDEA9", Collections.singletonList(":triangular_flag_on_post:"), Collections.singletonList(":triangular_flag_on_post:"), Collections.singletonList(":triangular_flag_on_post:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "triangular flag", EmojiGroup.FLAGS, EmojiSubGroup.FLAG, false);

    /**
     * 🎌
     */
    Emoji CROSSED_FLAGS = new Emoji("🎌", "\uD83C\uDF8C", Collections.singletonList(":crossed_flags:"), Collections.singletonList(":crossed_flags:"), Collections.singletonList(":crossed_flags:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "crossed flags", EmojiGroup.FLAGS, EmojiSubGroup.FLAG, false);

    /**
     * 🏴
     */
    Emoji BLACK_FLAG = new Emoji("🏴", "\uD83C\uDFF4", Collections.singletonList(":flag_black:"), Collections.singletonList(":waving_black_flag:"), Collections.singletonList(":black_flag:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "black flag", EmojiGroup.FLAGS, EmojiSubGroup.FLAG, false);

    /**
     * 🏳️
     */
    Emoji WHITE_FLAG = new Emoji("🏳️", "\uD83C\uDFF3\uFE0F", Collections.singletonList(":flag_white:"), Collections.singletonList(":waving_white_flag:"), Collections.singletonList(":white_flag:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "white flag", EmojiGroup.FLAGS, EmojiSubGroup.FLAG, false);

    /**
     * 🏳
     */
    Emoji WHITE_FLAG_UNQUALIFIED = new Emoji("🏳", "\uD83C\uDFF3", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":white_flag:"), false, false, 0.7, Qualification.fromString("unqualified"), "white flag", EmojiGroup.FLAGS, EmojiSubGroup.FLAG, true);

    /**
     * 🏳️‍🌈
     */
    Emoji RAINBOW_FLAG = new Emoji("🏳️‍🌈", "\uD83C\uDFF3\uFE0F\u200D\uD83C\uDF08", Collections.unmodifiableList(Arrays.asList(":rainbow_flag:", ":gay_pride_flag:")), Collections.singletonList(":rainbow-flag:"), Collections.singletonList(":rainbow_flag:"), false, false, 4.0, Qualification.fromString("fully-qualified"), "rainbow flag", EmojiGroup.FLAGS, EmojiSubGroup.FLAG, false);

    /**
     * 🏳‍🌈
     */
    Emoji RAINBOW_FLAG_UNQUALIFIED = new Emoji("🏳‍🌈", "\uD83C\uDFF3\u200D\uD83C\uDF08", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 4.0, Qualification.fromString("unqualified"), "rainbow flag", EmojiGroup.FLAGS, EmojiSubGroup.FLAG, false);

    /**
     * 🏳️‍⚧️
     */
    Emoji TRANSGENDER_FLAG = new Emoji("🏳️‍⚧️", "\uD83C\uDFF3\uFE0F\u200D\u26A7\uFE0F", Collections.singletonList(":transgender_flag:"), Collections.singletonList(":transgender_flag:"), Collections.singletonList(":transgender_flag:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "transgender flag", EmojiGroup.FLAGS, EmojiSubGroup.FLAG, false);

    /**
     * 🏳‍⚧️
     */
    Emoji TRANSGENDER_FLAG_UNQUALIFIED_0 = new Emoji("🏳‍⚧️", "\uD83C\uDFF3\u200D\u26A7\uFE0F", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 13.0, Qualification.fromString("unqualified"), "transgender flag", EmojiGroup.FLAGS, EmojiSubGroup.FLAG, false);

    /**
     * 🏳️‍⚧
     */
    Emoji TRANSGENDER_FLAG_MINIMALLY_QUALIFIED = new Emoji("🏳️‍⚧", "\uD83C\uDFF3\uFE0F\u200D\u26A7", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 13.0, Qualification.fromString("minimally-qualified"), "transgender flag", EmojiGroup.FLAGS, EmojiSubGroup.FLAG, false);

    /**
     * 🏳‍⚧
     */
    Emoji TRANSGENDER_FLAG_UNQUALIFIED_1 = new Emoji("🏳‍⚧", "\uD83C\uDFF3\u200D\u26A7", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 13.0, Qualification.fromString("unqualified"), "transgender flag", EmojiGroup.FLAGS, EmojiSubGroup.FLAG, false);

    /**
     * 🏴‍☠️
     */
    Emoji PIRATE_FLAG = new Emoji("🏴‍☠️", "\uD83C\uDFF4\u200D\u2620\uFE0F", Collections.singletonList(":pirate_flag:"), Collections.singletonList(":pirate_flag:"), Collections.singletonList(":pirate_flag:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "pirate flag", EmojiGroup.FLAGS, EmojiSubGroup.FLAG, false);

    /**
     * 🏴‍☠
     */
    Emoji PIRATE_FLAG_MINIMALLY_QUALIFIED = new Emoji("🏴‍☠", "\uD83C\uDFF4\u200D\u2620", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 11.0, Qualification.fromString("minimally-qualified"), "pirate flag", EmojiGroup.FLAGS, EmojiSubGroup.FLAG, false);
}
