package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiFaceSmiling {

    /**
     * 😀
     */
    Emoji GRINNING_FACE = new Emoji("😀", "\uD83D\uDE00", Collections.unmodifiableList(Arrays.asList(":grinning:", ":grinning_face:")), Collections.singletonList(":grinning:"), Collections.singletonList(":grinning:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "grinning face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_SMILING, false);

    /**
     * 😃
     */
    Emoji GRINNING_FACE_WITH_BIG_EYES = new Emoji("😃", "\uD83D\uDE03", Collections.singletonList(":smiley:"), Collections.singletonList(":smiley:"), Collections.singletonList(":smiley:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "grinning face with big eyes", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_SMILING, false);

    /**
     * 😄
     */
    Emoji GRINNING_FACE_WITH_SMILING_EYES = new Emoji("😄", "\uD83D\uDE04", Collections.unmodifiableList(Arrays.asList(":smile:", ":D", ":-D", "=D", "=-D")), Collections.singletonList(":smile:"), Collections.singletonList(":smile:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "grinning face with smiling eyes", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_SMILING, false);

    /**
     * 😁
     */
    Emoji BEAMING_FACE_WITH_SMILING_EYES = new Emoji("😁", "\uD83D\uDE01", Collections.singletonList(":grin:"), Collections.singletonList(":grin:"), Collections.singletonList(":grin:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "beaming face with smiling eyes", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_SMILING, false);

    /**
     * 😆
     */
    Emoji GRINNING_SQUINTING_FACE = new Emoji("😆", "\uD83D\uDE06", Collections.unmodifiableList(Arrays.asList(":laughing:", ":satisfied:", "x-)", "X-)")), Collections.singletonList(":laughing:"), Collections.unmodifiableList(Arrays.asList(":laughing:", ":satisfied:")), false, false, 0.6, Qualification.fromString("fully-qualified"), "grinning squinting face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_SMILING, false);

    /**
     * 😅
     */
    Emoji GRINNING_FACE_WITH_SWEAT = new Emoji("😅", "\uD83D\uDE05", Collections.unmodifiableList(Arrays.asList(":sweat_smile:", ",:)", ",:-)", ",=)", ",=-)")), Collections.singletonList(":sweat_smile:"), Collections.singletonList(":sweat_smile:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "grinning face with sweat", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_SMILING, false);

    /**
     * 🤣
     */
    Emoji ROLLING_ON_THE_FLOOR_LAUGHING = new Emoji("🤣", "\uD83E\uDD23", Collections.unmodifiableList(Arrays.asList(":rofl:", ":rolling_on_the_floor_laughing:")), Collections.singletonList(":rolling_on_the_floor_laughing:"), Collections.singletonList(":rofl:"), false, false, 3.0, Qualification.fromString("fully-qualified"), "rolling on the floor laughing", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_SMILING, false);

    /**
     * 😂
     */
    Emoji FACE_WITH_TEARS_OF_JOY = new Emoji("😂", "\uD83D\uDE02", Collections.unmodifiableList(Arrays.asList(":joy:", ":'D", ":'-D", ":,D", ":,-D", "='D", "='-D", "=,D", "=,-D")), Collections.singletonList(":joy:"), Collections.singletonList(":joy:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "face with tears of joy", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_SMILING, false);

    /**
     * 🙂
     */
    Emoji SLIGHTLY_SMILING_FACE = new Emoji("🙂", "\uD83D\uDE42", Collections.unmodifiableList(Arrays.asList(":slight_smile:", ":slightly_smiling_face:", ":)", ":-)", "=)", "=-)")), Collections.singletonList(":slightly_smiling_face:"), Collections.singletonList(":slightly_smiling_face:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "slightly smiling face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_SMILING, false);

    /**
     * 🙃
     */
    Emoji UPSIDE_DOWN_FACE = new Emoji("🙃", "\uD83D\uDE43", Collections.unmodifiableList(Arrays.asList(":upside_down:", ":upside_down_face:")), Collections.singletonList(":upside_down_face:"), Collections.singletonList(":upside_down_face:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "upside-down face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_SMILING, false);

    /**
     * 🫠
     */
    Emoji MELTING_FACE = new Emoji("🫠", "\uD83E\uDEE0", Collections.singletonList(":melting_face:"), Collections.emptyList(), Collections.singletonList(":melting_face:"), false, false, 14.0, Qualification.fromString("fully-qualified"), "melting face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_SMILING, false);

    /**
     * 😉
     */
    Emoji WINKING_FACE = new Emoji("😉", "\uD83D\uDE09", Collections.unmodifiableList(Arrays.asList(":wink:", ":winking_face:", ";)", ";-)")), Collections.singletonList(":wink:"), Collections.singletonList(":wink:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "winking face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_SMILING, false);

    /**
     * 😊
     */
    Emoji SMILING_FACE_WITH_SMILING_EYES = new Emoji("😊", "\uD83D\uDE0A", Collections.unmodifiableList(Arrays.asList(":blush:", ":\")", ":-\")", "=\")", "=-\")")), Collections.singletonList(":blush:"), Collections.singletonList(":blush:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "smiling face with smiling eyes", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_SMILING, false);

    /**
     * 😇
     */
    Emoji SMILING_FACE_WITH_HALO = new Emoji("😇", "\uD83D\uDE07", Collections.unmodifiableList(Arrays.asList(":innocent:", "o:)", "O:)", "o:-)", "O:-)", "0:)", "0:-)", "o=)", "O=)", "o=-)", "O=-)", "0=)", "0=-)")), Collections.singletonList(":innocent:"), Collections.singletonList(":innocent:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "smiling face with halo", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_SMILING, false);
}
