package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiFaceConcerned {

    /**
     * 😕
     */
    Emoji CONFUSED_FACE = new Emoji("😕", "\uD83D\uDE15", Collections.unmodifiableList(Arrays.asList(":confused:", ":confused_face:", ":-\\", ":-/", "=-\\", "=-/")), Collections.singletonList(":confused:"), Collections.singletonList(":confused:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "confused face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_CONCERNED, false);

    /**
     * 🫤
     */
    Emoji FACE_WITH_DIAGONAL_MOUTH = new Emoji("🫤", "\uD83E\uDEE4", Collections.singletonList(":face_with_diagonal_mouth:"), Collections.emptyList(), Collections.singletonList(":face_with_diagonal_mouth:"), false, false, 14.0, Qualification.fromString("fully-qualified"), "face with diagonal mouth", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_CONCERNED, false);

    /**
     * 😟
     */
    Emoji WORRIED_FACE = new Emoji("😟", "\uD83D\uDE1F", Collections.unmodifiableList(Arrays.asList(":worried:", ":worried_face:")), Collections.singletonList(":worried:"), Collections.singletonList(":worried:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "worried face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_CONCERNED, false);

    /**
     * 🙁
     */
    Emoji SLIGHTLY_FROWNING_FACE = new Emoji("🙁", "\uD83D\uDE41", Collections.unmodifiableList(Arrays.asList(":slight_frown:", ":slightly_frowning_face:")), Collections.singletonList(":slightly_frowning_face:"), Collections.singletonList(":slightly_frowning_face:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "slightly frowning face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_CONCERNED, false);

    /**
     * ☹️
     */
    Emoji FROWNING_FACE = new Emoji("☹️", "\u2639\uFE0F", Collections.unmodifiableList(Arrays.asList(":frowning2:", ":white_frowning_face:", ":frowning_face:")), Collections.singletonList(":white_frowning_face:"), Collections.singletonList(":frowning_face:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "frowning face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_CONCERNED, false);

    /**
     * ☹
     */
    Emoji FROWNING_FACE_UNQUALIFIED = new Emoji("☹", "\u2639", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":frowning_face:"), false, false, 0.7, Qualification.fromString("unqualified"), "frowning face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_CONCERNED, true);

    /**
     * 😮
     */
    Emoji FACE_WITH_OPEN_MOUTH = new Emoji("😮", "\uD83D\uDE2E", Collections.unmodifiableList(Arrays.asList(":open_mouth:", ":o", ":-o", ":O", ":-O", "=o", "=-o", "=O", "=-O")), Collections.singletonList(":open_mouth:"), Collections.singletonList(":open_mouth:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "face with open mouth", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_CONCERNED, false);

    /**
     * 😯
     */
    Emoji HUSHED_FACE = new Emoji("😯", "\uD83D\uDE2F", Collections.unmodifiableList(Arrays.asList(":hushed:", ":hushed_face:")), Collections.singletonList(":hushed:"), Collections.singletonList(":hushed:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "hushed face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_CONCERNED, false);

    /**
     * 😲
     */
    Emoji ASTONISHED_FACE = new Emoji("😲", "\uD83D\uDE32", Collections.singletonList(":astonished:"), Collections.singletonList(":astonished:"), Collections.singletonList(":astonished:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "astonished face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_CONCERNED, false);

    /**
     * 😳
     */
    Emoji FLUSHED_FACE = new Emoji("😳", "\uD83D\uDE33", Collections.unmodifiableList(Arrays.asList(":flushed:", ":flushed_face:")), Collections.singletonList(":flushed:"), Collections.singletonList(":flushed:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "flushed face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_CONCERNED, false);

    /**
     * 🥺
     */
    Emoji PLEADING_FACE = new Emoji("🥺", "\uD83E\uDD7A", Collections.singletonList(":pleading_face:"), Collections.singletonList(":pleading_face:"), Collections.singletonList(":pleading_face:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "pleading face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_CONCERNED, false);

    /**
     * 🥹
     */
    Emoji FACE_HOLDING_BACK_TEARS = new Emoji("🥹", "\uD83E\uDD79", Collections.singletonList(":face_holding_back_tears:"), Collections.emptyList(), Collections.singletonList(":face_holding_back_tears:"), false, false, 14.0, Qualification.fromString("fully-qualified"), "face holding back tears", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_CONCERNED, false);

    /**
     * 😦
     */
    Emoji FROWNING_FACE_WITH_OPEN_MOUTH = new Emoji("😦", "\uD83D\uDE26", Collections.unmodifiableList(Arrays.asList(":frowning:", ":(", ":-(", "=(", "=-(")), Collections.singletonList(":frowning:"), Collections.singletonList(":frowning:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "frowning face with open mouth", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_CONCERNED, false);

    /**
     * 😧
     */
    Emoji ANGUISHED_FACE = new Emoji("😧", "\uD83D\uDE27", Collections.singletonList(":anguished:"), Collections.singletonList(":anguished:"), Collections.singletonList(":anguished:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "anguished face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_CONCERNED, false);

    /**
     * 😨
     */
    Emoji FEARFUL_FACE = new Emoji("😨", "\uD83D\uDE28", Collections.unmodifiableList(Arrays.asList(":fearful:", ":fearful_face:")), Collections.singletonList(":fearful:"), Collections.singletonList(":fearful:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "fearful face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_CONCERNED, false);

    /**
     * 😰
     */
    Emoji ANXIOUS_FACE_WITH_SWEAT = new Emoji("😰", "\uD83D\uDE30", Collections.singletonList(":cold_sweat:"), Collections.singletonList(":cold_sweat:"), Collections.singletonList(":cold_sweat:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "anxious face with sweat", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_CONCERNED, false);

    /**
     * 😥
     */
    Emoji SAD_BUT_RELIEVED_FACE = new Emoji("😥", "\uD83D\uDE25", Collections.singletonList(":disappointed_relieved:"), Collections.singletonList(":disappointed_relieved:"), Collections.singletonList(":disappointed_relieved:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "sad but relieved face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_CONCERNED, false);

    /**
     * 😢
     */
    Emoji CRYING_FACE = new Emoji("😢", "\uD83D\uDE22", Collections.unmodifiableList(Arrays.asList(":cry:", ":crying_face:", ":'(", ":'-(", ":,(", ":,-(", "='(", "='-(", "=,(", "=,-(")), Collections.singletonList(":cry:"), Collections.singletonList(":cry:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "crying face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_CONCERNED, false);

    /**
     * 😭
     */
    Emoji LOUDLY_CRYING_FACE = new Emoji("😭", "\uD83D\uDE2D", Collections.unmodifiableList(Arrays.asList(":sob:", ":,'(", ":,'-(", ";(", ";-(", "=,'(", "=,'-(")), Collections.singletonList(":sob:"), Collections.singletonList(":sob:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "loudly crying face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_CONCERNED, false);

    /**
     * 😱
     */
    Emoji FACE_SCREAMING_IN_FEAR = new Emoji("😱", "\uD83D\uDE31", Collections.singletonList(":scream:"), Collections.singletonList(":scream:"), Collections.singletonList(":scream:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "face screaming in fear", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_CONCERNED, false);

    /**
     * 😖
     */
    Emoji CONFOUNDED_FACE = new Emoji("😖", "\uD83D\uDE16", Collections.singletonList(":confounded:"), Collections.singletonList(":confounded:"), Collections.singletonList(":confounded:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "confounded face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_CONCERNED, false);

    /**
     * 😣
     */
    Emoji PERSEVERING_FACE = new Emoji("😣", "\uD83D\uDE23", Collections.singletonList(":persevere:"), Collections.singletonList(":persevere:"), Collections.singletonList(":persevere:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "persevering face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_CONCERNED, false);

    /**
     * 😞
     */
    Emoji DISAPPOINTED_FACE = new Emoji("😞", "\uD83D\uDE1E", Collections.singletonList(":disappointed:"), Collections.singletonList(":disappointed:"), Collections.singletonList(":disappointed:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "disappointed face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_CONCERNED, false);

    /**
     * 😓
     */
    Emoji DOWNCAST_FACE_WITH_SWEAT = new Emoji("😓", "\uD83D\uDE13", Collections.unmodifiableList(Arrays.asList(":sweat:", ",:(", ",:-(", ",=(", ",=-(")), Collections.singletonList(":sweat:"), Collections.singletonList(":sweat:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "downcast face with sweat", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_CONCERNED, false);

    /**
     * 😩
     */
    Emoji WEARY_FACE = new Emoji("😩", "\uD83D\uDE29", Collections.unmodifiableList(Arrays.asList(":weary:", ":weary_face:")), Collections.singletonList(":weary:"), Collections.singletonList(":weary:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "weary face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_CONCERNED, false);

    /**
     * 😫
     */
    Emoji TIRED_FACE = new Emoji("😫", "\uD83D\uDE2B", Collections.singletonList(":tired_face:"), Collections.singletonList(":tired_face:"), Collections.singletonList(":tired_face:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "tired face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_CONCERNED, false);

    /**
     * 🥱
     */
    Emoji YAWNING_FACE = new Emoji("🥱", "\uD83E\uDD71", Collections.singletonList(":yawning_face:"), Collections.singletonList(":yawning_face:"), Collections.singletonList(":yawning_face:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "yawning face", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.FACE_CONCERNED, false);
}
