package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiEmotion {

    /**
     * 💋
     */
    Emoji KISS_MARK = new Emoji("💋", "\uD83D\uDC8B", Collections.unmodifiableList(Arrays.asList(":kiss:", ":kiss_mark:")), Collections.singletonList(":kiss:"), Collections.singletonList(":kiss:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "kiss mark", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.EMOTION, false);

    /**
     * 💯
     */
    Emoji HUNDRED_POINTS = new Emoji("💯", "\uD83D\uDCAF", Collections.singletonList(":100:"), Collections.singletonList(":100:"), Collections.singletonList(":100:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "hundred points", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.EMOTION, false);

    /**
     * 💢
     */
    Emoji ANGER_SYMBOL = new Emoji("💢", "\uD83D\uDCA2", Collections.singletonList(":anger:"), Collections.singletonList(":anger:"), Collections.singletonList(":anger:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "anger symbol", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.EMOTION, false);

    /**
     * 💥
     */
    Emoji COLLISION = new Emoji("💥", "\uD83D\uDCA5", Collections.unmodifiableList(Arrays.asList(":boom:", ":collision:")), Collections.singletonList(":boom:"), Collections.unmodifiableList(Arrays.asList(":boom:", ":collision:")), false, false, 0.6, Qualification.fromString("fully-qualified"), "collision", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.EMOTION, false);

    /**
     * 💫
     */
    Emoji DIZZY = new Emoji("💫", "\uD83D\uDCAB", Collections.singletonList(":dizzy:"), Collections.singletonList(":dizzy:"), Collections.singletonList(":dizzy:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "dizzy", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.EMOTION, false);

    /**
     * 💦
     */
    Emoji SWEAT_DROPLETS = new Emoji("💦", "\uD83D\uDCA6", Collections.singletonList(":sweat_drops:"), Collections.singletonList(":sweat_drops:"), Collections.singletonList(":sweat_drops:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "sweat droplets", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.EMOTION, false);

    /**
     * 💨
     */
    Emoji DASHING_AWAY = new Emoji("💨", "\uD83D\uDCA8", Collections.unmodifiableList(Arrays.asList(":dash:", ":dashing_away:")), Collections.singletonList(":dash:"), Collections.singletonList(":dash:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "dashing away", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.EMOTION, false);

    /**
     * 🕳️
     */
    Emoji HOLE = new Emoji("🕳️", "\uD83D\uDD73\uFE0F", Collections.singletonList(":hole:"), Collections.singletonList(":hole:"), Collections.singletonList(":hole:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "hole", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.EMOTION, false);

    /**
     * 🕳
     */
    Emoji HOLE_UNQUALIFIED = new Emoji("🕳", "\uD83D\uDD73", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":hole:"), false, false, 0.7, Qualification.fromString("unqualified"), "hole", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.EMOTION, true);

    /**
     * 💬
     */
    Emoji SPEECH_BALLOON = new Emoji("💬", "\uD83D\uDCAC", Collections.singletonList(":speech_balloon:"), Collections.singletonList(":speech_balloon:"), Collections.singletonList(":speech_balloon:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "speech balloon", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.EMOTION, false);

    /**
     * 👁️‍🗨️
     */
    Emoji EYE_IN_SPEECH_BUBBLE = new Emoji("👁️‍🗨️", "\uD83D\uDC41\uFE0F\u200D\uD83D\uDDE8\uFE0F", Collections.emptyList(), Collections.singletonList(":eye-in-speech-bubble:"), Collections.singletonList(":eye_speech_bubble:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "eye in speech bubble", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.EMOTION, false);

    /**
     * 👁‍🗨️
     */
    Emoji EYE_IN_SPEECH_BUBBLE_UNQUALIFIED_0 = new Emoji("👁‍🗨️", "\uD83D\uDC41\u200D\uD83D\uDDE8\uFE0F", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 2.0, Qualification.fromString("unqualified"), "eye in speech bubble", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.EMOTION, false);

    /**
     * 👁️‍🗨
     */
    Emoji EYE_IN_SPEECH_BUBBLE_MINIMALLY_QUALIFIED = new Emoji("👁️‍🗨", "\uD83D\uDC41\uFE0F\u200D\uD83D\uDDE8", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 2.0, Qualification.fromString("minimally-qualified"), "eye in speech bubble", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.EMOTION, false);

    /**
     * 👁‍🗨
     */
    Emoji EYE_IN_SPEECH_BUBBLE_UNQUALIFIED_1 = new Emoji("👁‍🗨", "\uD83D\uDC41\u200D\uD83D\uDDE8", Collections.singletonList(":eye_in_speech_bubble:"), Collections.emptyList(), Collections.emptyList(), false, false, 2.0, Qualification.fromString("unqualified"), "eye in speech bubble", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.EMOTION, false);

    /**
     * 🗨️
     */
    Emoji LEFT_SPEECH_BUBBLE = new Emoji("🗨️", "\uD83D\uDDE8\uFE0F", Collections.unmodifiableList(Arrays.asList(":speech_left:", ":left_speech_bubble:")), Collections.singletonList(":left_speech_bubble:"), Collections.singletonList(":left_speech_bubble:"), false, false, 2.0, Qualification.fromString("fully-qualified"), "left speech bubble", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.EMOTION, false);

    /**
     * 🗨
     */
    Emoji LEFT_SPEECH_BUBBLE_UNQUALIFIED = new Emoji("🗨", "\uD83D\uDDE8", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":left_speech_bubble:"), false, false, 2.0, Qualification.fromString("unqualified"), "left speech bubble", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.EMOTION, true);

    /**
     * 🗯️
     */
    Emoji RIGHT_ANGER_BUBBLE = new Emoji("🗯️", "\uD83D\uDDEF\uFE0F", Collections.unmodifiableList(Arrays.asList(":anger_right:", ":right_anger_bubble:")), Collections.singletonList(":right_anger_bubble:"), Collections.singletonList(":right_anger_bubble:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "right anger bubble", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.EMOTION, false);

    /**
     * 🗯
     */
    Emoji RIGHT_ANGER_BUBBLE_UNQUALIFIED = new Emoji("🗯", "\uD83D\uDDEF", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":right_anger_bubble:"), false, false, 0.7, Qualification.fromString("unqualified"), "right anger bubble", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.EMOTION, true);

    /**
     * 💭
     */
    Emoji THOUGHT_BALLOON = new Emoji("💭", "\uD83D\uDCAD", Collections.singletonList(":thought_balloon:"), Collections.singletonList(":thought_balloon:"), Collections.singletonList(":thought_balloon:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "thought balloon", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.EMOTION, false);

    /**
     * 💤
     */
    Emoji ZZZ = new Emoji("💤", "\uD83D\uDCA4", Collections.singletonList(":zzz:"), Collections.singletonList(":zzz:"), Collections.singletonList(":zzz:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "ZZZ", EmojiGroup.SMILEYS_AND_EMOTION, EmojiSubGroup.EMOTION, false);
}
