package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiDishware {

    /**
     * 🥢
     */
    Emoji CHOPSTICKS = new Emoji("🥢", "\uD83E\uDD62", Collections.singletonList(":chopsticks:"), Collections.singletonList(":chopsticks:"), Collections.singletonList(":chopsticks:"), false, false, 5.0, Qualification.fromString("fully-qualified"), "chopsticks", EmojiGroup.FOOD_AND_DRINK, EmojiSubGroup.DISHWARE, false);

    /**
     * 🍽️
     */
    Emoji FORK_AND_KNIFE_WITH_PLATE = new Emoji("🍽️", "\uD83C\uDF7D\uFE0F", Collections.unmodifiableList(Arrays.asList(":fork_knife_plate:", ":fork_and_knife_with_plate:")), Collections.singletonList(":knife_fork_plate:"), Collections.singletonList(":plate_with_cutlery:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "fork and knife with plate", EmojiGroup.FOOD_AND_DRINK, EmojiSubGroup.DISHWARE, false);

    /**
     * 🍽
     */
    Emoji FORK_AND_KNIFE_WITH_PLATE_UNQUALIFIED = new Emoji("🍽", "\uD83C\uDF7D", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":plate_with_cutlery:"), false, false, 0.7, Qualification.fromString("unqualified"), "fork and knife with plate", EmojiGroup.FOOD_AND_DRINK, EmojiSubGroup.DISHWARE, true);

    /**
     * 🍴
     */
    Emoji FORK_AND_KNIFE = new Emoji("🍴", "\uD83C\uDF74", Collections.singletonList(":fork_and_knife:"), Collections.singletonList(":fork_and_knife:"), Collections.singletonList(":fork_and_knife:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "fork and knife", EmojiGroup.FOOD_AND_DRINK, EmojiSubGroup.DISHWARE, false);

    /**
     * 🥄
     */
    Emoji SPOON = new Emoji("🥄", "\uD83E\uDD44", Collections.singletonList(":spoon:"), Collections.singletonList(":spoon:"), Collections.singletonList(":spoon:"), false, false, 3.0, Qualification.fromString("fully-qualified"), "spoon", EmojiGroup.FOOD_AND_DRINK, EmojiSubGroup.DISHWARE, false);

    /**
     * 🔪
     */
    Emoji KITCHEN_KNIFE = new Emoji("🔪", "\uD83D\uDD2A", Collections.unmodifiableList(Arrays.asList(":knife:", ":kitchen_knife:")), Collections.singletonList(":hocho:"), Collections.unmodifiableList(Arrays.asList(":hocho:", ":knife:")), false, false, 0.6, Qualification.fromString("fully-qualified"), "kitchen knife", EmojiGroup.FOOD_AND_DRINK, EmojiSubGroup.DISHWARE, false);

    /**
     * 🫙
     */
    Emoji JAR = new Emoji("🫙", "\uD83E\uDED9", Collections.singletonList(":jar:"), Collections.emptyList(), Collections.singletonList(":jar:"), false, false, 14.0, Qualification.fromString("fully-qualified"), "jar", EmojiGroup.FOOD_AND_DRINK, EmojiSubGroup.DISHWARE, false);

    /**
     * 🏺
     */
    Emoji AMPHORA = new Emoji("🏺", "\uD83C\uDFFA", Collections.singletonList(":amphora:"), Collections.singletonList(":amphora:"), Collections.singletonList(":amphora:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "amphora", EmojiGroup.FOOD_AND_DRINK, EmojiSubGroup.DISHWARE, false);
}
