package net.fellbaum.jemoji;

public enum EmojiDescriptionLanguage {

    AF("af"),
    AM("am"),
    AR_SA("ar-SA"),
    AR("ar"),
    AS("as"),
    AST("ast"),
    AZ("az"),
    BE("be"),
    BEW("bew"),
    BG("bg"),
    BGN("bgn"),
    BN("bn"),
    BR("br"),
    BS("bs"),
    CA("ca"),
    CCP("ccp"),
    CEB("ceb"),
    CHR("chr"),
    CKB("ckb"),
    CS("cs"),
    CV("cv"),
    CY("cy"),
    DA("da"),
    DE_CH("de-CH"),
    DE("de"),
    DOI("doi"),
    DSB("dsb"),
    EL("el"),
    EN_001("en-001"),
    EN_AU("en-AU"),
    EN_CA("en-CA"),
    EN_GB("en-GB"),
    EN_IN("en-IN"),
    EN("en"),
    ES_419("es-419"),
    ES_MX("es-MX"),
    ES_US("es-US"),
    ES("es"),
    ET("et"),
    EU("eu"),
    FA("fa"),
    FF_ADLM("ff-Adlm"),
    FF("ff"),
    FI("fi"),
    FIL("fil"),
    FO("fo"),
    FR_CA("fr-CA"),
    FR("fr"),
    GA("ga"),
    GD("gd"),
    GL("gl"),
    GU("gu"),
    HA("ha"),
    HE("he"),
    HI_LATN("hi-Latn"),
    HI("hi"),
    HR("hr"),
    HSB("hsb"),
    HU("hu"),
    HY("hy"),
    IA("ia"),
    ID("id"),
    IG("ig"),
    IS("is"),
    IT("it"),
    JA("ja"),
    JV("jv"),
    KA("ka"),
    KAB("kab"),
    KK("kk"),
    KL("kl"),
    KM("km"),
    KN("kn"),
    KO("ko"),
    KOK("kok"),
    KU("ku"),
    KY("ky"),
    LB("lb"),
    LIJ("lij"),
    LO("lo"),
    LT("lt"),
    LV("lv"),
    MAI("mai"),
    MI("mi"),
    MK("mk"),
    ML("ml"),
    MN("mn"),
    MNI("mni"),
    MR("mr"),
    MS("ms"),
    MT("mt"),
    MY("my"),
    NE("ne"),
    NL("nl"),
    NN("nn"),
    NO("no"),
    NSO("nso"),
    OC("oc"),
    OR("or"),
    PA_ARAB("pa-Arab"),
    PA("pa"),
    PCM("pcm"),
    PL("pl"),
    PS("ps"),
    PT_PT("pt-PT"),
    PT("pt"),
    QU("qu"),
    QUC("quc"),
    RHG("rhg"),
    RM("rm"),
    RO("ro"),
    RU("ru"),
    RW("rw"),
    SA("sa"),
    SAT("sat"),
    SC("sc"),
    SD("sd"),
    SI("si"),
    SK("sk"),
    SL("sl"),
    SO("so"),
    SQ("sq"),
    SR_CYRL_BA("sr-Cyrl-BA"),
    SR_CYRL("sr-Cyrl"),
    SR_LATN_BA("sr-Latn-BA"),
    SR_LATN("sr-Latn"),
    SR("sr"),
    SU("su"),
    SV("sv"),
    SW_KE("sw-KE"),
    SW("sw"),
    TA("ta"),
    TE("te"),
    TG("tg"),
    TH("th"),
    TI("ti"),
    TK("tk"),
    TN("tn"),
    TO("to"),
    TR("tr"),
    TT("tt"),
    UG("ug"),
    UK("uk"),
    UND("und"),
    UR("ur"),
    UZ("uz"),
    VI("vi"),
    WO("wo"),
    XH("xh"),
    YO_BJ("yo-BJ"),
    YO("yo"),
    YUE_HANS("yue-Hans"),
    YUE("yue"),
    ZH_HANT_HK("zh-Hant-HK"),
    ZH_HANT("zh-Hant"),
    ZH("zh"),
    ZU("zu");

    private final String value;

    EmojiDescriptionLanguage(String value) {
        this.value = value;
    }

    /**
     * Gets the value.
     *
     * @return The value.
     */
    public String getValue() {
        return value;
    }
}
