package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiBookPaper {

    /**
     * 📔
     */
    Emoji NOTEBOOK_WITH_DECORATIVE_COVER = new Emoji("📔", "\uD83D\uDCD4", Collections.singletonList(":notebook_with_decorative_cover:"), Collections.singletonList(":notebook_with_decorative_cover:"), Collections.singletonList(":notebook_with_decorative_cover:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "notebook with decorative cover", EmojiGroup.OBJECTS, EmojiSubGroup.BOOK_PAPER, false);

    /**
     * 📕
     */
    Emoji CLOSED_BOOK = new Emoji("📕", "\uD83D\uDCD5", Collections.singletonList(":closed_book:"), Collections.singletonList(":closed_book:"), Collections.singletonList(":closed_book:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "closed book", EmojiGroup.OBJECTS, EmojiSubGroup.BOOK_PAPER, false);

    /**
     * 📖
     */
    Emoji OPEN_BOOK = new Emoji("📖", "\uD83D\uDCD6", Collections.unmodifiableList(Arrays.asList(":book:", ":open_book:")), Collections.singletonList(":book:"), Collections.unmodifiableList(Arrays.asList(":book:", ":open_book:")), false, false, 0.6, Qualification.fromString("fully-qualified"), "open book", EmojiGroup.OBJECTS, EmojiSubGroup.BOOK_PAPER, false);

    /**
     * 📗
     */
    Emoji GREEN_BOOK = new Emoji("📗", "\uD83D\uDCD7", Collections.singletonList(":green_book:"), Collections.singletonList(":green_book:"), Collections.singletonList(":green_book:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "green book", EmojiGroup.OBJECTS, EmojiSubGroup.BOOK_PAPER, false);

    /**
     * 📘
     */
    Emoji BLUE_BOOK = new Emoji("📘", "\uD83D\uDCD8", Collections.singletonList(":blue_book:"), Collections.singletonList(":blue_book:"), Collections.singletonList(":blue_book:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "blue book", EmojiGroup.OBJECTS, EmojiSubGroup.BOOK_PAPER, false);

    /**
     * 📙
     */
    Emoji ORANGE_BOOK = new Emoji("📙", "\uD83D\uDCD9", Collections.singletonList(":orange_book:"), Collections.singletonList(":orange_book:"), Collections.singletonList(":orange_book:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "orange book", EmojiGroup.OBJECTS, EmojiSubGroup.BOOK_PAPER, false);

    /**
     * 📚
     */
    Emoji BOOKS = new Emoji("📚", "\uD83D\uDCDA", Collections.singletonList(":books:"), Collections.singletonList(":books:"), Collections.singletonList(":books:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "books", EmojiGroup.OBJECTS, EmojiSubGroup.BOOK_PAPER, true);

    /**
     * 📓
     */
    Emoji NOTEBOOK = new Emoji("📓", "\uD83D\uDCD3", Collections.singletonList(":notebook:"), Collections.singletonList(":notebook:"), Collections.singletonList(":notebook:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "notebook", EmojiGroup.OBJECTS, EmojiSubGroup.BOOK_PAPER, false);

    /**
     * 📒
     */
    Emoji LEDGER = new Emoji("📒", "\uD83D\uDCD2", Collections.singletonList(":ledger:"), Collections.singletonList(":ledger:"), Collections.singletonList(":ledger:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "ledger", EmojiGroup.OBJECTS, EmojiSubGroup.BOOK_PAPER, false);

    /**
     * 📃
     */
    Emoji PAGE_WITH_CURL = new Emoji("📃", "\uD83D\uDCC3", Collections.singletonList(":page_with_curl:"), Collections.singletonList(":page_with_curl:"), Collections.singletonList(":page_with_curl:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "page with curl", EmojiGroup.OBJECTS, EmojiSubGroup.BOOK_PAPER, false);

    /**
     * 📜
     */
    Emoji SCROLL = new Emoji("📜", "\uD83D\uDCDC", Collections.singletonList(":scroll:"), Collections.singletonList(":scroll:"), Collections.singletonList(":scroll:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "scroll", EmojiGroup.OBJECTS, EmojiSubGroup.BOOK_PAPER, false);

    /**
     * 📄
     */
    Emoji PAGE_FACING_UP = new Emoji("📄", "\uD83D\uDCC4", Collections.singletonList(":page_facing_up:"), Collections.singletonList(":page_facing_up:"), Collections.singletonList(":page_facing_up:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "page facing up", EmojiGroup.OBJECTS, EmojiSubGroup.BOOK_PAPER, false);

    /**
     * 📰
     */
    Emoji NEWSPAPER = new Emoji("📰", "\uD83D\uDCF0", Collections.singletonList(":newspaper:"), Collections.singletonList(":newspaper:"), Collections.singletonList(":newspaper:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "newspaper", EmojiGroup.OBJECTS, EmojiSubGroup.BOOK_PAPER, false);

    /**
     * 🗞️
     */
    Emoji ROLLED_UP_NEWSPAPER = new Emoji("🗞️", "\uD83D\uDDDE\uFE0F", Collections.unmodifiableList(Arrays.asList(":newspaper2:", ":rolled_up_newspaper:")), Collections.singletonList(":rolled_up_newspaper:"), Collections.singletonList(":newspaper_roll:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "rolled-up newspaper", EmojiGroup.OBJECTS, EmojiSubGroup.BOOK_PAPER, false);

    /**
     * 🗞
     */
    Emoji ROLLED_UP_NEWSPAPER_UNQUALIFIED = new Emoji("🗞", "\uD83D\uDDDE", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":newspaper_roll:"), false, false, 0.7, Qualification.fromString("unqualified"), "rolled-up newspaper", EmojiGroup.OBJECTS, EmojiSubGroup.BOOK_PAPER, true);

    /**
     * 📑
     */
    Emoji BOOKMARK_TABS = new Emoji("📑", "\uD83D\uDCD1", Collections.singletonList(":bookmark_tabs:"), Collections.singletonList(":bookmark_tabs:"), Collections.singletonList(":bookmark_tabs:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "bookmark tabs", EmojiGroup.OBJECTS, EmojiSubGroup.BOOK_PAPER, false);

    /**
     * 🔖
     */
    Emoji BOOKMARK = new Emoji("🔖", "\uD83D\uDD16", Collections.singletonList(":bookmark:"), Collections.singletonList(":bookmark:"), Collections.singletonList(":bookmark:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "bookmark", EmojiGroup.OBJECTS, EmojiSubGroup.BOOK_PAPER, false);

    /**
     * 🏷️
     */
    Emoji LABEL = new Emoji("🏷️", "\uD83C\uDFF7\uFE0F", Collections.singletonList(":label:"), Collections.singletonList(":label:"), Collections.singletonList(":label:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "label", EmojiGroup.OBJECTS, EmojiSubGroup.BOOK_PAPER, false);

    /**
     * 🏷
     */
    Emoji LABEL_UNQUALIFIED = new Emoji("🏷", "\uD83C\uDFF7", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":label:"), false, false, 0.7, Qualification.fromString("unqualified"), "label", EmojiGroup.OBJECTS, EmojiSubGroup.BOOK_PAPER, true);
}
