package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiArrow {

    /**
     * ⬆️
     */
    Emoji UP_ARROW = new Emoji("⬆️", "\u2B06\uFE0F", Collections.unmodifiableList(Arrays.asList(":arrow_up:", ":up_arrow:")), Collections.singletonList(":arrow_up:"), Collections.singletonList(":arrow_up:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "up arrow", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, false);

    /**
     * ⬆
     */
    Emoji UP_ARROW_UNQUALIFIED = new Emoji("⬆", "\u2B06", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":arrow_up:"), false, false, 0.6, Qualification.fromString("unqualified"), "up arrow", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, true);

    /**
     * ↗️
     */
    Emoji UP_RIGHT_ARROW = new Emoji("↗️", "\u2197\uFE0F", Collections.singletonList(":arrow_upper_right:"), Collections.singletonList(":arrow_upper_right:"), Collections.singletonList(":arrow_upper_right:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "up-right arrow", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, false);

    /**
     * ↗
     */
    Emoji UP_RIGHT_ARROW_UNQUALIFIED = new Emoji("↗", "\u2197", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":arrow_upper_right:"), false, false, 0.6, Qualification.fromString("unqualified"), "up-right arrow", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, true);

    /**
     * ➡️
     */
    Emoji RIGHT_ARROW = new Emoji("➡️", "\u27A1\uFE0F", Collections.unmodifiableList(Arrays.asList(":arrow_right:", ":right_arrow:")), Collections.singletonList(":arrow_right:"), Collections.singletonList(":arrow_right:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "right arrow", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, false);

    /**
     * ➡
     */
    Emoji RIGHT_ARROW_UNQUALIFIED = new Emoji("➡", "\u27A1", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":arrow_right:"), false, false, 0.6, Qualification.fromString("unqualified"), "right arrow", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, true);

    /**
     * ↘️
     */
    Emoji DOWN_RIGHT_ARROW = new Emoji("↘️", "\u2198\uFE0F", Collections.singletonList(":arrow_lower_right:"), Collections.singletonList(":arrow_lower_right:"), Collections.singletonList(":arrow_lower_right:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "down-right arrow", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, false);

    /**
     * ↘
     */
    Emoji DOWN_RIGHT_ARROW_UNQUALIFIED = new Emoji("↘", "\u2198", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":arrow_lower_right:"), false, false, 0.6, Qualification.fromString("unqualified"), "down-right arrow", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, true);

    /**
     * ⬇️
     */
    Emoji DOWN_ARROW = new Emoji("⬇️", "\u2B07\uFE0F", Collections.unmodifiableList(Arrays.asList(":arrow_down:", ":down_arrow:")), Collections.singletonList(":arrow_down:"), Collections.singletonList(":arrow_down:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "down arrow", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, false);

    /**
     * ⬇
     */
    Emoji DOWN_ARROW_UNQUALIFIED = new Emoji("⬇", "\u2B07", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":arrow_down:"), false, false, 0.6, Qualification.fromString("unqualified"), "down arrow", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, true);

    /**
     * ↙️
     */
    Emoji DOWN_LEFT_ARROW = new Emoji("↙️", "\u2199\uFE0F", Collections.singletonList(":arrow_lower_left:"), Collections.singletonList(":arrow_lower_left:"), Collections.singletonList(":arrow_lower_left:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "down-left arrow", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, false);

    /**
     * ↙
     */
    Emoji DOWN_LEFT_ARROW_UNQUALIFIED = new Emoji("↙", "\u2199", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":arrow_lower_left:"), false, false, 0.6, Qualification.fromString("unqualified"), "down-left arrow", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, true);

    /**
     * ⬅️
     */
    Emoji LEFT_ARROW = new Emoji("⬅️", "\u2B05\uFE0F", Collections.unmodifiableList(Arrays.asList(":arrow_left:", ":left_arrow:")), Collections.singletonList(":arrow_left:"), Collections.singletonList(":arrow_left:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "left arrow", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, false);

    /**
     * ⬅
     */
    Emoji LEFT_ARROW_UNQUALIFIED = new Emoji("⬅", "\u2B05", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":arrow_left:"), false, false, 0.6, Qualification.fromString("unqualified"), "left arrow", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, true);

    /**
     * ↖️
     */
    Emoji UP_LEFT_ARROW = new Emoji("↖️", "\u2196\uFE0F", Collections.unmodifiableList(Arrays.asList(":arrow_upper_left:", ":up_left_arrow:")), Collections.singletonList(":arrow_upper_left:"), Collections.singletonList(":arrow_upper_left:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "up-left arrow", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, false);

    /**
     * ↖
     */
    Emoji UP_LEFT_ARROW_UNQUALIFIED = new Emoji("↖", "\u2196", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":arrow_upper_left:"), false, false, 0.6, Qualification.fromString("unqualified"), "up-left arrow", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, true);

    /**
     * ↕️
     */
    Emoji UP_DOWN_ARROW = new Emoji("↕️", "\u2195\uFE0F", Collections.unmodifiableList(Arrays.asList(":arrow_up_down:", ":up_down_arrow:")), Collections.singletonList(":arrow_up_down:"), Collections.singletonList(":arrow_up_down:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "up-down arrow", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, false);

    /**
     * ↕
     */
    Emoji UP_DOWN_ARROW_UNQUALIFIED = new Emoji("↕", "\u2195", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":arrow_up_down:"), false, false, 0.6, Qualification.fromString("unqualified"), "up-down arrow", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, true);

    /**
     * ↔️
     */
    Emoji LEFT_RIGHT_ARROW = new Emoji("↔️", "\u2194\uFE0F", Collections.singletonList(":left_right_arrow:"), Collections.singletonList(":left_right_arrow:"), Collections.singletonList(":left_right_arrow:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "left-right arrow", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, false);

    /**
     * ↔
     */
    Emoji LEFT_RIGHT_ARROW_UNQUALIFIED = new Emoji("↔", "\u2194", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":left_right_arrow:"), false, false, 0.6, Qualification.fromString("unqualified"), "left-right arrow", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, true);

    /**
     * ↩️
     */
    Emoji RIGHT_ARROW_CURVING_LEFT = new Emoji("↩️", "\u21A9\uFE0F", Collections.singletonList(":leftwards_arrow_with_hook:"), Collections.singletonList(":leftwards_arrow_with_hook:"), Collections.singletonList(":leftwards_arrow_with_hook:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "right arrow curving left", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, false);

    /**
     * ↩
     */
    Emoji RIGHT_ARROW_CURVING_LEFT_UNQUALIFIED = new Emoji("↩", "\u21A9", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":leftwards_arrow_with_hook:"), false, false, 0.6, Qualification.fromString("unqualified"), "right arrow curving left", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, true);

    /**
     * ↪️
     */
    Emoji LEFT_ARROW_CURVING_RIGHT = new Emoji("↪️", "\u21AA\uFE0F", Collections.singletonList(":arrow_right_hook:"), Collections.singletonList(":arrow_right_hook:"), Collections.singletonList(":arrow_right_hook:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "left arrow curving right", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, false);

    /**
     * ↪
     */
    Emoji LEFT_ARROW_CURVING_RIGHT_UNQUALIFIED = new Emoji("↪", "\u21AA", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":arrow_right_hook:"), false, false, 0.6, Qualification.fromString("unqualified"), "left arrow curving right", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, true);

    /**
     * ⤴️
     */
    Emoji RIGHT_ARROW_CURVING_UP = new Emoji("⤴️", "\u2934\uFE0F", Collections.singletonList(":arrow_heading_up:"), Collections.singletonList(":arrow_heading_up:"), Collections.singletonList(":arrow_heading_up:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "right arrow curving up", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, false);

    /**
     * ⤴
     */
    Emoji RIGHT_ARROW_CURVING_UP_UNQUALIFIED = new Emoji("⤴", "\u2934", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":arrow_heading_up:"), false, false, 0.6, Qualification.fromString("unqualified"), "right arrow curving up", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, true);

    /**
     * ⤵️
     */
    Emoji RIGHT_ARROW_CURVING_DOWN = new Emoji("⤵️", "\u2935\uFE0F", Collections.singletonList(":arrow_heading_down:"), Collections.singletonList(":arrow_heading_down:"), Collections.singletonList(":arrow_heading_down:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "right arrow curving down", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, false);

    /**
     * ⤵
     */
    Emoji RIGHT_ARROW_CURVING_DOWN_UNQUALIFIED = new Emoji("⤵", "\u2935", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":arrow_heading_down:"), false, false, 0.6, Qualification.fromString("unqualified"), "right arrow curving down", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, true);

    /**
     * 🔃
     */
    Emoji CLOCKWISE_VERTICAL_ARROWS = new Emoji("🔃", "\uD83D\uDD03", Collections.singletonList(":arrows_clockwise:"), Collections.singletonList(":arrows_clockwise:"), Collections.singletonList(":arrows_clockwise:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "clockwise vertical arrows", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, false);

    /**
     * 🔄
     */
    Emoji COUNTERCLOCKWISE_ARROWS_BUTTON = new Emoji("🔄", "\uD83D\uDD04", Collections.singletonList(":arrows_counterclockwise:"), Collections.singletonList(":arrows_counterclockwise:"), Collections.singletonList(":arrows_counterclockwise:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "counterclockwise arrows button", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, false);

    /**
     * 🔙
     */
    Emoji BACK_ARROW = new Emoji("🔙", "\uD83D\uDD19", Collections.unmodifiableList(Arrays.asList(":back:", ":back_arrow:")), Collections.singletonList(":back:"), Collections.singletonList(":back:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "BACK arrow", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, false);

    /**
     * 🔚
     */
    Emoji END_ARROW = new Emoji("🔚", "\uD83D\uDD1A", Collections.unmodifiableList(Arrays.asList(":end:", ":end_arrow:")), Collections.singletonList(":end:"), Collections.singletonList(":end:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "END arrow", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, false);

    /**
     * 🔛
     */
    Emoji ON_ARROW = new Emoji("🔛", "\uD83D\uDD1B", Collections.unmodifiableList(Arrays.asList(":on:", ":on_arrow:")), Collections.singletonList(":on:"), Collections.singletonList(":on:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "ON! arrow", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, false);

    /**
     * 🔜
     */
    Emoji SOON_ARROW = new Emoji("🔜", "\uD83D\uDD1C", Collections.unmodifiableList(Arrays.asList(":soon:", ":soon_arrow:")), Collections.singletonList(":soon:"), Collections.singletonList(":soon:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "SOON arrow", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, false);

    /**
     * 🔝
     */
    Emoji TOP_ARROW = new Emoji("🔝", "\uD83D\uDD1D", Collections.unmodifiableList(Arrays.asList(":top:", ":top_arrow:")), Collections.singletonList(":top:"), Collections.singletonList(":top:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "TOP arrow", EmojiGroup.SYMBOLS, EmojiSubGroup.ARROW, false);
}
