package net.fellbaum.jemoji;

import java.util.Arrays;
import java.util.Collections;

@SuppressWarnings({ "unused", "UnnecessaryUnicodeEscape" })
interface EmojiAnimalBird {

    /**
     * 🦃
     */
    Emoji TURKEY = new Emoji("🦃", "\uD83E\uDD83", Collections.singletonList(":turkey:"), Collections.singletonList(":turkey:"), Collections.singletonList(":turkey:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "turkey", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BIRD, false);

    /**
     * 🐔
     */
    Emoji CHICKEN = new Emoji("🐔", "\uD83D\uDC14", Collections.singletonList(":chicken:"), Collections.singletonList(":chicken:"), Collections.singletonList(":chicken:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "chicken", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BIRD, false);

    /**
     * 🐓
     */
    Emoji ROOSTER = new Emoji("🐓", "\uD83D\uDC13", Collections.singletonList(":rooster:"), Collections.singletonList(":rooster:"), Collections.singletonList(":rooster:"), false, false, 1.0, Qualification.fromString("fully-qualified"), "rooster", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BIRD, false);

    /**
     * 🐣
     */
    Emoji HATCHING_CHICK = new Emoji("🐣", "\uD83D\uDC23", Collections.singletonList(":hatching_chick:"), Collections.singletonList(":hatching_chick:"), Collections.singletonList(":hatching_chick:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "hatching chick", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BIRD, false);

    /**
     * 🐤
     */
    Emoji BABY_CHICK = new Emoji("🐤", "\uD83D\uDC24", Collections.singletonList(":baby_chick:"), Collections.singletonList(":baby_chick:"), Collections.singletonList(":baby_chick:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "baby chick", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BIRD, false);

    /**
     * 🐥
     */
    Emoji FRONT_FACING_BABY_CHICK = new Emoji("🐥", "\uD83D\uDC25", Collections.singletonList(":hatched_chick:"), Collections.singletonList(":hatched_chick:"), Collections.singletonList(":hatched_chick:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "front-facing baby chick", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BIRD, false);

    /**
     * 🐦
     */
    Emoji BIRD = new Emoji("🐦", "\uD83D\uDC26", Collections.singletonList(":bird:"), Collections.singletonList(":bird:"), Collections.singletonList(":bird:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "bird", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BIRD, true);

    /**
     * 🐧
     */
    Emoji PENGUIN = new Emoji("🐧", "\uD83D\uDC27", Collections.singletonList(":penguin:"), Collections.singletonList(":penguin:"), Collections.singletonList(":penguin:"), false, false, 0.6, Qualification.fromString("fully-qualified"), "penguin", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BIRD, false);

    /**
     * 🕊️
     */
    Emoji DOVE = new Emoji("🕊️", "\uD83D\uDD4A\uFE0F", Collections.unmodifiableList(Arrays.asList(":dove:", ":dove_of_peace:")), Collections.singletonList(":dove_of_peace:"), Collections.singletonList(":dove:"), false, false, 0.7, Qualification.fromString("fully-qualified"), "dove", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BIRD, false);

    /**
     * 🕊
     */
    Emoji DOVE_UNQUALIFIED = new Emoji("🕊", "\uD83D\uDD4A", Collections.emptyList(), Collections.emptyList(), Collections.singletonList(":dove:"), false, false, 0.7, Qualification.fromString("unqualified"), "dove", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BIRD, true);

    /**
     * 🦅
     */
    Emoji EAGLE = new Emoji("🦅", "\uD83E\uDD85", Collections.singletonList(":eagle:"), Collections.singletonList(":eagle:"), Collections.singletonList(":eagle:"), false, false, 3.0, Qualification.fromString("fully-qualified"), "eagle", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BIRD, false);

    /**
     * 🦆
     */
    Emoji DUCK = new Emoji("🦆", "\uD83E\uDD86", Collections.singletonList(":duck:"), Collections.singletonList(":duck:"), Collections.singletonList(":duck:"), false, false, 3.0, Qualification.fromString("fully-qualified"), "duck", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BIRD, false);

    /**
     * 🦢
     */
    Emoji SWAN = new Emoji("🦢", "\uD83E\uDDA2", Collections.singletonList(":swan:"), Collections.singletonList(":swan:"), Collections.singletonList(":swan:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "swan", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BIRD, false);

    /**
     * 🦉
     */
    Emoji OWL = new Emoji("🦉", "\uD83E\uDD89", Collections.singletonList(":owl:"), Collections.singletonList(":owl:"), Collections.singletonList(":owl:"), false, false, 3.0, Qualification.fromString("fully-qualified"), "owl", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BIRD, false);

    /**
     * 🦤
     */
    Emoji DODO = new Emoji("🦤", "\uD83E\uDDA4", Collections.singletonList(":dodo:"), Collections.singletonList(":dodo:"), Collections.singletonList(":dodo:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "dodo", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BIRD, false);

    /**
     * 🪶
     */
    Emoji FEATHER = new Emoji("🪶", "\uD83E\uDEB6", Collections.singletonList(":feather:"), Collections.singletonList(":feather:"), Collections.singletonList(":feather:"), false, false, 13.0, Qualification.fromString("fully-qualified"), "feather", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BIRD, false);

    /**
     * 🦩
     */
    Emoji FLAMINGO = new Emoji("🦩", "\uD83E\uDDA9", Collections.singletonList(":flamingo:"), Collections.singletonList(":flamingo:"), Collections.singletonList(":flamingo:"), false, false, 12.0, Qualification.fromString("fully-qualified"), "flamingo", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BIRD, false);

    /**
     * 🦚
     */
    Emoji PEACOCK = new Emoji("🦚", "\uD83E\uDD9A", Collections.singletonList(":peacock:"), Collections.singletonList(":peacock:"), Collections.singletonList(":peacock:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "peacock", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BIRD, false);

    /**
     * 🦜
     */
    Emoji PARROT = new Emoji("🦜", "\uD83E\uDD9C", Collections.singletonList(":parrot:"), Collections.singletonList(":parrot:"), Collections.singletonList(":parrot:"), false, false, 11.0, Qualification.fromString("fully-qualified"), "parrot", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BIRD, false);

    /**
     * 🪽
     */
    Emoji WING = new Emoji("🪽", "\uD83E\uDEBD", Collections.singletonList(":wing:"), Collections.emptyList(), Collections.singletonList(":wing:"), false, false, 15.0, Qualification.fromString("fully-qualified"), "wing", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BIRD, false);

    /**
     * 🐦‍⬛
     */
    Emoji BLACK_BIRD = new Emoji("🐦‍⬛", "\uD83D\uDC26\u200D\u2B1B", Collections.singletonList(":black_bird:"), Collections.emptyList(), Collections.emptyList(), false, false, 15.0, Qualification.fromString("fully-qualified"), "black bird", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BIRD, false);

    /**
     * 🪿
     */
    Emoji GOOSE = new Emoji("🪿", "\uD83E\uDEBF", Collections.singletonList(":goose:"), Collections.emptyList(), Collections.singletonList(":goose:"), false, false, 15.0, Qualification.fromString("fully-qualified"), "goose", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BIRD, false);

    /**
     * 🐦‍🔥
     */
    Emoji PHOENIX = new Emoji("🐦‍🔥", "\uD83D\uDC26\u200D\uD83D\uDD25", Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), false, false, 15.1, Qualification.fromString("fully-qualified"), "phoenix", EmojiGroup.ANIMALS_AND_NATURE, EmojiSubGroup.ANIMAL_BIRD, false);
}
