/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.OfflinePlayer;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.commands.PlayerNotFoundException;
import com.earth2me.essentials.utils.DateUtil;
import java.util.logging.Level;
import org.bukkit.Server;

public class Commandmute
extends EssentialsCommand {
    public Commandmute() {
        super("mute");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        User user;
        boolean nomatch = false;
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        try {
            user = this.getPlayer(server, args, 0, true, true);
        }
        catch (PlayerNotFoundException e) {
            nomatch = true;
            user = this.ess.getUser(new OfflinePlayer(args[0], this.ess.getServer()));
        }
        if (!user.getBase().isOnline()) {
            if (sender.isPlayer() && !this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.mute.offline")) {
                throw new Exception(I18n.tl("muteExemptOffline", new Object[0]));
            }
        } else if (user.isAuthorized("essentials.mute.exempt") && sender.isPlayer()) {
            throw new Exception(I18n.tl("muteExempt", new Object[0]));
        }
        long muteTimestamp = 0L;
        if (args.length > 1) {
            String time = Commandmute.getFinalArg(args, 1);
            muteTimestamp = DateUtil.parseDateDiff(time, true);
            user.setMuted(true);
        } else {
            user.setMuted(!user.getMuted());
        }
        user.setMuteTimeout(muteTimestamp);
        boolean muted = user.getMuted();
        String muteTime = DateUtil.formatDateDiff(muteTimestamp);
        if (nomatch) {
            sender.sendMessage(I18n.tl("userUnknown", user.getName()));
        }
        if (muted) {
            if (muteTimestamp > 0L) {
                sender.sendMessage(I18n.tl("mutedPlayerFor", user.getDisplayName(), muteTime));
                user.sendMessage(I18n.tl("playerMutedFor", muteTime));
            } else {
                sender.sendMessage(I18n.tl("mutedPlayer", user.getDisplayName()));
                user.sendMessage(I18n.tl("playerMuted", new Object[0]));
            }
            String message = I18n.tl("muteNotify", sender.getSender().getName(), user.getName(), muteTime);
            server.getLogger().log(Level.INFO, message);
            this.ess.broadcastMessage("essentials.mute.notify", message);
        } else {
            sender.sendMessage(I18n.tl("unmutedPlayer", user.getDisplayName()));
            user.sendMessage(I18n.tl("playerUnmuted", new Object[0]));
        }
    }
}

