/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.ChargeException;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.Trade;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NoChargeException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.ess3.api.MaxMoneyException;
import org.bukkit.Material;
import org.bukkit.Server;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;

public class Commandcondense
extends EssentialsCommand {
    private Map<ItemStack, SimpleRecipe> condenseList = new HashMap<ItemStack, SimpleRecipe>();

    public Commandcondense() {
        super("condense");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void run(Server server, User user, String commandLabel, String[] args) throws Exception {
        List<Object> is = new ArrayList();
        boolean validateReverse = false;
        if (args.length > 0) {
            is = this.ess.getItemDb().getMatching(user, args);
        } else {
            void var9_12;
            ItemStack[] arr$ = user.getBase().getInventory().getContents();
            int len$ = arr$.length;
            boolean bl = false;
            while (var9_12 < len$) {
                ItemStack stack = arr$[var9_12];
                if (stack != null && stack.getType() != Material.AIR) {
                    is.add(stack);
                }
                ++var9_12;
            }
            validateReverse = true;
        }
        boolean didConvert = false;
        for (ItemStack itemStack : is) {
            if (!this.condenseStack(user, itemStack, validateReverse)) continue;
            didConvert = true;
        }
        user.getBase().updateInventory();
        if (!didConvert) {
            user.sendMessage(I18n.tl("itemsNotConverted", new Object[0]));
            throw new NoChargeException();
        }
        user.sendMessage(I18n.tl("itemsConverted", new Object[0]));
    }

    private boolean condenseStack(User user, ItemStack stack, boolean validateReverse) throws ChargeException, MaxMoneyException {
        SimpleRecipe condenseType = this.getCondenseType(stack);
        if (condenseType != null) {
            ItemStack input = condenseType.getInput();
            ItemStack result = condenseType.getResult();
            if (validateReverse) {
                boolean pass = false;
                for (Recipe revRecipe : this.ess.getServer().getRecipesFor(input)) {
                    if (this.getStackOnRecipeMatch(revRecipe, result) == null) continue;
                    pass = true;
                    break;
                }
                if (!pass) {
                    return false;
                }
            }
            int amount = 0;
            for (ItemStack contents : user.getBase().getInventory().getContents()) {
                if (contents == null || !contents.isSimilar(stack)) continue;
                amount += contents.getAmount();
            }
            int output = amount / input.getAmount() * result.getAmount();
            if ((amount -= amount % input.getAmount()) > 0) {
                input.setAmount(amount);
                result.setAmount(output);
                Trade remove = new Trade(input, this.ess);
                Trade add = new Trade(result, this.ess);
                remove.charge(user);
                add.pay(user, Trade.OverflowType.DROP);
                return true;
            }
        }
        return false;
    }

    private SimpleRecipe getCondenseType(ItemStack stack) {
        if (this.condenseList.containsKey(stack)) {
            return this.condenseList.get(stack);
        }
        Iterator intr = this.ess.getServer().recipeIterator();
        while (intr.hasNext()) {
            Recipe recipe = (Recipe)intr.next();
            Collection<ItemStack> recipeItems = this.getStackOnRecipeMatch(recipe, stack);
            if (recipeItems == null || recipeItems.size() != 4 && recipeItems.size() != 9 || recipeItems.size() <= recipe.getResult().getAmount()) continue;
            ItemStack input = stack.clone();
            input.setAmount(recipeItems.size());
            SimpleRecipe newRecipe = new SimpleRecipe(recipe.getResult(), input);
            this.condenseList.put(stack, newRecipe);
            return newRecipe;
        }
        this.condenseList.put(stack, null);
        return null;
    }

    private Collection<ItemStack> getStackOnRecipeMatch(Recipe recipe, ItemStack stack) {
        List inputList;
        if (recipe instanceof ShapedRecipe) {
            ShapedRecipe sRecipe = (ShapedRecipe)recipe;
            inputList = sRecipe.getIngredientMap().values();
        } else if (recipe instanceof ShapelessRecipe) {
            ShapelessRecipe slRecipe = (ShapelessRecipe)recipe;
            inputList = slRecipe.getIngredientList();
        } else {
            return null;
        }
        boolean match = true;
        Iterator iter = inputList.iterator();
        while (iter.hasNext()) {
            ItemStack inputSlot = (ItemStack)iter.next();
            if (inputSlot == null) {
                iter.remove();
                continue;
            }
            if (inputSlot.getDurability() == Short.MAX_VALUE) {
                inputSlot.setDurability((short)0);
            }
            if (inputSlot.isSimilar(stack)) continue;
            match = false;
        }
        if (match) {
            return inputList;
        }
        return null;
    }

    private class SimpleRecipe
    implements Recipe {
        private ItemStack result;
        private ItemStack input;

        private SimpleRecipe(ItemStack result, ItemStack input) {
            this.result = result;
            this.input = input;
        }

        public ItemStack getResult() {
            return this.result.clone();
        }

        public ItemStack getInput() {
            return this.input.clone();
        }
    }
}

