/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.craftbukkit.SetExpFix;
import com.earth2me.essentials.utils.DateUtil;
import com.earth2me.essentials.utils.NumberUtil;
import java.util.Locale;
import org.bukkit.Server;

public class Commandwhois
extends EssentialsCommand {
    public Commandwhois() {
        super("whois");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        User user = this.getPlayer(server, sender, args, 0);
        sender.sendMessage(I18n._("whoisTop", user.getName()));
        user.setDisplayNick();
        sender.sendMessage(I18n._("whoisNick", user.getDisplayName()));
        sender.sendMessage(I18n._("whoisHealth", user.getHealth()));
        sender.sendMessage(I18n._("whoisHunger", user.getFoodLevel(), Float.valueOf(user.getSaturation())));
        sender.sendMessage(I18n._("whoisExp", SetExpFix.getTotalExperience(user.getBase()), user.getLevel()));
        sender.sendMessage(I18n._("whoisLocation", user.getLocation().getWorld().getName(), user.getLocation().getBlockX(), user.getLocation().getBlockY(), user.getLocation().getBlockZ()));
        if (!this.ess.getSettings().isEcoDisabled()) {
            sender.sendMessage(I18n._("whoisMoney", NumberUtil.displayCurrency(user.getMoney(), this.ess)));
        }
        sender.sendMessage(I18n._("whoisIPAddress", user.getAddress().getAddress().toString()));
        String location = user.getGeoLocation();
        if (location != null && (!sender.isPlayer() || this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.geoip.show"))) {
            sender.sendMessage(I18n._("whoisGeoLocation", location));
        }
        sender.sendMessage(I18n._("whoisGamemode", I18n._(user.getGameMode().toString().toLowerCase(Locale.ENGLISH), new Object[0])));
        sender.sendMessage(I18n._("whoisGod", user.isGodModeEnabled() ? I18n._("true", new Object[0]) : I18n._("false", new Object[0])));
        sender.sendMessage(I18n._("whoisOp", user.isOp() ? I18n._("true", new Object[0]) : I18n._("false", new Object[0])));
        sender.sendMessage(I18n._("whoisFly", user.getAllowFlight() ? I18n._("true", new Object[0]) : I18n._("false", new Object[0]), user.isFlying() ? I18n._("flying", new Object[0]) : I18n._("notFlying", new Object[0])));
        sender.sendMessage(I18n._("whoisAFK", user.isAfk() ? I18n._("true", new Object[0]) : I18n._("false", new Object[0])));
        Object[] objectArray = new Object[1];
        objectArray[0] = user.isJailed() ? (user.getJailTimeout() > 0L ? DateUtil.formatDateDiff(user.getJailTimeout()) : I18n._("true", new Object[0])) : I18n._("false", new Object[0]);
        sender.sendMessage(I18n._("whoisJail", objectArray));
        Object[] objectArray2 = new Object[1];
        objectArray2[0] = user.isMuted() ? (user.getMuteTimeout() > 0L ? DateUtil.formatDateDiff(user.getMuteTimeout()) : I18n._("true", new Object[0])) : I18n._("false", new Object[0]);
        sender.sendMessage(I18n._("whoisMuted", objectArray2));
    }
}

