/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials.commands;

import com.earth2me.essentials.CommandSource;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.User;
import com.earth2me.essentials.commands.EssentialsCommand;
import com.earth2me.essentials.commands.NotEnoughArgumentsException;
import com.earth2me.essentials.craftbukkit.SetExpFix;
import com.earth2me.essentials.utils.DateUtil;
import com.earth2me.essentials.utils.NumberUtil;
import java.util.Locale;
import org.bukkit.Server;

public class Commandwhois
extends EssentialsCommand {
    public Commandwhois() {
        super("whois");
    }

    @Override
    public void run(Server server, CommandSource sender, String commandLabel, String[] args) throws Exception {
        if (args.length < 1) {
            throw new NotEnoughArgumentsException();
        }
        User user = this.getPlayer(server, sender, args, 0);
        sender.sendMessage(I18n.tl("whoisTop", user.getName()));
        user.setDisplayNick();
        sender.sendMessage(I18n.tl("whoisNick", user.getDisplayName()));
        sender.sendMessage(I18n.tl("whoisHealth", user.getBase().getHealth()));
        sender.sendMessage(I18n.tl("whoisHunger", user.getBase().getFoodLevel(), Float.valueOf(user.getBase().getSaturation())));
        sender.sendMessage(I18n.tl("whoisExp", SetExpFix.getTotalExperience(user.getBase()), user.getBase().getLevel()));
        sender.sendMessage(I18n.tl("whoisLocation", user.getLocation().getWorld().getName(), user.getLocation().getBlockX(), user.getLocation().getBlockY(), user.getLocation().getBlockZ()));
        if (!this.ess.getSettings().isEcoDisabled()) {
            sender.sendMessage(I18n.tl("whoisMoney", NumberUtil.displayCurrency(user.getMoney(), this.ess)));
        }
        sender.sendMessage(I18n.tl("whoisIPAddress", user.getBase().getAddress().getAddress().toString()));
        String location = user.getGeoLocation();
        if (location != null && (!sender.isPlayer() || this.ess.getUser(sender.getPlayer()).isAuthorized("essentials.geoip.show"))) {
            sender.sendMessage(I18n.tl("whoisGeoLocation", location));
        }
        sender.sendMessage(I18n.tl("whoisGamemode", I18n.tl(user.getBase().getGameMode().toString().toLowerCase(Locale.ENGLISH), new Object[0])));
        sender.sendMessage(I18n.tl("whoisGod", user.isGodModeEnabled() ? I18n.tl("true", new Object[0]) : I18n.tl("false", new Object[0])));
        sender.sendMessage(I18n.tl("whoisOp", user.getBase().isOp() ? I18n.tl("true", new Object[0]) : I18n.tl("false", new Object[0])));
        sender.sendMessage(I18n.tl("whoisFly", user.getBase().getAllowFlight() ? I18n.tl("true", new Object[0]) : I18n.tl("false", new Object[0]), user.getBase().isFlying() ? I18n.tl("flying", new Object[0]) : I18n.tl("notFlying", new Object[0])));
        sender.sendMessage(I18n.tl("whoisAFK", user.isAfk() ? I18n.tl("true", new Object[0]) : I18n.tl("false", new Object[0])));
        Object[] objectArray = new Object[1];
        objectArray[0] = user.isJailed() ? (user.getJailTimeout() > 0L ? DateUtil.formatDateDiff(user.getJailTimeout()) : I18n.tl("true", new Object[0])) : I18n.tl("false", new Object[0]);
        sender.sendMessage(I18n.tl("whoisJail", objectArray));
        Object[] objectArray2 = new Object[1];
        objectArray2[0] = user.isMuted() ? (user.getMuteTimeout() > 0L ? DateUtil.formatDateDiff(user.getMuteTimeout()) : I18n.tl("true", new Object[0])) : I18n.tl("false", new Object[0]);
        sender.sendMessage(I18n.tl("whoisMuted", objectArray2));
    }
}

