/*
 * Decompiled with CFR 0.152.
 */
package com.earth2me.essentials;

import com.earth2me.essentials.EssentialsConf;
import com.earth2me.essentials.EssentialsUserConf;
import com.earth2me.essentials.I18n;
import com.earth2me.essentials.ManagedFile;
import com.earth2me.essentials.craftbukkit.FakeWorld;
import com.earth2me.essentials.settings.Jails;
import com.earth2me.essentials.settings.Spawns;
import com.earth2me.essentials.storage.YamlStorageWriter;
import com.earth2me.essentials.utils.StringUtil;
import com.google.common.base.Charsets;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.ess3.api.IEssentials;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;

public class EssentialsUpgrade {
    private static final Logger LOGGER = Logger.getLogger("Essentials");
    private final transient IEssentials ess;
    private final transient EssentialsConf doneFile;

    EssentialsUpgrade(IEssentials essentials) {
        this.ess = essentials;
        if (!this.ess.getDataFolder().exists()) {
            this.ess.getDataFolder().mkdirs();
        }
        this.doneFile = new EssentialsConf(new File(this.ess.getDataFolder(), "upgrades-done.yml"));
        this.doneFile.load();
    }

    private void moveMotdRulesToFile(String name) {
        if (this.doneFile.getBoolean("move" + name + "ToFile", false)) {
            return;
        }
        try {
            File file = new File(this.ess.getDataFolder(), name + ".txt");
            if (file.exists()) {
                return;
            }
            File configFile = new File(this.ess.getDataFolder(), "config.yml");
            if (!configFile.exists()) {
                return;
            }
            EssentialsConf conf = new EssentialsConf(configFile);
            conf.load();
            List<String> lines = conf.getStringList(name);
            if (lines != null && !lines.isEmpty()) {
                if (!file.createNewFile()) {
                    throw new IOException("Failed to create file " + file);
                }
                PrintWriter writer = new PrintWriter(file);
                for (String line : lines) {
                    writer.println(line);
                }
                writer.close();
            }
            this.doneFile.setProperty("move" + name + "ToFile", true);
            this.doneFile.save();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, I18n.tl("upgradingFilesError", new Object[0]), e);
        }
    }

    private void removeLinesFromConfig(File file, String regex, String info) throws Exception {
        String line;
        boolean needUpdate = false;
        BufferedReader bReader = new BufferedReader(new FileReader(file));
        File tempFile = File.createTempFile("essentialsupgrade", ".tmp.yml", this.ess.getDataFolder());
        BufferedWriter bWriter = new BufferedWriter(new FileWriter(tempFile));
        while ((line = bReader.readLine()) != null) {
            if (line.matches(regex)) {
                if (!needUpdate && info != null) {
                    bWriter.write(info, 0, info.length());
                    bWriter.newLine();
                }
                needUpdate = true;
                continue;
            }
            if (line.endsWith("\r\n")) {
                bWriter.write(line, 0, line.length() - 2);
            } else if (line.endsWith("\r") || line.endsWith("\n")) {
                bWriter.write(line, 0, line.length() - 1);
            } else {
                bWriter.write(line, 0, line.length());
            }
            bWriter.newLine();
        }
        bReader.close();
        bWriter.close();
        if (needUpdate) {
            if (!file.renameTo(new File(file.getParentFile(), file.getName().concat("." + System.currentTimeMillis() + ".upgradebackup")))) {
                throw new Exception(I18n.tl("configFileMoveError", new Object[0]));
            }
            if (!tempFile.renameTo(file)) {
                throw new Exception(I18n.tl("configFileRenameError", new Object[0]));
            }
        } else {
            tempFile.delete();
        }
    }

    private void updateUsersPowerToolsFormat() {
        File[] userFiles;
        if (this.doneFile.getBoolean("updateUsersPowerToolsFormat", false)) {
            return;
        }
        File userdataFolder = new File(this.ess.getDataFolder(), "userdata");
        if (!userdataFolder.exists() || !userdataFolder.isDirectory()) {
            return;
        }
        for (File file : userFiles = userdataFolder.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".yml")) continue;
            EssentialsConf config = new EssentialsConf(file);
            try {
                Map powertools;
                config.load();
                if (!config.hasProperty("powertools") || (powertools = config.getConfigurationSection("powertools").getValues(false)) == null) continue;
                for (Map.Entry entry : powertools.entrySet()) {
                    if (!(entry.getValue() instanceof String)) continue;
                    ArrayList<String> temp = new ArrayList<String>();
                    temp.add((String)entry.getValue());
                    powertools.put(entry.getKey(), temp);
                }
                config.forceSave();
            }
            catch (RuntimeException ex) {
                LOGGER.log(Level.INFO, "File: " + file.toString());
                throw ex;
            }
        }
        this.doneFile.setProperty("updateUsersPowerToolsFormat", true);
        this.doneFile.save();
    }

    private void updateUsersHomesFormat() {
        File[] userFiles;
        if (this.doneFile.getBoolean("updateUsersHomesFormat", false)) {
            return;
        }
        File userdataFolder = new File(this.ess.getDataFolder(), "userdata");
        if (!userdataFolder.exists() || !userdataFolder.isDirectory()) {
            return;
        }
        for (File file : userFiles = userdataFolder.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".yml")) continue;
            EssentialsConf config = new EssentialsConf(file);
            try {
                Set worlds;
                config.load();
                if (!config.hasProperty("home") || !config.hasProperty("home.default")) continue;
                String defworld = (String)config.getProperty("home.default");
                Location defloc = this.getFakeLocation(config, "home.worlds." + defworld);
                if (defloc != null) {
                    config.setProperty("homes.home", defloc);
                }
                if ((worlds = config.getConfigurationSection("home.worlds").getKeys(false)) == null) continue;
                for (String world : worlds) {
                    String worldName;
                    Location loc;
                    if (defworld.equalsIgnoreCase(world) || (loc = this.getFakeLocation(config, "home.worlds." + world)) == null || (worldName = loc.getWorld().getName().toLowerCase(Locale.ENGLISH)) == null || worldName.isEmpty()) continue;
                    config.setProperty("homes." + worldName, loc);
                }
                config.removeProperty("home");
                config.forceSave();
            }
            catch (RuntimeException ex) {
                LOGGER.log(Level.INFO, "File: " + file.toString());
                throw ex;
            }
        }
        this.doneFile.setProperty("updateUsersHomesFormat", true);
        this.doneFile.save();
    }

    private void sanitizeAllUserFilenames() {
        File[] listOfFiles;
        if (this.doneFile.getBoolean("sanitizeAllUserFilenames", false)) {
            return;
        }
        File usersFolder = new File(this.ess.getDataFolder(), "userdata");
        if (!usersFolder.exists()) {
            return;
        }
        for (File listOfFile : listOfFiles = usersFolder.listFiles()) {
            String sanitizedFilename;
            String filename = listOfFile.getName();
            if (!listOfFile.isFile() || !filename.endsWith(".yml") || (sanitizedFilename = StringUtil.sanitizeFileName(filename.substring(0, filename.length() - 4)) + ".yml").equals(filename)) continue;
            File tmpFile = new File(listOfFile.getParentFile(), sanitizedFilename + ".tmp");
            File newFile = new File(listOfFile.getParentFile(), sanitizedFilename);
            if (!listOfFile.renameTo(tmpFile)) {
                LOGGER.log(Level.WARNING, I18n.tl("userdataMoveError", filename, sanitizedFilename));
                continue;
            }
            if (newFile.exists()) {
                LOGGER.log(Level.WARNING, I18n.tl("duplicatedUserdata", filename, sanitizedFilename));
                continue;
            }
            if (tmpFile.renameTo(newFile)) continue;
            LOGGER.log(Level.WARNING, I18n.tl("userdataMoveBackError", sanitizedFilename, sanitizedFilename));
        }
        this.doneFile.setProperty("sanitizeAllUserFilenames", true);
        this.doneFile.save();
    }

    private World getFakeWorld(String name) {
        File bukkitDirectory = this.ess.getDataFolder().getParentFile().getParentFile();
        File worldDirectory = new File(bukkitDirectory, name);
        if (worldDirectory.exists() && worldDirectory.isDirectory()) {
            return new FakeWorld(worldDirectory.getName(), World.Environment.NORMAL);
        }
        return null;
    }

    public Location getFakeLocation(EssentialsConf config, String path) {
        String worldName = config.getString((path != null ? path + "." : "") + "world");
        if (worldName == null || worldName.isEmpty()) {
            return null;
        }
        World world = this.getFakeWorld(worldName);
        if (world == null) {
            return null;
        }
        return new Location(world, config.getDouble((path != null ? path + "." : "") + "x", 0.0), config.getDouble((path != null ? path + "." : "") + "y", 0.0), config.getDouble((path != null ? path + "." : "") + "z", 0.0), (float)config.getDouble((path != null ? path + "." : "") + "yaw", 0.0), (float)config.getDouble((path != null ? path + "." : "") + "pitch", 0.0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteOldItemsCsv() {
        if (this.doneFile.getBoolean("deleteOldItemsCsv", false)) {
            return;
        }
        File file = new File(this.ess.getDataFolder(), "items.csv");
        if (file.exists()) {
            try {
                HashSet<BigInteger> oldconfigs = new HashSet<BigInteger>();
                oldconfigs.add(new BigInteger("66ec40b09ac167079f558d1099e39f10", 16));
                oldconfigs.add(new BigInteger("34284de1ead43b0bee2aae85e75c041d", 16));
                oldconfigs.add(new BigInteger("c33bc9b8ee003861611bbc2f48eb6f4f", 16));
                oldconfigs.add(new BigInteger("6ff17925430735129fc2a02f830c1daa", 16));
                MessageDigest digest = ManagedFile.getDigest();
                BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
                DigestInputStream dis = new DigestInputStream(bis, digest);
                byte[] buffer = new byte[1024];
                try {
                    while (dis.read(buffer) != -1) {
                    }
                }
                finally {
                    dis.close();
                }
                BigInteger hash = new BigInteger(1, digest.digest());
                if (oldconfigs.contains(hash) && !file.delete()) {
                    throw new IOException("Could not delete file " + file.toString());
                }
                this.doneFile.setProperty("deleteOldItemsCsv", true);
                this.doneFile.save();
            }
            catch (IOException ex) {
                Bukkit.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSpawnsToNewSpawnsConfig() {
        block9: {
            if (this.doneFile.getBoolean("updateSpawnsToNewSpawnsConfig", false)) {
                return;
            }
            File configFile = new File(this.ess.getDataFolder(), "spawn.yml");
            if (configFile.exists()) {
                EssentialsConf config = new EssentialsConf(configFile);
                try {
                    config.load();
                    if (config.hasProperty("spawns")) break block9;
                    Spawns spawns = new Spawns();
                    Set<String> keys = config.getKeys(false);
                    for (String group : keys) {
                        Location loc = this.getFakeLocation(config, group);
                        spawns.getSpawns().put(group.toLowerCase(Locale.ENGLISH), loc);
                    }
                    if (!configFile.renameTo(new File(this.ess.getDataFolder(), "spawn.yml.old"))) {
                        throw new Exception(I18n.tl("fileRenameError", "spawn.yml"));
                    }
                    PrintWriter writer = new PrintWriter(configFile);
                    try {
                        new YamlStorageWriter(writer).save(spawns);
                    }
                    finally {
                        writer.close();
                    }
                }
                catch (Exception ex) {
                    Bukkit.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
        this.doneFile.setProperty("updateSpawnsToNewSpawnsConfig", true);
        this.doneFile.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateJailsToNewJailsConfig() {
        block9: {
            if (this.doneFile.getBoolean("updateJailsToNewJailsConfig", false)) {
                return;
            }
            File configFile = new File(this.ess.getDataFolder(), "jail.yml");
            if (configFile.exists()) {
                EssentialsConf config = new EssentialsConf(configFile);
                try {
                    config.load();
                    if (config.hasProperty("jails")) break block9;
                    Jails jails = new Jails();
                    Set<String> keys = config.getKeys(false);
                    for (String jailName : keys) {
                        Location loc = this.getFakeLocation(config, jailName);
                        jails.getJails().put(jailName.toLowerCase(Locale.ENGLISH), loc);
                    }
                    if (!configFile.renameTo(new File(this.ess.getDataFolder(), "jail.yml.old"))) {
                        throw new Exception(I18n.tl("fileRenameError", "jail.yml"));
                    }
                    PrintWriter writer = new PrintWriter(configFile);
                    try {
                        new YamlStorageWriter(writer).save(jails);
                    }
                    finally {
                        writer.close();
                    }
                }
                catch (Exception ex) {
                    Bukkit.getLogger().log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
        }
        this.doneFile.setProperty("updateJailsToNewJailsConfig", true);
        this.doneFile.save();
    }

    private void warnMetrics() {
        if (this.doneFile.getBoolean("warnMetrics", false)) {
            return;
        }
        this.ess.getSettings().setMetricsEnabled(false);
        this.doneFile.setProperty("warnMetrics", true);
        this.doneFile.save();
    }

    private void uuidFileChange() {
        if (this.doneFile.getBoolean("uuidFileChange", false)) {
            return;
        }
        Boolean ignoreUFCache = this.doneFile.getBoolean("ignore-userfiles-cache", false);
        File userdir = new File(this.ess.getDataFolder(), "userdata");
        if (!userdir.exists()) {
            return;
        }
        int countFiles = 0;
        int countReqFiles = 0;
        for (String string : userdir.list()) {
            if (!string.endsWith(".yml") || string.length() < 5) continue;
            ++countFiles;
            String name = string.substring(0, string.length() - 4);
            UUID uuid = null;
            try {
                uuid = UUID.fromString(name);
            }
            catch (IllegalArgumentException ex) {
                ++countReqFiles;
            }
            if (countFiles > 100) break;
        }
        if (countReqFiles < 1) {
            return;
        }
        this.ess.getLogger().info("#### Starting Essentials UUID userdata conversion in a few seconds. ####");
        this.ess.getLogger().info("We recommend you take a backup of your server before upgrading from the old username system.");
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        EssentialsUpgrade.uuidFileConvert(this.ess, ignoreUFCache);
        this.doneFile.setProperty("uuidFileChange", true);
        this.doneFile.save();
    }

    public static void uuidFileConvert(IEssentials ess, Boolean ignoreUFCache) {
        ess.getLogger().info("Starting Essentials UUID userdata conversion");
        File userdir = new File(ess.getDataFolder(), "userdata");
        if (!userdir.exists()) {
            return;
        }
        int countFiles = 0;
        int countFails = 0;
        int countEssCache = 0;
        int countBukkit = 0;
        ess.getLogger().info("Found " + userdir.list().length + " files to convert...");
        for (String string : userdir.list()) {
            if (!string.endsWith(".yml") || string.length() < 5) continue;
            int showProgress = countFiles % 250;
            if (showProgress == 0) {
                ess.getUserMap().getUUIDMap().forceWriteUUIDMap();
                ess.getLogger().info("Converted " + countFiles + "/" + userdir.list().length);
            }
            ++countFiles;
            String name = string.substring(0, string.length() - 4);
            UUID uuid = null;
            try {
                uuid = UUID.fromString(name);
            }
            catch (IllegalArgumentException ex) {
                File file = new File(userdir, string);
                EssentialsConf conf = new EssentialsConf(file);
                conf.load();
                conf.setProperty("lastAccountName", name);
                conf.save();
                String uuidConf = ignoreUFCache != false ? "force-uuid" : "uuid";
                String uuidString = conf.getString(uuidConf, null);
                for (int i = 0; i < 4; ++i) {
                    try {
                        uuid = UUID.fromString(uuidString);
                        ++countEssCache;
                        break;
                    }
                    catch (Exception ex2) {
                        if (conf.getBoolean("npc", false)) {
                            uuid = UUID.nameUUIDFromBytes(("NPC:" + name).getBytes(Charsets.UTF_8));
                            break;
                        }
                        OfflinePlayer player = ess.getServer().getOfflinePlayer(name);
                        uuid = player.getUniqueId();
                        if (uuid == null) continue;
                        ++countBukkit;
                        break;
                    }
                }
                if (uuid != null) {
                    conf.forceSave();
                    EssentialsUserConf config = new EssentialsUserConf(name, uuid, new File(userdir, uuid + ".yml"));
                    config.convertLegacyFile();
                    ess.getUserMap().trackUUID(uuid, name);
                    continue;
                }
                ++countFails;
            }
        }
        ess.getUserMap().getUUIDMap().forceWriteUUIDMap();
        ess.getLogger().info("Converted " + countFiles + "/" + countFiles + ".  Conversion complete.");
        ess.getLogger().info("Converted via cache: " + countEssCache + " :: Converted via lookup: " + countBukkit + " :: Failed to convert: " + countFails);
        ess.getLogger().info("To rerun the conversion type /essentials uuidconvert");
    }

    public void beforeSettings() {
        if (!this.ess.getDataFolder().exists()) {
            this.ess.getDataFolder().mkdirs();
        }
        this.moveMotdRulesToFile("motd");
        this.moveMotdRulesToFile("rules");
    }

    public void afterSettings() {
        this.sanitizeAllUserFilenames();
        this.updateUsersPowerToolsFormat();
        this.updateUsersHomesFormat();
        this.deleteOldItemsCsv();
        this.updateSpawnsToNewSpawnsConfig();
        this.updateJailsToNewJailsConfig();
        this.uuidFileChange();
        this.warnMetrics();
    }
}

