/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.serializer.language.writer;

import java.io.BufferedWriter;
import java.lang.reflect.Field;
import javax.annotation.Nullable;
import net.elytrium.serializer.SerializerConfig;
import net.elytrium.serializer.annotations.Comment;
import net.elytrium.serializer.language.writer.YamlWriter;

public class JsonWriter
extends YamlWriter {
    private String singleIndent = "  ";
    private String currentIndent = "";

    public JsonWriter(BufferedWriter writer, SerializerConfig config) {
        super(config, writer);
    }

    public JsonWriter(BufferedWriter writer) {
        super(writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeCommentStart(@Nullable Field owner, Comment.At at) {
        JsonWriter jsonWriter = this;
        synchronized (jsonWriter) {
            if (at != Comment.At.SAME_LINE) {
                this.writeIndent();
            }
            this.writeRaw("//");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeCommentEnd(@Nullable Field owner, Comment.At at) {
        JsonWriter jsonWriter = this;
        synchronized (jsonWriter) {
            if (at != Comment.At.SAME_LINE) {
                this.writeLine();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeNodeName(@Nullable Field owner, String nodeName) {
        JsonWriter jsonWriter = this;
        synchronized (jsonWriter) {
            this.writeIndent();
            this.writeRaw('\"');
            this.writeRaw(nodeName);
            this.writeRaw("\": ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBeginMap(@Nullable Field owner) {
        JsonWriter jsonWriter = this;
        synchronized (jsonWriter) {
            this.addIndent();
            this.writeRaw('{');
            this.writeLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeMapPreCommentEntryJoin(@Nullable Field owner) {
        JsonWriter jsonWriter = this;
        synchronized (jsonWriter) {
            this.writeRaw(',');
        }
    }

    @Override
    public void writeMapPostCommentEntryJoin(@Nullable Field owner) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeMapEntryEnd(@Nullable Field owner) {
        JsonWriter jsonWriter = this;
        synchronized (jsonWriter) {
            this.writeLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeEndMap(@Nullable Field owner) {
        JsonWriter jsonWriter = this;
        synchronized (jsonWriter) {
            this.removeIndent();
            this.writeIndent();
            this.writeRaw('}');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBeginCollection(@Nullable Field owner) {
        JsonWriter jsonWriter = this;
        synchronized (jsonWriter) {
            this.addIndent();
            this.writeRaw('[');
            this.writeLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeCollectionEntry(@Nullable Field owner, Object entry) {
        JsonWriter jsonWriter = this;
        synchronized (jsonWriter) {
            this.writeIndent();
            this.writeNode(entry, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeCollectionEntryJoin(@Nullable Field owner) {
        JsonWriter jsonWriter = this;
        synchronized (jsonWriter) {
            this.writeRaw(',');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeCollectionEntryEnd(@Nullable Field owner) {
        JsonWriter jsonWriter = this;
        synchronized (jsonWriter) {
            this.writeLine();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeEndCollection(@Nullable Field owner) {
        JsonWriter jsonWriter = this;
        synchronized (jsonWriter) {
            this.removeIndent();
            this.writeIndent();
            this.writeRaw(']');
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeLine() {
        JsonWriter jsonWriter = this;
        synchronized (jsonWriter) {
            super.writeRaw(this.config.getLineSeparator());
        }
    }

    @Override
    public void setSingleIndent(String singleIndent) {
        this.singleIndent = singleIndent;
    }

    private void writeIndent() {
        this.writeRaw(this.currentIndent);
    }

    private void addIndent() {
        this.currentIndent = this.currentIndent + this.singleIndent;
    }

    private void removeIndent() {
        this.currentIndent = this.currentIndent.substring(this.singleIndent.length());
    }
}

