/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.serializer;

import java.util.Locale;
import java.util.function.Function;

public enum NameStyle {
    KEBAB_CASE(value -> value.replace("_", "-").toLowerCase(Locale.ROOT), value -> value.replace("-", "_").toUpperCase(Locale.ROOT)),
    CAMEL_CASE(value -> NameStyle.toCamelCase(value, false), value -> {
        StringBuilder result = new StringBuilder();
        char previous = '\u0000';
        for (char character : value.toCharArray()) {
            if (Character.isUpperCase(character) && Character.isLowerCase(previous) || Character.isAlphabetic(character) && Character.isDigit(previous) || Character.isDigit(character) && Character.isAlphabetic(previous)) {
                result.append('_');
            }
            result.append(Character.toUpperCase(character));
            previous = character;
        }
        return result.toString();
    }),
    CAPITAL_CAMEL_CASE(value -> NameStyle.toCamelCase(value, true), NameStyle.CAMEL_CASE.toMacroCase),
    SNAKE_CASE(value -> value.toLowerCase(Locale.ROOT), value -> value.toUpperCase(Locale.ROOT)),
    MACRO_CASE(value -> value, value -> value),
    COBOL_CASE(value -> value.replace("_", "-"), value -> value.replace("-", "_"));

    private final Function<String, String> fromMacroCase;
    private final Function<String, String> toMacroCase;

    private NameStyle(Function<String, String> fromMacroCase, Function<String, String> toMacroCase) {
        this.fromMacroCase = fromMacroCase;
        this.toMacroCase = toMacroCase;
    }

    public String fromMacroCase(String fieldName) {
        return this.fromMacroCase.apply(fieldName);
    }

    public String toMacroCase(String fieldName) {
        return this.toMacroCase.apply(fieldName);
    }

    private static String toCamelCase(String value, boolean nextCharUppercase) {
        StringBuilder result = new StringBuilder();
        for (char character : value.toCharArray()) {
            if (character == '_') {
                nextCharUppercase = true;
                continue;
            }
            result.append(nextCharUppercase ? character : Character.toLowerCase(character));
            nextCharUppercase = false;
        }
        return result.toString();
    }
}

