/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.serializer.placeholders;

import net.elytrium.serializer.placeholders.PlaceholderReplacer;

public class DefaultPlaceholderReplacer
implements PlaceholderReplacer<String, String> {
    public String replace(String value, String[] placeholders, Object ... values) {
        String string;
        switch (placeholders.length) {
            case 0: {
                string = value;
                break;
            }
            case 1: {
                if (values.length == 0 || value.isEmpty()) {
                    string = value;
                    break;
                }
                string = value.replace(placeholders[0], String.valueOf(values[0]));
                break;
            }
            default: {
                string = DefaultPlaceholderReplacer.replaceEach(value, placeholders, values);
            }
        }
        return string;
    }

    private static String replaceEach(String text, String[] searchList, Object[] replacementList) {
        int tempIndex;
        int searchLength = searchList.length;
        int replacementLength = replacementList.length;
        if (searchLength != replacementLength) {
            throw new IllegalArgumentException("Search and Replace array lengths don't match: " + searchLength + " vs " + replacementLength);
        }
        boolean[] noMoreMatchesForReplIndex = new boolean[searchLength];
        int textIndex = -1;
        int replaceIndex = -1;
        for (int i = 0; i < searchLength; ++i) {
            if (noMoreMatchesForReplIndex[i]) continue;
            tempIndex = text.indexOf(searchList[i]);
            if (tempIndex == -1) {
                noMoreMatchesForReplIndex[i] = true;
                continue;
            }
            if (textIndex != -1 && tempIndex >= textIndex) continue;
            textIndex = tempIndex;
            replaceIndex = i;
        }
        if (textIndex == -1) {
            return text;
        }
        int start = 0;
        int increase = 0;
        for (int i = 0; i < searchList.length; ++i) {
            int greater;
            if (!(replacementList[i] instanceof String)) {
                replacementList[i] = String.valueOf(replacementList[i]);
            }
            if ((greater = ((String)replacementList[i]).length() - searchList[i].length()) <= 0) continue;
            increase += 3 * greater;
        }
        increase = Math.min(increase, text.length() / 5);
        StringBuilder buf = new StringBuilder(text.length() + increase);
        while (textIndex != -1) {
            int i;
            for (i = start; i < textIndex; ++i) {
                buf.append(text.charAt(i));
            }
            buf.append((String)replacementList[replaceIndex]);
            start = textIndex + searchList[replaceIndex].length();
            textIndex = -1;
            replaceIndex = -1;
            for (i = 0; i < searchLength; ++i) {
                if (noMoreMatchesForReplIndex[i]) continue;
                tempIndex = text.indexOf(searchList[i], start);
                if (tempIndex == -1) {
                    noMoreMatchesForReplIndex[i] = true;
                    continue;
                }
                if (textIndex != -1 && tempIndex >= textIndex) continue;
                textIndex = tempIndex;
                replaceIndex = i;
            }
        }
        int textLength = text.length();
        for (int i = start; i < textLength; ++i) {
            buf.append(text.charAt(i));
        }
        return buf.toString();
    }
}

