/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.serializer.language.reader;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import net.elytrium.serializer.SerializerConfig;
import net.elytrium.serializer.annotations.CollectionType;
import net.elytrium.serializer.annotations.MapType;
import net.elytrium.serializer.annotations.Serializer;
import net.elytrium.serializer.custom.ClassSerializer;
import net.elytrium.serializer.exceptions.ReflectionException;
import net.elytrium.serializer.exceptions.SerializableReadException;
import net.elytrium.serializer.utils.GenericUtils;

public abstract class AbstractReader {
    private static final Logger LOGGER = Logger.getLogger(AbstractReader.class.getName());
    protected static final char NEW_LINE = '\n';
    private final char[] singleCharBuffer = new char[1];
    private final Queue<Character> seekBuffer = new ArrayDeque<Character>();
    protected final SerializerConfig config;
    protected final BufferedReader reader;
    private boolean reuseBuffer;
    private boolean seekEnabled;
    private CarriageType carriageType = CarriageType.UNKNOWN;
    private boolean backupPreferred;

    public AbstractReader(SerializerConfig config, BufferedReader reader) {
        this.config = config;
        this.reader = reader;
    }

    public AbstractReader(BufferedReader reader) {
        this.config = SerializerConfig.DEFAULT;
        this.reader = reader;
    }

    public void readSerializableObject(Object holder, Class<?> clazz) {
        this.readSerializableObject(null, holder, clazz);
    }

    public abstract void readSerializableObject(@Nullable Field var1, Object var2, Class<?> var3);

    public String readNodeName() {
        return this.readNodeName(null);
    }

    public abstract String readNodeName(@Nullable Field var1);

    public void readBeginSerializableObject() {
        this.readBeginSerializableObject(null);
    }

    public abstract void readBeginSerializableObject(@Nullable Field var1);

    public void readSerializableObjectEntryJoin() {
        this.readSerializableObjectEntryJoin(null);
    }

    public abstract void readSerializableObjectEntryJoin(@Nullable Field var1);

    public boolean readEndSerializableObject() {
        return this.readEndSerializableObject(null);
    }

    public abstract boolean readEndSerializableObject(@Nullable Field var1);

    public Object readNode(Object holder, Field node) {
        AbstractReader abstractReader = this;
        synchronized (abstractReader) {
            ArrayDeque serializerStack = new ArrayDeque(Math.min(16, this.config.getRegisteredSerializers() + 1));
            Class<Object> type = node.getGenericType();
            Class<Object> clazz = node.getType();
            Serializer serializer = node.getAnnotation(Serializer.class);
            if (serializer == null) {
                serializer = node.getType().getAnnotation(Serializer.class);
            }
            if (serializer != null) {
                try {
                    ClassSerializer classSerializer = this.config.getAndCacheSerializer(serializer);
                    if (clazz.isAssignableFrom(classSerializer.getToType())) {
                        serializerStack.add(classSerializer);
                        type = classSerializer.getFromType();
                        clazz = classSerializer.getFromType();
                    }
                }
                catch (ReflectiveOperationException e) {
                    throw new ReflectionException(e);
                }
            }
            clazz = this.fillSerializerStack(serializerStack, clazz);
            if (!serializerStack.isEmpty()) {
                type = clazz;
            }
            try {
                Object value = this.readAndDeserializeByType(node, node.get(holder), type, serializerStack);
                if (type == Integer.class || type == Integer.TYPE) {
                    node.setInt(holder, ((Long)value).intValue());
                } else if (type == Short.class || type == Short.TYPE) {
                    node.setShort(holder, ((Long)value).shortValue());
                } else if (type == Byte.class || type == Byte.TYPE) {
                    node.setByte(holder, ((Long)value).byteValue());
                } else if (type == Float.class || type == Float.TYPE) {
                    node.setFloat(holder, ((Double)value).floatValue());
                } else {
                    node.set(holder, value);
                }
                return value;
            }
            catch (IllegalAccessException e) {
                throw new ReflectionException(e);
            }
        }
    }

    protected Class<?> fillSerializerStack(Deque<ClassSerializer<?, Object>> serializerStack, Class<?> clazz) {
        ClassSerializer classSerializer;
        while ((classSerializer = this.config.getRegisteredSerializer(clazz)) != null && clazz.isAssignableFrom(classSerializer.getToType())) {
            serializerStack.add(classSerializer);
            clazz = classSerializer.getFromType();
            if (classSerializer.getToType() != classSerializer.getFromType()) continue;
            break;
        }
        return clazz;
    }

    protected Object readAndDeserializeByType(@Nullable Field owner, Object holder, Type type, Deque<ClassSerializer<?, Object>> serializerStack) {
        Object value = this.readByType(owner, holder, type);
        while (!serializerStack.isEmpty()) {
            ClassSerializer<?, Object> classSerializer = serializerStack.pop();
            if (!classSerializer.getFromType().isInstance(value)) continue;
            value = classSerializer.deserialize(value);
        }
        return value;
    }

    public Object readByField(Field field) {
        return this.readByType(field, field.getGenericType());
    }

    public Object readByType(Type type) {
        return this.readByType(null, type);
    }

    public Object readByType(@Nullable Field owner, Type type) {
        return this.readByType(owner, null, type);
    }

    public Object readByType(@Nullable Object holder, Type type) {
        return this.readByType(null, holder, type);
    }

    public Object readByType(@Nullable Field owner, @Nullable Object holder, Type type) {
        AbstractReader abstractReader = this;
        synchronized (abstractReader) {
            if (type == Object.class) {
                return this.readGuessingType(owner);
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Class clazz = (Class)parameterizedType.getRawType();
                Object object = Map.class.isAssignableFrom(clazz) ? this.readMapByType(owner, parameterizedType) : (Collection.class.isAssignableFrom(clazz) ? this.readCollectionByType(owner, parameterizedType, clazz) : this.readGuessingType(owner));
                return object;
            }
            if (type instanceof Class) {
                Class clazz = (Class)type;
                if (Map.class.isAssignableFrom(clazz)) {
                    return this.readMapByType(owner, type);
                }
                if (Collection.class.isAssignableFrom(clazz)) {
                    return this.readCollectionByType(owner, type, clazz);
                }
                if (String.class.isAssignableFrom(clazz)) {
                    return this.readString(owner);
                }
                if (Character.class.isAssignableFrom(clazz) || Character.TYPE.isAssignableFrom(clazz)) {
                    return this.readCharacter(owner);
                }
                if (clazz.isEnum()) {
                    return this.readEnum(owner, clazz);
                }
                if (Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz)) {
                    return this.readBoolean(owner);
                }
                if (Number.class.isAssignableFrom(clazz) || clazz.isPrimitive()) {
                    return this.readNumber(owner, clazz);
                }
                try {
                    Object result;
                    if (clazz.isInstance(holder)) {
                        result = holder;
                    } else {
                        Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
                        constructor.setAccessible(true);
                        result = constructor.newInstance(new Object[0]);
                    }
                    this.readSerializableObject(owner, result, clazz);
                    return result;
                }
                catch (ReflectiveOperationException e) {
                    Object value = this.readGuessingType(owner);
                    ClassSerializer classSerializer = this.config.getRegisteredSerializer(clazz);
                    if (classSerializer != null) {
                        value = classSerializer.deserialize(value);
                    }
                    return value;
                }
            }
            throw new IllegalArgumentException("Invalid type was provided: " + type);
        }
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    private Map<Object, Object> readMapByType(Field owner, Type type) {
        Type mapKeyType = GenericUtils.getParameterType(Map.class, type, 0);
        Type mapValueType = GenericUtils.getParameterType(Map.class, type, 1);
        if (owner != null) {
            MapType mapType = owner.getAnnotation(MapType.class);
            if (mapType != null) {
                try {
                    Constructor<? extends Map> constructor = mapType.value().getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    return this.readMap(owner, constructor.newInstance(new Object[0]), mapKeyType, mapValueType);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new SerializableReadException(e);
                }
            }
            try {
                Constructor<?> constructor = GenericUtils.unwrapClassParameterizedType(type).getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return this.readMap(owner, (Map)constructor.newInstance(new Object[0]), mapKeyType, mapValueType);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new SerializableReadException(e);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return this.readMap((Map)((Object)owner), mapKeyType, mapValueType);
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    private Collection<Object> readCollectionByType(Field owner, Type type, Class<?> clazz) {
        Type collectionEntryType = GenericUtils.getParameterType(Collection.class, type, 0);
        if (owner != null) {
            CollectionType collectionType = owner.getAnnotation(CollectionType.class);
            if (collectionType != null) {
                try {
                    Constructor<? extends Collection> constructor = collectionType.value().getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    return this.readCollection(owner, constructor.newInstance(new Object[0]), collectionEntryType);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new SerializableReadException(e);
                }
            }
            try {
                Constructor<?> constructor = GenericUtils.unwrapClassParameterizedType(type).getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return this.readCollection(owner, (Collection)constructor.newInstance(new Object[0]), collectionEntryType);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new SerializableReadException(e);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return Set.class.isAssignableFrom(clazz) ? this.readSet(owner, collectionEntryType) : (Queue.class.isAssignableFrom(clazz) ? this.readDeque(owner, collectionEntryType) : this.readList(owner, collectionEntryType));
    }

    public Object readGuessingType() {
        return this.readGuessingType(null);
    }

    public abstract Object readGuessingType(@Nullable Field var1);

    public Map<Object, Object> readMap(@Nullable Field owner) {
        return this.readMap((Map)((Object)owner), (Type)((Object)Object.class), (Type)((Object)Object.class));
    }

    public Map<Object, Object> readMap(Type keyType, Type valueType) {
        return this.readMap((Map)null, keyType, valueType);
    }

    public Map<Object, Object> readMap(@Nullable Field owner, Type keyType, Type valueType) {
        return this.readMap(owner, new LinkedHashMap(), keyType, valueType);
    }

    public <C extends Map<Object, Object>> C readMap(@Nullable Field owner, C result) {
        return this.readMap(owner, result, (Type)((Object)Object.class), (Type)((Object)Object.class));
    }

    public <C extends Map<Object, Object>> C readMap(C result, Type keyType, Type valueType) {
        return this.readMap(null, result, keyType, valueType);
    }

    public abstract <C extends Map<Object, Object>> C readMap(@Nullable Field var1, C var2, Type var3, Type var4);

    public Set<Object> readSet(@Nullable Field owner) {
        return this.readSet(owner, (Type)((Object)Object.class));
    }

    public Set<Object> readSet(Type type) {
        return this.readSet(null, type);
    }

    public Set<Object> readSet(@Nullable Field owner, Type type) {
        return this.readCollection(owner, new HashSet(), type);
    }

    public Deque<Object> readDeque(@Nullable Field owner) {
        return this.readDeque(owner, (Type)((Object)Object.class));
    }

    public Deque<Object> readDeque(Type type) {
        return this.readDeque(null, type);
    }

    public Deque<Object> readDeque(@Nullable Field owner, Type type) {
        return this.readCollection(owner, new ArrayDeque(), type);
    }

    public List<Object> readList(@Nullable Field owner) {
        return this.readList(owner, (Type)((Object)Object.class));
    }

    public List<Object> readList(Type type) {
        return this.readList(null, type);
    }

    public List<Object> readList(@Nullable Field owner, Type type) {
        return this.readCollection(owner, new ArrayList(), type);
    }

    public <C extends Collection<Object>> C readCollection(@Nullable Field owner, C result) {
        return this.readCollection(owner, result, (Type)((Object)Object.class));
    }

    public <C extends Collection<Object>> C readCollection(C result, Type type) {
        return this.readCollection(null, result, type);
    }

    public abstract <C extends Collection<Object>> C readCollection(@Nullable Field var1, C var2, Type var3);

    public String readString() {
        return this.readString(null);
    }

    public abstract String readString(@Nullable Field var1);

    public Character readCharacter() {
        return this.readCharacter(null);
    }

    public abstract Character readCharacter(@Nullable Field var1);

    public <T extends Enum<T>> T readEnum(@Nullable Field owner, Class<?> enumClass) {
        String enumValue = this.readString(owner);
        return enumValue == null ? null : (T)Enum.valueOf(enumClass, enumValue);
    }

    public Boolean readBoolean() {
        return this.readBoolean(null);
    }

    public abstract Boolean readBoolean(@Nullable Field var1);

    public Number readNumber(Class<?> clazz) {
        return this.readNumber(null, clazz);
    }

    public Number readNumber(@Nullable Field owner, Class<?> clazz) {
        AbstractReader abstractReader = this;
        synchronized (abstractReader) {
            boolean decimal = Float.class.isAssignableFrom(clazz) || Float.TYPE.isAssignableFrom(clazz) || Double.class.isAssignableFrom(clazz) || Double.TYPE.isAssignableFrom(clazz);
            try {
                return decimal ? (Number)this.readDouble(owner) : (Number)this.readLong(owner);
            }
            catch (NumberFormatException e) {
                if (this.config.isSafeMode()) {
                    LOGGER.log(Level.WARNING, "Can't read number due to exception caught, overwriting the value by 0", e);
                    return decimal ? (Number)0.0 : (Number)0L;
                }
                throw new RuntimeException(e);
            }
        }
    }

    public Double readDouble() {
        return this.readDouble(null);
    }

    public abstract Double readDouble(@Nullable Field var1);

    public Long readLong() {
        return this.readLong(null);
    }

    public abstract Long readLong(@Nullable Field var1);

    public void skipNode(Field node) {
        this.skipNode(node, node.getType());
    }

    public void skipNode(Class<?> clazz) {
        this.skipNode(null, clazz);
    }

    public void skipNode(@Nullable Field owner, Class<?> clazz) {
        if (Map.class.isAssignableFrom(clazz)) {
            this.skipMap(owner);
        } else if (Collection.class.isAssignableFrom(clazz)) {
            this.skipCollection(owner);
        } else if (clazz.isEnum() || String.class.isAssignableFrom(clazz) || Boolean.class.isAssignableFrom(clazz) || Boolean.TYPE.isAssignableFrom(clazz) || Character.class.isAssignableFrom(clazz) || Character.TYPE.isAssignableFrom(clazz) || Number.class.isAssignableFrom(clazz) || clazz.isPrimitive()) {
            this.skipString(owner);
        } else {
            this.skipGuessingType(owner);
        }
    }

    public void skipMap() {
        this.skipMap(null);
    }

    public abstract void skipMap(@Nullable Field var1);

    public void skipCollection() {
        this.skipCollection(null);
    }

    public abstract void skipCollection(@Nullable Field var1);

    public void skipString() {
        this.skipString(null);
    }

    public abstract void skipString(@Nullable Field var1);

    public void skipGuessingType() {
        this.skipGuessingType(null);
    }

    public abstract void skipGuessingType(@Nullable Field var1);

    public boolean skipComments(char marker, boolean reuse) {
        return this.skipComments(null, marker, reuse);
    }

    public abstract boolean skipComments(@Nullable Field var1, char var2, boolean var3);

    public char readRawIgnoreEmptyAndNewLines() {
        return this.readRawIgnoreEmptyAndCharacter('\n');
    }

    public char readRawIgnoreEmptyAndCharacter(char marker) {
        char readMarker;
        while ((readMarker = this.readRawIgnoreEmpty()) == marker) {
        }
        return readMarker;
    }

    public char readRawIgnoreEmpty() {
        char marker;
        int type;
        while ((type = Character.getType(marker = this.readRaw())) == 12 || type == 14 || marker == '\t') {
        }
        return marker;
    }

    public char readRaw() {
        int n;
        if (this.reuseBuffer) {
            this.reuseBuffer = false;
        } else if (this.seekEnabled || this.seekBuffer.isEmpty()) {
            try {
                if (this.reader.read(this.singleCharBuffer, 0, 1) < 1) {
                    this.singleCharBuffer[0] = '\u0000';
                }
            }
            catch (IOException e) {
                throw new SerializableReadException(e);
            }
            if (this.seekEnabled) {
                this.seekBuffer.add(Character.valueOf(this.singleCharBuffer[0]));
            }
        } else {
            this.singleCharBuffer[0] = this.seekBuffer.poll().charValue();
        }
        block1 : switch (this.singleCharBuffer[0]) {
            case '\r': {
                switch (this.carriageType) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case LF: {
                        throw new IllegalStateException("Caught a Carriage Return in LF mode");
                    }
                    case CRLF: {
                        n = this.readRaw();
                        break block1;
                    }
                    case CR: {
                        n = 10;
                        break block1;
                    }
                    case UNKNOWN: 
                }
                char nextChar = this.readRaw();
                if (nextChar == '\n') {
                    this.carriageType = CarriageType.CRLF;
                } else {
                    this.carriageType = CarriageType.CR;
                    this.seekBuffer.add(Character.valueOf(nextChar));
                }
                n = 10;
                break;
            }
            case '\n': {
                switch (this.carriageType) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case CR: {
                        throw new IllegalStateException("Caught a Line Feed in CR mode");
                    }
                    case LF: 
                    case CRLF: {
                        n = 10;
                        break block1;
                    }
                    case UNKNOWN: 
                }
                this.carriageType = CarriageType.LF;
                n = 10;
                break;
            }
            default: {
                n = this.singleCharBuffer[0];
            }
        }
        return (char)n;
    }

    public void replaceSingleCharBuffer(char replacement) {
        this.singleCharBuffer[0] = replacement;
    }

    public void setReuseBuffer() {
        this.reuseBuffer = true;
    }

    public boolean isReuseBuffer() {
        return this.reuseBuffer;
    }

    public void setSeek() {
        this.seekEnabled = true;
    }

    public void setSeekFromMarker(char marker) {
        this.seekBuffer.add(Character.valueOf(marker));
        this.seekEnabled = true;
    }

    public void unsetSeek() {
        this.seekEnabled = false;
    }

    public void clearSeek() {
        this.seekBuffer.clear();
        this.seekEnabled = false;
    }

    public boolean isBackupPreferred() {
        return this.backupPreferred;
    }

    protected void setBackupPreferred() {
        this.backupPreferred = true;
    }

    private static enum CarriageType {
        UNKNOWN,
        CR,
        CRLF,
        LF;

    }
}

