/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.serializer.language.object;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import net.elytrium.serializer.LoadResult;
import net.elytrium.serializer.SerializerConfig;
import net.elytrium.serializer.annotations.Comment;
import net.elytrium.serializer.exceptions.SerializableReadException;
import net.elytrium.serializer.exceptions.SerializableWriteException;
import net.elytrium.serializer.language.reader.AbstractReader;
import net.elytrium.serializer.language.writer.AbstractWriter;

public abstract class AbstractSerializable {
    private static final DateTimeFormatter BACKUP_DATE_PATTERN = DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss");
    private SerializerConfig config;

    protected AbstractSerializable() {
        this(SerializerConfig.DEFAULT);
    }

    protected AbstractSerializable(SerializerConfig config) {
        this.config = config;
    }

    public void setConfig(SerializerConfig config) {
        this.config = config;
    }

    public SerializerConfig getConfig() {
        return this.config;
    }

    public LoadResult reload(Path path) {
        LoadResult result = this.load(path);
        switch (result) {
            case SUCCESS: {
                this.save(path);
                break;
            }
            case CONFIG_NOT_EXISTS: {
                this.save(path);
                this.load(path);
                break;
            }
            case BACKUP_PREFERRED: {
                if (this.config.isBackupOnErrors()) {
                    this.backup(path);
                }
                this.save(path);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid LoadResult.");
            }
        }
        return result;
    }

    public LoadResult load(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            try {
                return this.load(Files.newBufferedReader(path)) ? LoadResult.SUCCESS : LoadResult.BACKUP_PREFERRED;
            }
            catch (IOException e) {
                throw new SerializableReadException(e);
            }
        }
        return LoadResult.CONFIG_NOT_EXISTS;
    }

    public boolean load(BufferedReader reader) {
        AbstractReader abstractReader = this.getReader(reader);
        abstractReader.readSerializableObject(this, this.getClass());
        return !abstractReader.isBackupPreferred();
    }

    public void save(Path path) {
        try {
            Path parent = path.getParent();
            if (parent == null) {
                throw new NullPointerException("Parent path is null for " + path);
            }
            Files.createDirectories(parent, new FileAttribute[0]);
            this.save(Files.newBufferedWriter(path, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new SerializableWriteException(e);
        }
    }

    public void save(BufferedWriter writer) {
        Comment[] comments = (Comment[])this.getClass().getAnnotationsByType(Comment.class);
        AbstractWriter abstractWriter = this.getWriter(writer);
        abstractWriter.writeComments(comments, Comment.At.PREPEND, true);
        abstractWriter.writeSerializableObject(this, this.getClass());
        abstractWriter.writeComments(comments, Comment.At.SAME_LINE, true);
        abstractWriter.writeComments(comments, Comment.At.APPEND, true);
        try {
            writer.flush();
        }
        catch (IOException e) {
            throw new SerializableWriteException(e);
        }
    }

    public void backup(Path path) {
        try {
            Path parent = path.getParent();
            if (parent == null) {
                throw new NullPointerException("Parent path is null for " + path);
            }
            Files.copy(path, parent.resolve(path.getFileName() + "_backup_" + LocalDateTime.now().format(BACKUP_DATE_PATTERN)), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new SerializableWriteException(e);
        }
    }

    protected abstract AbstractReader getReader(BufferedReader var1);

    protected abstract AbstractWriter getWriter(BufferedWriter var1);
}

