/*
 * Decompiled with CFR 0.152.
 */
package net.elytrium.serializer.custom;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class ClassSerializer<T, F> {
    private final Class<T> toClass;
    private final Class<F> fromClass;

    protected ClassSerializer() {
        Type[] actualTypeArguments = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments();
        this.toClass = actualTypeArguments[0] instanceof Class ? (Class)actualTypeArguments[0] : (Class)((ParameterizedType)actualTypeArguments[0]).getRawType();
        this.fromClass = actualTypeArguments[1] instanceof Class ? (Class)actualTypeArguments[1] : (Class)((ParameterizedType)actualTypeArguments[1]).getRawType();
    }

    protected ClassSerializer(Class<T> toClass, Class<F> fromClass) {
        this.toClass = toClass;
        this.fromClass = fromClass;
    }

    public F serialize(T from) {
        throw new UnsupportedOperationException();
    }

    public T deserialize(F from) {
        throw new UnsupportedOperationException();
    }

    public Class<T> getToType() {
        return this.toClass;
    }

    public Class<F> getFromType() {
        return this.fromClass;
    }
}

