/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.utility;

import java.security.AccessController;
import java.security.PrivilegedAction;
import net.bytebuddy.ClassFileVersion;
import net.bytebuddy.build.AccessControllerPlugin;
import net.bytebuddy.build.HashCodeAndEqualsPlugin;
import net.bytebuddy.jar.asm.Attribute;
import net.bytebuddy.jar.asm.ClassReader;
import net.bytebuddy.jar.asm.ClassVisitor;
import net.bytebuddy.utility.OpenedClassReader;
import net.bytebuddy.utility.dispatcher.JavaDispatcher;
import net.bytebuddy.utility.nullability.MaybeNull;
import net.bytebuddy.utility.privilege.GetSystemPropertyAction;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public interface AsmClassReader {
    @MaybeNull
    public <T> T unwrap(Class<T> var1);

    public void accept(ClassVisitor var1, int var2);

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @HashCodeAndEqualsPlugin.Enhance
    public static class ForClassFileApi
    implements AsmClassReader {
        protected static final JdkClassReader DISPATCHER;
        private final Object classReader;
        private static final boolean ACCESS_CONTROLLER;

        public ForClassFileApi(Object classReader) {
            if (!DISPATCHER.isInstance(classReader)) {
                throw new IllegalArgumentException();
            }
            this.classReader = classReader;
        }

        @AccessControllerPlugin.Enhance
        private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
            PrivilegedAction<T> action;
            if (ACCESS_CONTROLLER) {
                return AccessController.doPrivileged(privilegedAction);
            }
            return action.run();
        }

        @Override
        @MaybeNull
        public <T> T unwrap(Class<T> type) {
            return null;
        }

        @Override
        public void accept(ClassVisitor classVisitor, int flags) {
            DISPATCHER.accept(this.classReader, classVisitor, flags);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        static {
            try {
                Class.forName("java.security.AccessController", false, null);
                ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("net.bytebuddy.securitymanager", "true"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                ACCESS_CONTROLLER = false;
            }
            catch (SecurityException securityException) {
                ACCESS_CONTROLLER = true;
            }
            DISPATCHER = ForClassFileApi.doPrivileged(JavaDispatcher.of(JdkClassReader.class, ForClassFileApi.class.getClassLoader()));
        }

        public boolean equals(@MaybeNull Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.classReader.equals(((ForClassFileApi)object).classReader);
        }

        public int hashCode() {
            return this.getClass().hashCode() * 31 + this.classReader.hashCode();
        }

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        @JavaDispatcher.Proxied(value="net.bytebuddy.jar.asmjdkbridge.JdkClassReader")
        protected static interface JdkClassReader {
            @JavaDispatcher.IsConstructor
            @JavaDispatcher.Proxied(value="isInstance")
            public boolean isInstance(Object var1);

            @JavaDispatcher.IsConstructor
            @JavaDispatcher.Proxied(value="make")
            public Object make(byte[] var1);

            @JavaDispatcher.Proxied(value="accept")
            public void accept(Object var1, ClassVisitor var2, int var3);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static class ForAsm
    implements AsmClassReader {
        private static final Attribute[] NO_ATTRIBUTES = new Attribute[0];
        private final ClassReader classReader;

        public ForAsm(ClassReader classReader) {
            this.classReader = classReader;
        }

        @Override
        @MaybeNull
        public <T> T unwrap(Class<T> type) {
            return type.isInstance(this.classReader) ? (T)type.cast(this.classReader) : null;
        }

        @Override
        public void accept(ClassVisitor classVisitor, int flags) {
            this.classReader.accept(classVisitor, NO_ATTRIBUTES, flags);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public static interface Factory {
        public AsmClassReader make(byte[] var1);

        public AsmClassReader make(byte[] var1, boolean var2);

        /*
         * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
         */
        public static abstract class Default
        extends Enum<Default>
        implements Factory {
            public static final /* enum */ Default IMPLICIT;
            public static final /* enum */ Default ASM_FIRST;
            public static final /* enum */ Default CLASS_FILE_API_FIRST;
            public static final /* enum */ Default ASM_ONLY;
            public static final /* enum */ Default CLASS_FILE_API_ONLY;
            private static final Factory FACTORY;
            private static final /* synthetic */ Default[] $VALUES;
            private static final boolean ACCESS_CONTROLLER;

            public static Default[] values() {
                return (Default[])$VALUES.clone();
            }

            public static Default valueOf(String name) {
                return Enum.valueOf(Default.class, name);
            }

            @MaybeNull
            @AccessControllerPlugin.Enhance
            private static <T> T doPrivileged(PrivilegedAction<T> privilegedAction) {
                PrivilegedAction<T> action;
                if (ACCESS_CONTROLLER) {
                    return AccessController.doPrivileged(privilegedAction);
                }
                return action.run();
            }

            @Override
            public AsmClassReader make(byte[] binaryRepresentation) {
                return this.make(binaryRepresentation, OpenedClassReader.EXPERIMENTAL);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            static {
                String processor;
                try {
                    Class.forName("java.security.AccessController", false, null);
                    ACCESS_CONTROLLER = Boolean.parseBoolean(System.getProperty("net.bytebuddy.securitymanager", "true"));
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ACCESS_CONTROLLER = false;
                }
                catch (SecurityException securityException) {
                    ACCESS_CONTROLLER = true;
                }
                IMPLICIT = new Default(){

                    @Override
                    public AsmClassReader make(byte[] binaryRepresentation, boolean experimental) {
                        return FACTORY.make(binaryRepresentation, experimental);
                    }
                };
                ASM_FIRST = new Default(){

                    @Override
                    public AsmClassReader make(byte[] binaryRepresentation, boolean experimental) {
                        return ClassFileVersion.ofClassFile(binaryRepresentation).isGreaterThan(ClassFileVersion.latest()) ? CLASS_FILE_API_ONLY.make(binaryRepresentation) : ASM_ONLY.make(binaryRepresentation);
                    }
                };
                CLASS_FILE_API_FIRST = new Default(){

                    @Override
                    public AsmClassReader make(byte[] binaryRepresentation, boolean experimental) {
                        return ClassFileVersion.ofThisVm().isAtLeast(ClassFileVersion.JAVA_V24) ? CLASS_FILE_API_ONLY.make(binaryRepresentation) : ASM_ONLY.make(binaryRepresentation);
                    }
                };
                ASM_ONLY = new Default(){

                    @Override
                    public AsmClassReader make(byte[] binaryRepresentation, boolean experimental) {
                        return new ForAsm(OpenedClassReader.of(binaryRepresentation, experimental));
                    }
                };
                CLASS_FILE_API_ONLY = new Default(){

                    @Override
                    public AsmClassReader make(byte[] binaryRepresentation, boolean experimental) {
                        return new ForClassFileApi(ForClassFileApi.DISPATCHER.make(binaryRepresentation));
                    }
                };
                $VALUES = new Default[]{IMPLICIT, ASM_FIRST, CLASS_FILE_API_FIRST, ASM_ONLY, CLASS_FILE_API_ONLY};
                try {
                    processor = Default.doPrivileged(new GetSystemPropertyAction("net.bytebuddy.processor"));
                }
                catch (Throwable ignored) {
                    processor = null;
                }
                FACTORY = processor == null ? ASM_FIRST : Default.valueOf(processor);
            }
        }
    }
}

