/*
 * Decompiled with CFR 0.152.
 */
package net.bytebuddy.agent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.instrument.Instrumentation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import net.bytebuddy.agent.Attacher;
import net.bytebuddy.agent.Installer;
import net.bytebuddy.agent.VirtualMachine;

public class ByteBuddyAgent {
    private static final String AGENT_CLASS_PROPERTY = "Agent-Class";
    private static final String CAN_REDEFINE_CLASSES_PROPERTY = "Can-Redefine-Classes";
    private static final String CAN_RETRANSFORM_CLASSES_PROPERTY = "Can-Retransform-Classes";
    private static final String CAN_SET_NATIVE_METHOD_PREFIX = "Can-Set-Native-Method-Prefix";
    private static final String MANIFEST_VERSION_VALUE = "1.0";
    private static final int BUFFER_SIZE = 1024;
    private static final int START_INDEX = 0;
    private static final int END_OF_FILE = -1;
    private static final int SUCCESSFUL_ATTACH = 0;
    private static final Object STATIC_MEMBER = null;
    private static final ClassLoader BOOTSTRAP_CLASS_LOADER = null;
    private static final String WITHOUT_ARGUMENT = null;
    private static final String ATTACHER_FILE_NAME = "byteBuddyAttacher";
    private static final String CLASS_FILE_EXTENSION = ".class";
    private static final String JAR_FILE_EXTENSION = ".jar";
    private static final String CLASS_PATH_ARGUMENT = "-cp";
    private static final String JAVA_HOME = "java.home";
    private static final String OS_NAME = "os.name";
    private static final String INSTRUMENTATION_METHOD = "getInstrumentation";
    private static final String FILE_PROTOCOL = "file";
    private static final Instrumentation UNAVAILABLE = null;
    private static final File CANNOT_SELF_RESOLVE = null;
    private static final AttachmentTypeEvaluator ATTACHMENT_TYPE_EVALUATOR = AccessController.doPrivileged(AttachmentTypeEvaluator.InstallationAction.INSTANCE);

    private ByteBuddyAgent() {
        throw new UnsupportedOperationException("This class is a utility class and not supposed to be instantiated");
    }

    public static Instrumentation getInstrumentation() {
        Instrumentation instrumentation = ByteBuddyAgent.doGetInstrumentation();
        if (instrumentation == null) {
            throw new IllegalStateException("The Byte Buddy agent is not initialized");
        }
        return instrumentation;
    }

    public static void attach(File agentJar, String processId) {
        ByteBuddyAgent.attach(agentJar, processId, WITHOUT_ARGUMENT);
    }

    public static void attach(File agentJar, String processId, String argument) {
        ByteBuddyAgent.attach(agentJar, processId, argument, AttachmentProvider.DEFAULT);
    }

    public static void attach(File agentJar, String processId, AttachmentProvider attachmentProvider) {
        ByteBuddyAgent.attach(agentJar, processId, WITHOUT_ARGUMENT, attachmentProvider);
    }

    public static void attach(File agentJar, String processId, String argument, AttachmentProvider attachmentProvider) {
        ByteBuddyAgent.install(attachmentProvider, processId, argument, new AgentProvider.ForExistingAgent(agentJar));
    }

    public static void attach(File agentJar, ProcessProvider processProvider) {
        ByteBuddyAgent.attach(agentJar, processProvider, WITHOUT_ARGUMENT);
    }

    public static void attach(File agentJar, ProcessProvider processProvider, String argument) {
        ByteBuddyAgent.attach(agentJar, processProvider, argument, AttachmentProvider.DEFAULT);
    }

    public static void attach(File agentJar, ProcessProvider processProvider, AttachmentProvider attachmentProvider) {
        ByteBuddyAgent.attach(agentJar, processProvider, WITHOUT_ARGUMENT, attachmentProvider);
    }

    public static void attach(File agentJar, ProcessProvider processProvider, String argument, AttachmentProvider attachmentProvider) {
        ByteBuddyAgent.install(attachmentProvider, processProvider.resolve(), argument, new AgentProvider.ForExistingAgent(agentJar));
    }

    public static Instrumentation install() {
        return ByteBuddyAgent.install(AttachmentProvider.DEFAULT);
    }

    public static Instrumentation install(AttachmentProvider attachmentProvider) {
        return ByteBuddyAgent.install(attachmentProvider, ProcessProvider.ForCurrentVm.INSTANCE);
    }

    public static Instrumentation install(ProcessProvider processProvider) {
        return ByteBuddyAgent.install(AttachmentProvider.DEFAULT, processProvider);
    }

    public static synchronized Instrumentation install(AttachmentProvider attachmentProvider, ProcessProvider processProvider) {
        Instrumentation instrumentation = ByteBuddyAgent.doGetInstrumentation();
        if (instrumentation != null) {
            return instrumentation;
        }
        ByteBuddyAgent.install(attachmentProvider, processProvider.resolve(), WITHOUT_ARGUMENT, AgentProvider.ForByteBuddyAgent.INSTANCE);
        return ByteBuddyAgent.doGetInstrumentation();
    }

    private static void install(AttachmentProvider attachmentProvider, String processId, String argument, AgentProvider agentProvider) {
        AttachmentProvider.Accessor attachmentAccessor = attachmentProvider.attempt();
        if (!attachmentAccessor.isAvailable()) {
            throw new IllegalStateException("No compatible attachment provider is available");
        }
        try {
            if (ATTACHMENT_TYPE_EVALUATOR.requiresExternalAttachment(processId)) {
                ByteBuddyAgent.installExternal(attachmentAccessor.getExternalAttachment(), processId, agentProvider.resolve(), argument);
            } else {
                Attacher.install(attachmentAccessor.getVirtualMachineType(), processId, agentProvider.resolve().getAbsolutePath(), argument);
            }
        }
        catch (RuntimeException exception) {
            throw exception;
        }
        catch (Exception exception) {
            throw new IllegalStateException("Error during attachment using: " + attachmentProvider, exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installExternal(AttachmentProvider.Accessor.ExternalAttachment externalAttachment, String processId, File agent, String argument) throws Exception {
        File selfResolvedJar = ByteBuddyAgent.trySelfResolve();
        File attachmentJar = null;
        try {
            if (selfResolvedJar == null) {
                InputStream inputStream = Attacher.class.getResourceAsStream('/' + Attacher.class.getName().replace('.', '/') + CLASS_FILE_EXTENSION);
                if (inputStream == null) {
                    throw new IllegalStateException("Cannot locate class file for Byte Buddy installation process");
                }
                try {
                    attachmentJar = File.createTempFile(ATTACHER_FILE_NAME, JAR_FILE_EXTENSION);
                    JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(attachmentJar));
                    try {
                        int index;
                        jarOutputStream.putNextEntry(new JarEntry(Attacher.class.getName().replace('.', '/') + CLASS_FILE_EXTENSION));
                        byte[] buffer = new byte[1024];
                        while ((index = inputStream.read(buffer)) != -1) {
                            jarOutputStream.write(buffer, 0, index);
                        }
                        jarOutputStream.closeEntry();
                    }
                    finally {
                        jarOutputStream.close();
                    }
                }
                finally {
                    inputStream.close();
                }
            }
            StringBuilder classPath = new StringBuilder().append(ByteBuddyAgent.quote((selfResolvedJar == null ? attachmentJar : selfResolvedJar).getCanonicalPath()));
            for (File jar : externalAttachment.getClassPath()) {
                classPath.append(File.pathSeparatorChar).append(ByteBuddyAgent.quote(jar.getCanonicalPath()));
            }
            String[] stringArray = new String[8];
            stringArray[0] = ByteBuddyAgent.quote(System.getProperty(JAVA_HOME) + File.separatorChar + "bin" + File.separatorChar + (System.getProperty(OS_NAME, "").toLowerCase(Locale.US).contains("windows") ? "java.exe" : "java"));
            stringArray[1] = CLASS_PATH_ARGUMENT;
            stringArray[2] = classPath.toString();
            stringArray[3] = Attacher.class.getName();
            stringArray[4] = externalAttachment.getVirtualMachineType();
            stringArray[5] = processId;
            stringArray[6] = ByteBuddyAgent.quote(agent.getAbsolutePath());
            String string = stringArray[7] = argument == null ? "" : "=" + argument;
            if (new ProcessBuilder(stringArray).start().waitFor() != 0) {
                throw new IllegalStateException("Could not self-attach to current VM using external process");
            }
        }
        finally {
            if (attachmentJar != null && !attachmentJar.delete()) {
                attachmentJar.deleteOnExit();
            }
        }
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
    private static File trySelfResolve() {
        try {
            ProtectionDomain protectionDomain = Attacher.class.getProtectionDomain();
            if (protectionDomain == null) {
                return CANNOT_SELF_RESOLVE;
            }
            CodeSource codeSource = protectionDomain.getCodeSource();
            if (codeSource == null) {
                return CANNOT_SELF_RESOLVE;
            }
            URL location = codeSource.getLocation();
            if (!location.getProtocol().equals(FILE_PROTOCOL)) {
                return CANNOT_SELF_RESOLVE;
            }
            try {
                return new File(location.toURI());
            }
            catch (URISyntaxException ignored) {
                return new File(location.getPath());
            }
        }
        catch (Exception ignored) {
            return CANNOT_SELF_RESOLVE;
        }
    }

    private static String quote(String value) {
        return value.contains(" ") ? '\"' + value + '\"' : value;
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Legal outcome where reflection communicates errors by throwing an exception")
    private static Instrumentation doGetInstrumentation() {
        try {
            return (Instrumentation)ClassLoader.getSystemClassLoader().loadClass(Installer.class.getName()).getMethod(INSTRUMENTATION_METHOD, new Class[0]).invoke(STATIC_MEMBER, new Object[0]);
        }
        catch (Exception ignored) {
            return UNAVAILABLE;
        }
    }

    protected static interface AttachmentTypeEvaluator {
        public boolean requiresExternalAttachment(String var1);

        public static class ForJava9CapableVm
        implements AttachmentTypeEvaluator {
            private final Method current;
            private final Method pid;

            protected ForJava9CapableVm(Method current, Method pid) {
                this.current = current;
                this.pid = pid;
            }

            @Override
            public boolean requiresExternalAttachment(String processId) {
                try {
                    return this.pid.invoke(this.current.invoke(STATIC_MEMBER, new Object[0]), new Object[0]).toString().equals(processId);
                }
                catch (IllegalAccessException exception) {
                    throw new IllegalStateException("Cannot access Java 9 process API", exception);
                }
                catch (InvocationTargetException exception) {
                    throw new IllegalStateException("Error when accessing Java 9 process API", exception.getCause());
                }
            }
        }

        public static enum Disabled implements AttachmentTypeEvaluator
        {
            INSTANCE;


            @Override
            public boolean requiresExternalAttachment(String processId) {
                return false;
            }
        }

        public static enum InstallationAction implements PrivilegedAction<AttachmentTypeEvaluator>
        {
            INSTANCE;

            private static final String JDK_ALLOW_SELF_ATTACH = "jdk.attach.allowAttachSelf";

            @Override
            @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
            public AttachmentTypeEvaluator run() {
                try {
                    if (Boolean.getBoolean(JDK_ALLOW_SELF_ATTACH)) {
                        return Disabled.INSTANCE;
                    }
                    return new ForJava9CapableVm(Class.forName("java.lang.ProcessHandle").getMethod("current", new Class[0]), Class.forName("java.lang.ProcessHandle").getMethod("pid", new Class[0]));
                }
                catch (Exception ignored) {
                    return Disabled.INSTANCE;
                }
            }
        }
    }

    protected static interface AgentProvider {
        public File resolve() throws IOException;

        public static class ForExistingAgent
        implements AgentProvider {
            private File agent;

            protected ForExistingAgent(File agent) {
                this.agent = agent;
            }

            @Override
            public File resolve() {
                return this.agent;
            }
        }

        public static enum ForByteBuddyAgent implements AgentProvider
        {
            INSTANCE;

            private static final String AGENT_FILE_NAME = "byteBuddyAgent";

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static File trySelfResolve() throws IOException {
                File agentJar;
                ProtectionDomain protectionDomain = Installer.class.getProtectionDomain();
                if (protectionDomain == null) {
                    return CANNOT_SELF_RESOLVE;
                }
                CodeSource codeSource = protectionDomain.getCodeSource();
                if (codeSource == null) {
                    return CANNOT_SELF_RESOLVE;
                }
                URL location = codeSource.getLocation();
                if (!location.getProtocol().equals(ByteBuddyAgent.FILE_PROTOCOL)) {
                    return CANNOT_SELF_RESOLVE;
                }
                try {
                    agentJar = new File(location.toURI());
                }
                catch (URISyntaxException ignored) {
                    agentJar = new File(location.getPath());
                }
                if (!agentJar.isFile() || !agentJar.canRead()) {
                    return CANNOT_SELF_RESOLVE;
                }
                JarInputStream jarInputStream = new JarInputStream(new FileInputStream(agentJar));
                try {
                    Manifest manifest = jarInputStream.getManifest();
                    if (manifest == null) {
                        File file = CANNOT_SELF_RESOLVE;
                        return file;
                    }
                    Attributes attributes = manifest.getMainAttributes();
                    if (attributes == null) {
                        File file = CANNOT_SELF_RESOLVE;
                        return file;
                    }
                    if (Installer.class.getName().equals(attributes.getValue(ByteBuddyAgent.AGENT_CLASS_PROPERTY)) && Boolean.parseBoolean(attributes.getValue(ByteBuddyAgent.CAN_REDEFINE_CLASSES_PROPERTY)) && Boolean.parseBoolean(attributes.getValue(ByteBuddyAgent.CAN_RETRANSFORM_CLASSES_PROPERTY)) && Boolean.parseBoolean(attributes.getValue(ByteBuddyAgent.CAN_SET_NATIVE_METHOD_PREFIX))) {
                        File file = agentJar;
                        return file;
                    }
                    File file = CANNOT_SELF_RESOLVE;
                    return file;
                }
                finally {
                    jarInputStream.close();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private static File createJarFile() throws IOException {
                InputStream inputStream = Installer.class.getResourceAsStream('/' + Installer.class.getName().replace('.', '/') + ByteBuddyAgent.CLASS_FILE_EXTENSION);
                if (inputStream == null) {
                    throw new IllegalStateException("Cannot locate class file for Byte Buddy installer");
                }
                try {
                    File agentJar = File.createTempFile(AGENT_FILE_NAME, ByteBuddyAgent.JAR_FILE_EXTENSION);
                    agentJar.deleteOnExit();
                    Manifest manifest = new Manifest();
                    manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, ByteBuddyAgent.MANIFEST_VERSION_VALUE);
                    manifest.getMainAttributes().put(new Attributes.Name(ByteBuddyAgent.AGENT_CLASS_PROPERTY), Installer.class.getName());
                    manifest.getMainAttributes().put(new Attributes.Name(ByteBuddyAgent.CAN_REDEFINE_CLASSES_PROPERTY), Boolean.TRUE.toString());
                    manifest.getMainAttributes().put(new Attributes.Name(ByteBuddyAgent.CAN_RETRANSFORM_CLASSES_PROPERTY), Boolean.TRUE.toString());
                    manifest.getMainAttributes().put(new Attributes.Name(ByteBuddyAgent.CAN_SET_NATIVE_METHOD_PREFIX), Boolean.TRUE.toString());
                    JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(agentJar), manifest);
                    try {
                        int index;
                        jarOutputStream.putNextEntry(new JarEntry(Installer.class.getName().replace('.', '/') + ByteBuddyAgent.CLASS_FILE_EXTENSION));
                        byte[] buffer = new byte[1024];
                        while ((index = inputStream.read(buffer)) != -1) {
                            jarOutputStream.write(buffer, 0, index);
                        }
                        jarOutputStream.closeEntry();
                    }
                    finally {
                        jarOutputStream.close();
                    }
                    File file = agentJar;
                    return file;
                }
                finally {
                    inputStream.close();
                }
            }

            @Override
            public File resolve() throws IOException {
                try {
                    File agentJar = ForByteBuddyAgent.trySelfResolve();
                    return agentJar == null ? ForByteBuddyAgent.createJarFile() : agentJar;
                }
                catch (Exception ignored) {
                    return ForByteBuddyAgent.createJarFile();
                }
            }
        }
    }

    public static interface ProcessProvider {
        public String resolve();

        public static enum ForCurrentVm implements ProcessProvider
        {
            INSTANCE;

            private final ProcessProvider dispatcher = ForJava9CapableVm.make();

            @Override
            public String resolve() {
                return this.dispatcher.resolve();
            }

            protected static class ForJava9CapableVm
            implements ProcessProvider {
                private final Method current;
                private final Method pid;

                protected ForJava9CapableVm(Method current, Method pid) {
                    this.current = current;
                    this.pid = pid;
                }

                @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Exception should not be rethrown but trigger a fallback")
                public static ProcessProvider make() {
                    try {
                        return new ForJava9CapableVm(Class.forName("java.lang.ProcessHandle").getMethod("current", new Class[0]), Class.forName("java.lang.ProcessHandle").getMethod("pid", new Class[0]));
                    }
                    catch (Exception ignored) {
                        return ForLegacyVm.INSTANCE;
                    }
                }

                @Override
                public String resolve() {
                    try {
                        return this.pid.invoke(this.current.invoke(STATIC_MEMBER, new Object[0]), new Object[0]).toString();
                    }
                    catch (IllegalAccessException exception) {
                        throw new IllegalStateException("Cannot access Java 9 process API", exception);
                    }
                    catch (InvocationTargetException exception) {
                        throw new IllegalStateException("Error when accessing Java 9 process API", exception.getCause());
                    }
                }
            }

            protected static enum ForLegacyVm implements ProcessProvider
            {
                INSTANCE;


                @Override
                public String resolve() {
                    String runtimeName = ManagementFactory.getRuntimeMXBean().getName();
                    int processIdIndex = runtimeName.indexOf(64);
                    if (processIdIndex == -1) {
                        throw new IllegalStateException("Cannot extract process id from runtime management bean");
                    }
                    return runtimeName.substring(0, processIdIndex);
                }
            }
        }
    }

    @SuppressFBWarnings(value={"IC_SUPERCLASS_USES_SUBCLASS_DURING_INITIALIZATION"}, justification="Safe initialization is implied")
    public static interface AttachmentProvider {
        public static final AttachmentProvider DEFAULT = new Compound(ForJigsawVm.INSTANCE, ForJ9Vm.INSTANCE, ForToolsJarVm.JVM_ROOT, ForToolsJarVm.JDK_ROOT, ForToolsJarVm.MACINTOSH, ForUnixHotSpotVm.INSTANCE);

        public Accessor attempt();

        public static class Compound
        implements AttachmentProvider {
            private final List<AttachmentProvider> attachmentProviders = new ArrayList<AttachmentProvider>();

            public Compound(AttachmentProvider ... attachmentProvider) {
                this(Arrays.asList(attachmentProvider));
            }

            public Compound(List<? extends AttachmentProvider> attachmentProviders) {
                for (AttachmentProvider attachmentProvider : attachmentProviders) {
                    if (attachmentProvider instanceof Compound) {
                        this.attachmentProviders.addAll(((Compound)attachmentProvider).attachmentProviders);
                        continue;
                    }
                    this.attachmentProviders.add(attachmentProvider);
                }
            }

            @Override
            public Accessor attempt() {
                for (AttachmentProvider attachmentProvider : this.attachmentProviders) {
                    Accessor accessor = attachmentProvider.attempt();
                    if (!accessor.isAvailable()) continue;
                    return accessor;
                }
                return Accessor.Unavailable.INSTANCE;
            }
        }

        public static enum ForUnixHotSpotVm implements AttachmentProvider
        {
            INSTANCE;


            @Override
            public Accessor attempt() {
                try {
                    return new Accessor.Simple.WithoutExternalAttachment(VirtualMachine.ForHotSpot.OnUnix.assertAvailability());
                }
                catch (Throwable ignored) {
                    return Accessor.Unavailable.INSTANCE;
                }
            }
        }

        public static enum ForToolsJarVm implements AttachmentProvider
        {
            JVM_ROOT("../lib/tools.jar"),
            JDK_ROOT("lib/tools.jar"),
            MACINTOSH("../Classes/classes.jar");

            private static final String JAVA_HOME_PROPERTY = "java.home";
            private final String toolsJarPath;

            private ForToolsJarVm(String toolsJarPath) {
                this.toolsJarPath = toolsJarPath;
            }

            @Override
            @SuppressFBWarnings(value={"DP_CREATE_CLASSLOADER_INSIDE_DO_PRIVILEGED"}, justification="Privilege is explicit user responsibility")
            public Accessor attempt() {
                File toolsJar = new File(System.getProperty("java.home"), this.toolsJarPath);
                try {
                    return toolsJar.isFile() && toolsJar.canRead() ? Accessor.Simple.of(new URLClassLoader(new URL[]{toolsJar.toURI().toURL()}, BOOTSTRAP_CLASS_LOADER), toolsJar) : Accessor.Unavailable.INSTANCE;
                }
                catch (MalformedURLException exception) {
                    throw new IllegalStateException("Could not represent " + toolsJar + " as URL");
                }
            }
        }

        public static enum ForJ9Vm implements AttachmentProvider
        {
            INSTANCE;


            @Override
            public Accessor attempt() {
                return Accessor.Simple.ofJ9();
            }
        }

        public static enum ForJigsawVm implements AttachmentProvider
        {
            INSTANCE;


            @Override
            public Accessor attempt() {
                return Accessor.Simple.of(ClassLoader.getSystemClassLoader(), new File[0]);
            }
        }

        public static interface Accessor {
            public static final String VIRTUAL_MACHINE_TYPE_NAME = "com.sun.tools.attach.VirtualMachine";
            public static final String VIRTUAL_MACHINE_TYPE_NAME_J9 = "com.ibm.tools.attach.VirtualMachine";

            public boolean isAvailable();

            public Class<?> getVirtualMachineType();

            public ExternalAttachment getExternalAttachment();

            public static abstract class Simple
            implements Accessor {
                protected final Class<?> virtualMachineType;

                protected Simple(Class<?> virtualMachineType) {
                    this.virtualMachineType = virtualMachineType;
                }

                public static Accessor of(ClassLoader classLoader, File ... classPath) {
                    try {
                        return new WithExternalAttachment(classLoader.loadClass(Accessor.VIRTUAL_MACHINE_TYPE_NAME), Arrays.asList(classPath));
                    }
                    catch (ClassNotFoundException ignored) {
                        return Unavailable.INSTANCE;
                    }
                }

                public static Accessor ofJ9() {
                    try {
                        return new WithExternalAttachment(ClassLoader.getSystemClassLoader().loadClass(Accessor.VIRTUAL_MACHINE_TYPE_NAME_J9), Collections.<File>emptyList());
                    }
                    catch (ClassNotFoundException ignored) {
                        return Unavailable.INSTANCE;
                    }
                }

                @Override
                public boolean isAvailable() {
                    return true;
                }

                @Override
                public Class<?> getVirtualMachineType() {
                    return this.virtualMachineType;
                }

                protected static class WithoutExternalAttachment
                extends Simple {
                    public WithoutExternalAttachment(Class<?> virtualMachineType) {
                        super(virtualMachineType);
                    }

                    @Override
                    public ExternalAttachment getExternalAttachment() {
                        throw new IllegalStateException("Cannot read the virtual machine type for an unavailable accessor");
                    }
                }

                protected static class WithExternalAttachment
                extends Simple {
                    private final List<File> classPath;

                    public WithExternalAttachment(Class<?> virtualMachineType, List<File> classPath) {
                        super(virtualMachineType);
                        this.classPath = classPath;
                    }

                    @Override
                    public ExternalAttachment getExternalAttachment() {
                        return new ExternalAttachment(this.virtualMachineType.getName(), this.classPath);
                    }
                }
            }

            public static class ExternalAttachment {
                private final String virtualMachineType;
                private final List<File> classPath;

                public ExternalAttachment(String virtualMachineType, List<File> classPath) {
                    this.virtualMachineType = virtualMachineType;
                    this.classPath = classPath;
                }

                public String getVirtualMachineType() {
                    return this.virtualMachineType;
                }

                public List<File> getClassPath() {
                    return this.classPath;
                }
            }

            public static enum Unavailable implements Accessor
            {
                INSTANCE;


                @Override
                public boolean isAvailable() {
                    return false;
                }

                @Override
                public Class<?> getVirtualMachineType() {
                    throw new IllegalStateException("Cannot read the virtual machine type for an unavailable accessor");
                }

                @Override
                public ExternalAttachment getExternalAttachment() {
                    throw new IllegalStateException("Cannot read the virtual machine type for an unavailable accessor");
                }
            }
        }
    }
}

