/*
 * Decompiled with CFR 0.152.
 */
package net.beardbot.nhentai.api.params;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import net.beardbot.nhentai.api.params.Category;
import net.beardbot.nhentai.api.params.Language;

public class Query {
    public static QueryBuilder builder() {
        return new QueryBuilder();
    }

    @Generated
    private Query() {
    }

    public static class QueryBuilder {
        private final List<String> includedParts = new ArrayList<String>();
        private final List<String> excludedParts = new ArrayList<String>();

        public String build() {
            StringBuilder sb = new StringBuilder();
            this.includedParts.forEach(s -> sb.append((String)s).append(" "));
            this.excludedParts.forEach(s -> sb.append("-").append((String)s).append(" "));
            return sb.toString().trim();
        }

        public QueryBuilder withKeyword(String keyword) {
            this.includedParts.add(QueryBuilder.createKeywordPart(keyword));
            return this;
        }

        public QueryBuilder withoutKeyword(String keyword) {
            this.excludedParts.add(QueryBuilder.createKeywordPart(keyword));
            return this;
        }

        public QueryBuilder withTag(String tag) {
            return this.withProperty("tag", tag);
        }

        public QueryBuilder withoutTag(String tag) {
            return this.withoutProperty("tag", tag);
        }

        public QueryBuilder withParody(String parody) {
            return this.withProperty("parodies", parody);
        }

        public QueryBuilder withoutParody(String parody) {
            return this.withoutProperty("parodies", parody);
        }

        public QueryBuilder withCharacter(String character) {
            return this.withProperty("character", character);
        }

        public QueryBuilder withoutCharacter(String character) {
            return this.withoutProperty("character", character);
        }

        public QueryBuilder withArtist(String artist) {
            return this.withProperty("artist", artist);
        }

        public QueryBuilder withoutArtist(String artist) {
            return this.withoutProperty("artist", artist);
        }

        public QueryBuilder withGroup(String group) {
            return this.withProperty("group", group);
        }

        public QueryBuilder withoutGroup(String group) {
            return this.withoutProperty("group", group);
        }

        public QueryBuilder withLanguage(Language language) {
            return this.withProperty("language", language.getValue());
        }

        public QueryBuilder withoutLanguage(Language language) {
            return this.withoutProperty("language", language.getValue());
        }

        public QueryBuilder withCategory(Category category) {
            return this.withProperty("category", category.getValue());
        }

        public QueryBuilder withoutCategory(Category category) {
            return this.withoutProperty("category", category.getValue());
        }

        public QueryBuilder withPages(Integer pages) {
            return this.withUnescapedProperty("pages", String.valueOf(pages));
        }

        public QueryBuilder withPagesMinimum(Integer pages) {
            return this.withUnescapedProperty("pages", ">" + (pages - 1));
        }

        public QueryBuilder withPagesMaximum(Integer pages) {
            return this.withUnescapedProperty("pages", "<=" + pages);
        }

        public QueryBuilder uploadedBefore(Duration duration) {
            return this.withUnescapedProperty("uploaded", ">" + this.durationToString(duration));
        }

        public QueryBuilder uploadedAfter(Duration duration) {
            return this.withUnescapedProperty("uploaded", "<" + this.durationToString(duration));
        }

        private QueryBuilder withProperty(String name, String value) {
            this.includedParts.add(QueryBuilder.createIncludedPropertyPart(name, value));
            return this;
        }

        private QueryBuilder withUnescapedProperty(String name, String value) {
            this.includedParts.add(QueryBuilder.createIncludedUnescapedPropertyPart(name, value));
            return this;
        }

        private QueryBuilder withoutProperty(String name, String value) {
            this.excludedParts.add(QueryBuilder.createExcludedPropertyPart(name, value));
            return this;
        }

        private static String createKeywordPart(String keyword) {
            return String.format("\"%s\"", keyword);
        }

        private static String createIncludedUnescapedPropertyPart(String name, String value) {
            return String.format("%s:%s", name, value);
        }

        private static String createIncludedPropertyPart(String name, String value) {
            return String.format("%s:\"%s\"", name, value);
        }

        private static String createExcludedPropertyPart(String name, String value) {
            return String.format("\"%s:%s\"", name, value);
        }

        private String durationToString(Duration duration) {
            long days = duration.toDays();
            long hours = duration.toHours();
            int hoursPart = duration.toHoursPart();
            if (days < 2L || hoursPart > 0) {
                return Math.max(hours, 2L) + "h";
            }
            return days + "d";
        }
    }
}

