/*
 * Decompiled with CFR 0.152.
 */
package net.beardbot.nhentai.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import net.beardbot.nhentai.NHentaiApiConfig;
import net.beardbot.nhentai.api.Tag;
import net.beardbot.nhentai.api.TagType;
import net.beardbot.nhentai.api.client.dto.TagDto;
import net.beardbot.nhentai.api.params.TagSearchParams;
import net.beardbot.nhentai.api.params.TagSortBy;
import org.jsoup.HttpStatusException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TagApi.class);
    private static final String TAGS_PATH = "/tags";
    private static final String PARODIES_PATH = "/parodies";
    private static final String ARTISTS_PATH = "/artists";
    private static final String CHARACTERS_PATH = "/characters";
    private static final String GROUPS_PATH = "/groups";
    private final NHentaiApiConfig apiConfig;

    public List<Tag> getAllTags() {
        return this.getAllTags(TagType.TAG, TAGS_PATH);
    }

    public List<Tag> getTags(TagSearchParams params) {
        return this.getTags(params, TagType.TAG, TAGS_PATH);
    }

    public List<Tag> getAllParodies() {
        return this.getAllTags(TagType.PARODY, PARODIES_PATH);
    }

    public List<Tag> getParodies(TagSearchParams params) {
        return this.getTags(params, TagType.PARODY, PARODIES_PATH);
    }

    public List<Tag> getAllArtists() {
        return this.getAllTags(TagType.ARTIST, ARTISTS_PATH);
    }

    public List<Tag> getArtists(TagSearchParams params) {
        return this.getTags(params, TagType.ARTIST, ARTISTS_PATH);
    }

    public List<Tag> getAllCharacters() {
        return this.getAllTags(TagType.CHARACTER, CHARACTERS_PATH);
    }

    public List<Tag> getCharacters(TagSearchParams params) {
        return this.getTags(params, TagType.CHARACTER, CHARACTERS_PATH);
    }

    public List<Tag> getAllGroups() {
        return this.getAllTags(TagType.GROUP, GROUPS_PATH);
    }

    public List<Tag> getGroups(TagSearchParams params) {
        return this.getTags(params, TagType.GROUP, GROUPS_PATH);
    }

    private List<Tag> getAllTags(TagType type, String basePath) {
        List<Tag> fetchedTags;
        int page = 1;
        ArrayList<Tag> tags = new ArrayList<Tag>();
        do {
            TagSearchParams params = TagSearchParams.builder().page(page).build();
            fetchedTags = this.getTagsWithRetry(params, type, basePath, this.apiConfig.getRequestMaxRetries());
            tags.addAll(fetchedTags);
            ++page;
            Thread.sleep(this.apiConfig.getRequestDelayMs());
        } while (!fetchedTags.isEmpty());
        return tags;
    }

    private List<Tag> getTagsWithRetry(TagSearchParams params, TagType type, String basePath, int maxRetries) {
        try {
            return this.getTags(params, type, basePath);
        }
        catch (HttpStatusException e) {
            if (e.getStatusCode() == 429 && maxRetries > 0) {
                int delay = this.apiConfig.getRequestRetryDelayMs();
                int retriesLeft = maxRetries - 1;
                log.debug("Too many request. Retrying in {}ms. Retries left: {}", (Object)delay, (Object)retriesLeft);
                Thread.sleep(delay);
                return this.getTagsWithRetry(params, type, basePath, retriesLeft);
            }
            throw e;
        }
    }

    private List<Tag> getTags(TagSearchParams params, TagType type, String basePath) throws IOException {
        log.debug("Fetching tags of type '{}' from page {}", (Object)type.getValue(), (Object)params.getPage());
        String additionalPath = params.getSortBy() == TagSortBy.POPULAR ? "/popular" : "";
        String url = String.format("%s%s%s?page=%d", this.apiConfig.getNHentaiBaseUrl(), basePath, additionalPath, params.getPage());
        Document document = Jsoup.connect((String)url).get();
        Elements tagElements = document.getElementsByClass("tag");
        return tagElements.stream().map(t -> TagApi.convertToTag(t, type)).collect(Collectors.toList());
    }

    private static Tag convertToTag(Element tagElement, TagType type) {
        String tagName = TagApi.extractTagName(tagElement);
        Long tagId = TagApi.extractTagId(tagElement);
        Long galleryCount = TagApi.extractGalleryCount(tagElement);
        String tagUrl = TagApi.extractUrl(tagElement);
        TagDto tagDto = new TagDto();
        tagDto.setId(tagId);
        tagDto.setName(tagName);
        tagDto.setGalleryCount(galleryCount);
        tagDto.setUrl(tagUrl);
        return new Tag(tagDto, type);
    }

    private static String extractTagName(Element tagElement) {
        return ((Element)tagElement.getElementsByClass("name").get(0)).text();
    }

    private static String extractUrl(Element tagElement) {
        return tagElement.attr("href");
    }

    private static Long extractTagId(Element tagElement) {
        return tagElement.classNames().stream().filter(c -> c.startsWith("tag-")).map(c -> c.replaceFirst("tag-", "")).map(Long::valueOf).findFirst().get();
    }

    private static Long extractGalleryCount(Element tagElement) {
        String countString = ((Element)tagElement.getElementsByClass("count").get(0)).text().toLowerCase();
        if (countString.contains("k")) {
            return Long.parseLong(countString.replace("k", "")) * 1000L;
        }
        return Long.parseLong(countString);
    }

    @Generated
    public TagApi(NHentaiApiConfig apiConfig) {
        this.apiConfig = apiConfig;
    }
}

