/*
 * Decompiled with CFR 0.152.
 */
package net.beardbot.nhentai.api;

import feign.Feign;
import feign.codec.Decoder;
import feign.jackson.JacksonDecoder;
import feign.optionals.OptionalDecoder;
import java.net.HttpURLConnection;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.beardbot.nhentai.NHentaiApiConfig;
import net.beardbot.nhentai.api.Comment;
import net.beardbot.nhentai.api.Gallery;
import net.beardbot.nhentai.api.GalleryPage;
import net.beardbot.nhentai.api.Image;
import net.beardbot.nhentai.api.SearchResult;
import net.beardbot.nhentai.api.Tag;
import net.beardbot.nhentai.api.TagType;
import net.beardbot.nhentai.api.User;
import net.beardbot.nhentai.api.client.GalleryClient;
import net.beardbot.nhentai.api.client.dto.GalleryCommentDto;
import net.beardbot.nhentai.api.client.dto.GalleryDto;
import net.beardbot.nhentai.api.client.dto.ImageInfoDto;
import net.beardbot.nhentai.api.client.dto.SearchResultDto;
import net.beardbot.nhentai.api.client.dto.TagDto;
import net.beardbot.nhentai.api.client.dto.UserDto;
import net.beardbot.nhentai.api.params.SearchParams;

public class GalleryApi {
    private final NHentaiApiConfig apiConfig;
    private final GalleryClient galleryClient;

    public GalleryApi(NHentaiApiConfig apiConfig) {
        this.apiConfig = apiConfig;
        this.galleryClient = (GalleryClient)Feign.builder().decoder((Decoder)new OptionalDecoder((Decoder)new JacksonDecoder())).decode404().target(GalleryClient.class, apiConfig.getApiBaseUrl());
    }

    public SearchResult search(String query) {
        return this.search(query, SearchParams.builder().build());
    }

    public SearchResult search(String query, SearchParams searchParams) {
        SearchResultDto resultDto = this.galleryClient.search(query, searchParams.getPage(), searchParams.getSortBy().getValue());
        return this.convert(resultDto, page -> this.search(query, SearchParams.builder().page((int)page).sortBy(searchParams.getSortBy()).build()).getGalleries());
    }

    public SearchResult searchByTag(Tag tag) {
        return this.searchByTagId(tag.getId());
    }

    public SearchResult searchByTag(Tag tag, SearchParams searchParams) {
        return this.searchByTagId(tag.getId(), searchParams);
    }

    public SearchResult searchByTagId(long tagId) {
        return this.searchByTagId(tagId, SearchParams.builder().build());
    }

    public SearchResult searchByTagId(long tagId, SearchParams searchParams) {
        SearchResultDto resultDto = this.galleryClient.searchByTagId(tagId, searchParams.getPage(), searchParams.getSortBy().getValue());
        return this.convert(resultDto, page -> this.searchByTagId(tagId, SearchParams.builder().page((int)page).sortBy(searchParams.getSortBy()).build()).getGalleries());
    }

    public Optional<Gallery> getGallery(long galleryId) {
        Optional<GalleryDto> galleryDto = this.galleryClient.getGallery(galleryId);
        return galleryDto.map(this::convert);
    }

    public Gallery getRandomGallery() {
        String randomUrl = this.apiConfig.getNHentaiBaseUrl() + "/random/";
        HttpURLConnection connection = (HttpURLConnection)URI.create(randomUrl).toURL().openConnection();
        connection.setInstanceFollowRedirects(false);
        String redirectLocation = connection.getHeaderField("Location");
        long galleryId = Long.parseLong(redirectLocation.replace("/", "").substring(1));
        return this.getGallery(galleryId).get();
    }

    private SearchResult convert(SearchResultDto searchResultDto, Function<Integer, List<Gallery>> pageResultSupplier) {
        List<Gallery> pageResult = searchResultDto.getPageResult().stream().map(this::convert).collect(Collectors.toList());
        return new SearchResult(searchResultDto, pageResult, pageResultSupplier);
    }

    private Gallery convert(GalleryDto galleryDto) {
        List<GalleryPage> pages = this.convertToPages(galleryDto);
        Image cover = this.getGalleryCover(galleryDto);
        Image thumbnail = this.getGalleryThumbnail(galleryDto);
        List<Tag> tags = galleryDto.getTagDtos().stream().map(this::convert).collect(Collectors.toList());
        return new Gallery(galleryDto, pages, tags, cover, thumbnail, () -> this.getRelatedGalleries(galleryDto.getId()), () -> this.getGalleryComments(galleryDto.getId()));
    }

    private Tag convert(TagDto tagDto) {
        return new Tag(tagDto, TagType.of(tagDto.getType()));
    }

    private List<GalleryPage> convertToPages(GalleryDto galleryDto) {
        ArrayList<GalleryPage> pages = new ArrayList<GalleryPage>();
        List<ImageInfoDto> pagesImages = galleryDto.getImageInfo().getPages();
        for (int pageNumber = 1; pageNumber <= pagesImages.size(); ++pageNumber) {
            Image image = this.getGalleryPage(galleryDto, pageNumber);
            pages.add(new GalleryPage(image, pageNumber));
        }
        return pages;
    }

    private Comment convert(GalleryCommentDto galleryCommentDto) {
        User user = this.convert(galleryCommentDto.getPoster());
        return new Comment(galleryCommentDto, user);
    }

    private User convert(UserDto userDto) {
        Image image = this.getAvatarImage(userDto.getAvatarUrl());
        return new User(userDto, image);
    }

    private Image getAvatarImage(String avatarUrl) {
        String url = String.format("%s/%s", this.apiConfig.getImageBaseUrl(), avatarUrl);
        String extension = url.substring(url.lastIndexOf(".") + 1);
        return new Image(url, extension, 0, 0);
    }

    private Image getGalleryCover(GalleryDto galleryDto) {
        ImageInfoDto imageInfo = galleryDto.getImageInfo().getCover();
        String extension = imageInfo.getImageType().getExtension();
        String url = String.format("%s/galleries/%s/cover.%s", this.apiConfig.getThumbnailBaseUrl(), galleryDto.getMediaId(), extension);
        return new Image(url, extension, imageInfo.getWidth(), imageInfo.getHeight());
    }

    private Image getGalleryThumbnail(GalleryDto galleryDto) {
        ImageInfoDto imageInfo = galleryDto.getImageInfo().getThumbnail();
        String extension = imageInfo.getImageType().getExtension();
        String url = String.format("%s/galleries/%s/thumb.%s", this.apiConfig.getThumbnailBaseUrl(), galleryDto.getMediaId(), extension);
        return new Image(url, extension, imageInfo.getWidth(), imageInfo.getHeight());
    }

    private Image getGalleryPage(GalleryDto galleryDto, int page) {
        return this.getGalleryPage(galleryDto.getImageInfo().getPages().get(page - 1), galleryDto.getMediaId(), page);
    }

    private Image getGalleryPage(ImageInfoDto imageInfoDto, String mediaId, int page) {
        String extension = imageInfoDto.getImageType().getExtension();
        String url = String.format("%s/galleries/%s/%d.%s", this.apiConfig.getImageBaseUrl(), mediaId, page, extension);
        return new Image(url, extension, imageInfoDto.getWidth(), imageInfoDto.getHeight());
    }

    private List<Gallery> getRelatedGalleries(long galleryId) {
        return this.galleryClient.getRelatedGalleries(galleryId).getResult().stream().map(this::convert).collect(Collectors.toList());
    }

    private List<Comment> getGalleryComments(long galleryId) {
        return this.galleryClient.getGalleryComments(galleryId).stream().map(this::convert).collect(Collectors.toList());
    }
}

