/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.mysqla;

import com.mysql.cj.api.MysqlConnection;
import com.mysql.cj.api.ProfilerEventHandler;
import com.mysql.cj.api.Session;
import com.mysql.cj.api.conf.ModifiableProperty;
import com.mysql.cj.api.conf.PropertySet;
import com.mysql.cj.api.io.SocketFactory;
import com.mysql.cj.api.jdbc.JdbcConnection;
import com.mysql.cj.api.jdbc.Statement;
import com.mysql.cj.api.jdbc.interceptors.StatementInterceptorV2;
import com.mysql.cj.api.mysqla.io.NativeProtocol;
import com.mysql.cj.api.mysqla.io.PacketPayload;
import com.mysql.cj.api.mysqla.result.Resultset;
import com.mysql.cj.core.AbstractSession;
import com.mysql.cj.core.ConnectionString;
import com.mysql.cj.core.Messages;
import com.mysql.cj.core.ServerVersion;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.exceptions.WrongArgumentException;
import com.mysql.cj.core.io.NetworkResources;
import com.mysql.cj.core.log.LogFactory;
import com.mysql.cj.core.profiler.ProfilerEventHandlerFactory;
import com.mysql.cj.core.result.Field;
import com.mysql.cj.core.util.StringUtils;
import com.mysql.cj.jdbc.MysqlIO;
import com.mysql.cj.jdbc.StatementImpl;
import com.mysql.cj.jdbc.util.TimeUtil;
import com.mysql.cj.mysqla.io.MysqlaProtocol;
import com.mysql.cj.mysqla.io.MysqlaServerSession;
import com.mysql.cj.mysqla.io.MysqlaSocketConnection;
import java.io.IOException;
import java.io.Serializable;
import java.net.SocketAddress;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.Executor;

public class MysqlaSession
extends AbstractSession
implements Session,
Serializable {
    private static final long serialVersionUID = 5323638898749073419L;
    protected transient MysqlaProtocol protocol;
    private TimeZone serverTimezoneTZ = null;
    private TimeZone defaultTimeZone = TimeZone.getDefault();
    private int sessionMaxRows = -1;
    private ConnectionString.HostInfo hostInfo = null;
    private String hostToConnectTo = "localhost";
    private int portToConnectTo = 3306;
    protected ModifiableProperty<Integer> socketTimeout;
    private boolean serverHasFracSecsSupport = true;

    public MysqlaSession(ConnectionString connectionString, String hostToConnectTo, int portToConnectTo, Properties info, PropertySet propSet) {
        this.propertySet = propSet;
        this.hostToConnectTo = hostToConnectTo;
        this.portToConnectTo = portToConnectTo;
        this.socketTimeout = this.getPropertySet().getModifiableProperty("socketTimeout");
        this.hostInfo = connectionString.getHostInfo(this.propertySet, this.hostToConnectTo, this.portToConnectTo, info);
        this.log = LogFactory.getLogger(this.getPropertySet().getStringReadableProperty("logger").getStringValue(), "MySQL", this.getExceptionInterceptor());
        if (ConnectionString.isHostPropertiesList(hostToConnectTo)) {
            Properties hostSpecificProps = ConnectionString.expandHostKeyValues(hostToConnectTo);
            Enumeration<?> propertyNames = hostSpecificProps.propertyNames();
            while (propertyNames.hasMoreElements()) {
                String propertyName = propertyNames.nextElement().toString();
                String propertyValue = hostSpecificProps.getProperty(propertyName);
                info.setProperty(propertyName, propertyValue);
            }
        }
    }

    public void connect(MysqlConnection conn, ConnectionString connectionString, Properties mergedProps, String user, String password, String database, int loginTimeout) throws IOException {
        this.hostInfo = connectionString.getHostInfo(this.propertySet, this.hostToConnectTo, this.portToConnectTo, mergedProps);
        this.setSessionMaxRows(-1);
        MysqlaSocketConnection socketConnection = new MysqlaSocketConnection();
        socketConnection.connect(this.hostInfo.getHost(), this.hostInfo.getPort(), mergedProps, this.getPropertySet(), this.getExceptionInterceptor(), this.log, loginTimeout);
        this.protocol = MysqlaProtocol.getInstance(conn, socketConnection, this.propertySet, this.log);
        this.protocol.connect(user, password, database);
        this.serverHasFracSecsSupport = this.protocol.versionMeetsMinimum(5, 6, 4);
        this.setErrorMessageEncoding(this.protocol.getAuthenticationProvider().getEncodingForHandshake());
    }

    public MysqlaProtocol getProtocol() {
        return this.protocol;
    }

    @Override
    public void changeUser(String userName, String password, String database) {
        this.sessionMaxRows = -1;
        this.protocol.changeUser(userName, password, database);
    }

    @Override
    public boolean characterSetNamesMatches(String mysqlEncodingName) {
        return this.protocol.getServerSession().characterSetNamesMatches(mysqlEncodingName);
    }

    @Override
    public String getServerVariable(String name) {
        return this.protocol.getServerSession().getServerVariable(name);
    }

    @Override
    public int getServerVariable(String variableName, int fallbackValue) {
        try {
            return Integer.valueOf(this.getServerVariable(variableName));
        }
        catch (NumberFormatException nfe) {
            this.getLog().logWarn(Messages.getString("Connection.BadValueInServerVariables", new Object[]{variableName, this.getServerVariable(variableName), fallbackValue}));
            return fallbackValue;
        }
    }

    @Override
    public boolean inTransactionOnServer() {
        return this.protocol.getServerSession().inTransactionOnServer();
    }

    @Override
    public int getServerDefaultCollationIndex() {
        return this.protocol.getServerSession().getServerDefaultCollationIndex();
    }

    @Override
    public void setServerDefaultCollationIndex(int serverDefaultCollationIndex) {
        this.protocol.getServerSession().setServerDefaultCollationIndex(serverDefaultCollationIndex);
    }

    @Override
    public Map<String, String> getServerVariables() {
        return this.protocol.getServerSession().getServerVariables();
    }

    @Override
    public void setServerVariables(Map<String, String> serverVariables) {
        this.protocol.getServerSession().setServerVariables(serverVariables);
    }

    @Override
    public void abortInternal() {
        if (this.protocol != null) {
            try {
                this.protocol.getSocketConnection().forceClose();
                this.protocol.releaseResources();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public void quit() {
        if (this.protocol != null) {
            try {
                this.protocol.quit();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void forceClose() {
        this.abortInternal();
    }

    @Override
    public ServerVersion getServerVersion() {
        return this.protocol.getServerSession().getServerVersion();
    }

    @Override
    public boolean versionMeetsMinimum(int major, int minor, int subminor) {
        return this.protocol.versionMeetsMinimum(major, minor, subminor);
    }

    public void enableMultiQueries() {
        PacketPayload buf = this.protocol.getSharedSendPacket();
        buf.writeInteger(NativeProtocol.IntegerDataType.INT1, 27L);
        buf.writeInteger(NativeProtocol.IntegerDataType.INT2, 0L);
        this.sendCommand(27, null, buf, false, null, 0);
    }

    public void disableMultiQueries() {
        PacketPayload buf = this.protocol.getSharedSendPacket();
        buf.writeInteger(NativeProtocol.IntegerDataType.INT1, 27L);
        buf.writeInteger(NativeProtocol.IntegerDataType.INT2, 1L);
        this.sendCommand(27, null, buf, false, null, 0);
    }

    @Override
    public long getThreadId() {
        return this.protocol.getServerSession().getCapabilities().getThreadId();
    }

    @Override
    public boolean isSetNeededForAutoCommitMode(boolean autoCommitFlag) {
        return this.protocol.getServerSession().isSetNeededForAutoCommitMode(autoCommitFlag, this.getPropertySet().getBooleanReadableProperty("elideSetAutoCommits").getValue());
    }

    @Override
    public void configureTimezone() {
        String configuredTimeZoneOnServer = this.getServerVariable("time_zone");
        if ("SYSTEM".equalsIgnoreCase(configuredTimeZoneOnServer)) {
            configuredTimeZoneOnServer = this.getServerVariable("system_time_zone");
        }
        String canonicalTimezone = this.getPropertySet().getStringReadableProperty("serverTimezone").getValue();
        if (configuredTimeZoneOnServer != null && (canonicalTimezone == null || StringUtils.isEmptyOrWhitespaceOnly(canonicalTimezone))) {
            try {
                canonicalTimezone = TimeUtil.getCanonicalTimezone(configuredTimeZoneOnServer, this.getExceptionInterceptor());
            }
            catch (IllegalArgumentException iae) {
                throw ExceptionFactory.createException(WrongArgumentException.class, iae.getMessage(), this.getExceptionInterceptor());
            }
        }
        if (canonicalTimezone != null && canonicalTimezone.length() > 0) {
            this.serverTimezoneTZ = TimeZone.getTimeZone(canonicalTimezone);
            if (!canonicalTimezone.equalsIgnoreCase("GMT") && this.serverTimezoneTZ.getID().equals("GMT")) {
                throw ExceptionFactory.createException(WrongArgumentException.class, Messages.getString("Connection.9", new Object[]{canonicalTimezone}), this.getExceptionInterceptor());
            }
        }
        this.defaultTimeZone = this.serverTimezoneTZ;
    }

    @Override
    public TimeZone getDefaultTimeZone() {
        return this.defaultTimeZone;
    }

    @Override
    public String getErrorMessageEncoding() {
        return this.protocol.getServerSession().getErrorMessageEncoding();
    }

    @Override
    public void setErrorMessageEncoding(String errorMessageEncoding) {
        this.protocol.getServerSession().setErrorMessageEncoding(errorMessageEncoding);
    }

    public String getServerCharset() {
        return this.protocol.getServerSession().getServerDefaultCharset();
    }

    @Override
    public int getMaxBytesPerChar(String javaCharsetName) {
        return this.protocol.getServerSession().getMaxBytesPerChar(javaCharsetName);
    }

    @Override
    public int getMaxBytesPerChar(Integer charsetIndex, String javaCharsetName) {
        return this.protocol.getServerSession().getMaxBytesPerChar(charsetIndex, javaCharsetName);
    }

    @Override
    public String getEncodingForIndex(int charsetIndex) {
        return this.protocol.getServerSession().getEncodingForIndex(charsetIndex);
    }

    public int getSessionMaxRows() {
        return this.sessionMaxRows;
    }

    public void setSessionMaxRows(int sessionMaxRows) {
        this.sessionMaxRows = sessionMaxRows;
    }

    public ConnectionString.HostInfo getHostInfo() {
        return this.hostInfo;
    }

    public void setCharsetMaps(Map<Integer, String> indexToCharset, Map<Integer, String> customCharset, Map<String, Integer> customMblen) {
        this.protocol.getServerSession().indexToMysqlCharset = Collections.unmodifiableMap(indexToCharset);
        if (customCharset != null) {
            this.protocol.getServerSession().indexToCustomMysqlCharset = Collections.unmodifiableMap(customCharset);
        }
        if (customMblen != null) {
            this.protocol.getServerSession().mysqlCharsetToCustomMblen = Collections.unmodifiableMap(customMblen);
        }
    }

    public void setStatementInterceptors(List<StatementInterceptorV2> statementInterceptors) {
        this.protocol.setStatementInterceptors(statementInterceptors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isServerLocal(JdbcConnection conn) {
        Object object = conn.getConnectionMutex();
        synchronized (object) {
            SocketFactory factory = this.protocol.getSocketConnection().getSocketFactory();
            return factory.isLocallyConnected(conn);
        }
    }

    public void shutdownServer() throws SQLException {
        this.sendCommand(8, null, null, false, null, 0);
    }

    public void setSocketTimeout(Executor executor, final int milliseconds) {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                MysqlaSession.this.socketTimeout.setValue(milliseconds);
                MysqlaSession.this.protocol.setSocketTimeout(milliseconds);
            }
        });
    }

    public int getSocketTimeout() {
        return (Integer)this.socketTimeout.getValue();
    }

    public final <T extends Resultset> T sqlQueryDirect(StatementImpl callingStatement, String query, String characterEncoding, PacketPayload queryPacket, int maxRows, int resultSetType, int resultSetConcurrency, boolean streamResults, String catalog, Field[] cachedMetadata) {
        return this.protocol.sqlQueryDirect(callingStatement, query, characterEncoding, queryPacket, maxRows, resultSetType, resultSetConcurrency, streamResults, catalog, cachedMetadata, this::getProfilerEventHandlerInstanceFunction);
    }

    public void checkForCharsetMismatch() {
        this.protocol.checkForCharsetMismatch();
    }

    public PacketPayload getSharedSendPacket() {
        return this.protocol.getSharedSendPacket();
    }

    public void dumpPacketRingBuffer() {
        this.protocol.dumpPacketRingBuffer();
    }

    public <T extends Resultset> T invokeStatementInterceptorsPre(String sql, Statement interceptedStatement, boolean forceExecute) {
        return this.protocol.invokeStatementInterceptorsPre(sql, interceptedStatement, forceExecute);
    }

    public <T extends Resultset> T invokeStatementInterceptorsPost(String sql, Statement interceptedStatement, T originalResultSet, boolean forceExecute, Exception statementException) {
        return this.protocol.invokeStatementInterceptorsPost(sql, interceptedStatement, originalResultSet, forceExecute, statementException);
    }

    public boolean shouldIntercept() {
        return this.protocol.getStatementInterceptors() != null;
    }

    public long getCurrentTimeNanosOrMillis() {
        return this.protocol.getCurrentTimeNanosOrMillis();
    }

    public final PacketPayload sendCommand(int command, String extraData, PacketPayload queryPacket, boolean skipCheck, String extraDataCharEncoding, int timeoutMillis) {
        return this.protocol.sendCommand(command, extraData, queryPacket, skipCheck, extraDataCharEncoding, timeoutMillis);
    }

    public long getSlowQueryThreshold() {
        return this.protocol.getSlowQueryThreshold();
    }

    public String getQueryTimingUnits() {
        return this.protocol.getQueryTimingUnits();
    }

    public MysqlIO getResultsHandler() {
        return this.protocol.getResultsHandler();
    }

    public void explainSlowQuery(byte[] querySQL, String truncatedQuery) {
        this.protocol.explainSlowQuery(querySQL, truncatedQuery);
    }

    public boolean hadWarnings() {
        return this.protocol.hadWarnings();
    }

    public void clearInputStream() {
        this.protocol.clearInputStream();
    }

    public final PacketPayload readPacket() {
        return this.protocol.readPacket(null);
    }

    public NetworkResources getNetworkResources() {
        return this.protocol.getSocketConnection().getNetworkResources();
    }

    @Override
    public MysqlaServerSession getServerSession() {
        return this.protocol.getServerSession();
    }

    @Override
    public boolean isSSLEstablished() {
        return this.protocol.getSocketConnection().isSSLEstablished();
    }

    public int getCommandCount() {
        return this.protocol.getCommandCount();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.protocol.getSocketConnection().getMysqlSocket().getRemoteSocketAddress();
    }

    @Override
    public boolean serverSupportsFracSecs() {
        return this.serverHasFracSecsSupport;
    }

    public ProfilerEventHandler getProfilerEventHandlerInstanceFunction() {
        return ProfilerEventHandlerFactory.getInstance(this);
    }
}

