/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.fabric.jdbc;

import com.mysql.cj.api.MysqlConnection;
import com.mysql.cj.api.ProfilerEventHandler;
import com.mysql.cj.api.exceptions.ExceptionInterceptor;
import com.mysql.cj.api.fabric.FabricMysqlConnection;
import com.mysql.cj.api.jdbc.ClientInfoProvider;
import com.mysql.cj.api.jdbc.JdbcConnection;
import com.mysql.cj.api.jdbc.ha.ReplicationConnection;
import com.mysql.cj.api.jdbc.interceptors.StatementInterceptorV2;
import com.mysql.cj.api.jdbc.result.ResultSetInternalMethods;
import com.mysql.cj.api.log.Log;
import com.mysql.cj.api.mysqla.io.PacketPayload;
import com.mysql.cj.core.ConnectionString;
import com.mysql.cj.core.ServerVersion;
import com.mysql.cj.core.exceptions.CJException;
import com.mysql.cj.core.exceptions.ExceptionFactory;
import com.mysql.cj.core.exceptions.UnableToConnectException;
import com.mysql.cj.core.log.LogFactory;
import com.mysql.cj.core.result.Field;
import com.mysql.cj.fabric.FabricConnection;
import com.mysql.cj.fabric.Server;
import com.mysql.cj.fabric.ServerGroup;
import com.mysql.cj.fabric.ShardMapping;
import com.mysql.cj.fabric.exceptions.FabricCommunicationException;
import com.mysql.cj.fabric.jdbc.ErrorReportingExceptionInterceptor;
import com.mysql.cj.jdbc.AbstractJdbcConnection;
import com.mysql.cj.jdbc.ServerPreparedStatement;
import com.mysql.cj.jdbc.StatementImpl;
import com.mysql.cj.jdbc.exceptions.SQLError;
import com.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import com.mysql.cj.jdbc.ha.ReplicationConnectionGroup;
import com.mysql.cj.jdbc.ha.ReplicationConnectionGroupManager;
import com.mysql.cj.jdbc.ha.ReplicationConnectionProxy;
import com.mysql.cj.jdbc.result.CachedResultSetMetaData;
import com.mysql.cj.mysqla.MysqlaSession;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.Timer;
import java.util.concurrent.Executor;

public class FabricMySQLConnectionProxy
extends AbstractJdbcConnection
implements FabricMysqlConnection {
    private static final long serialVersionUID = -6276256222880055706L;
    private Log log;
    protected FabricConnection fabricConnection;
    protected boolean closed = false;
    protected boolean transactionInProgress = false;
    protected Map<ServerGroup, ReplicationConnection> serverConnections = new HashMap<ServerGroup, ReplicationConnection>();
    protected ReplicationConnection currentConnection;
    protected String shardKey;
    protected String shardTable;
    protected String serverGroupName;
    protected Set<String> queryTables = new HashSet<String>();
    protected ServerGroup serverGroup;
    protected String host;
    protected String port;
    protected String username;
    protected String password;
    protected String database;
    protected ShardMapping shardMapping;
    protected boolean readOnly = false;
    protected boolean autoCommit = true;
    protected int transactionIsolation = 4;
    private String fabricShardKey;
    private String fabricShardTable;
    private String fabricServerGroup;
    private String fabricProtocol;
    private String fabricUsername;
    private String fabricPassword;
    private boolean reportErrors = false;
    protected ConnectionString connectionString;
    private static final Set<String> replConnGroupLocks = Collections.synchronizedSet(new HashSet());

    public FabricMySQLConnectionProxy(ConnectionString connectionString) throws SQLException {
        String exceptionInterceptors;
        this.connectionString = connectionString;
        Properties props = connectionString.getProperties();
        this.fabricShardKey = props.getProperty("fabricShardKey");
        this.fabricShardTable = props.getProperty("fabricShardTable");
        this.fabricServerGroup = props.getProperty("fabricServerGroup");
        this.fabricProtocol = props.getProperty("fabricProtocol");
        this.fabricUsername = props.getProperty("fabricUsername");
        this.fabricPassword = props.getProperty("fabricPassword");
        this.reportErrors = Boolean.valueOf(props.getProperty("fabricReportErrors"));
        props.remove("fabricShardKey");
        props.remove("fabricShardTable");
        props.remove("fabricServerGroup");
        props.remove("fabricProtocol");
        props.remove("fabricUsername");
        props.remove("fabricPassword");
        props.remove("fabricReportErrors");
        this.host = props.getProperty("HOST");
        this.port = props.getProperty("PORT");
        this.username = props.getProperty("user");
        this.password = props.getProperty("password");
        this.database = props.getProperty("DBNAME");
        if (this.username == null) {
            this.username = "";
        }
        if (this.password == null) {
            this.password = "";
        }
        exceptionInterceptors = (exceptionInterceptors = props.getProperty("exceptionInterceptors")) == null || "null".equals("exceptionInterceptors") ? "" : exceptionInterceptors + ",";
        exceptionInterceptors = exceptionInterceptors + ErrorReportingExceptionInterceptor.class.getName();
        props.setProperty("exceptionInterceptors", exceptionInterceptors);
        this.getPropertySet().initializeProperties(props);
        if (this.fabricServerGroup != null && this.fabricShardTable != null) {
            throw SQLError.createSQLException("Server group and shard table are mutually exclusive. Only one may be provided.", "08004", null, this.getExceptionInterceptor(), this);
        }
        try {
            String url = this.fabricProtocol + "://" + this.host + ":" + this.port;
            this.fabricConnection = new FabricConnection(url, this.fabricUsername, this.fabricPassword);
        }
        catch (FabricCommunicationException ex) {
            throw SQLError.createSQLException("Unable to establish connection to the Fabric server", "08004", ex, this.getExceptionInterceptor(), this);
        }
        this.log = LogFactory.getLogger(this.getPropertySet().getStringReadableProperty("logger").getStringValue(), "FabricMySQLConnectionProxy", null);
        this.setShardTable(this.fabricShardTable);
        this.setShardKey(this.fabricShardKey);
        this.setServerGroupName(this.fabricServerGroup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized SQLException interceptException(Exception sqlEx, MysqlConnection conn, String groupName, String hostname, String portNumber) throws FabricCommunicationException {
        block12: {
            if (!(sqlEx instanceof SQLException) || ((SQLException)sqlEx).getSQLState() == null || !((SQLException)sqlEx).getSQLState().startsWith("08") && !SQLNonTransientConnectionException.class.isAssignableFrom(sqlEx.getClass())) {
                return null;
            }
            Server currentServer = this.serverGroup.getServer(hostname + ":" + portNumber);
            if (currentServer == null) {
                return null;
            }
            if (this.reportErrors) {
                this.fabricConnection.getClient().reportServerError(currentServer, sqlEx.toString(), true);
            }
            if (replConnGroupLocks.add(this.serverGroup.getName())) {
                try {
                    try {
                        this.fabricConnection.refreshState();
                        this.setCurrentServerGroup(this.serverGroup.getName());
                    }
                    catch (SQLException ex) {
                        SQLException sQLException = SQLError.createSQLException("Unable to refresh Fabric state. Failover impossible", "08006", ex, null);
                        replConnGroupLocks.remove(this.serverGroup.getName());
                        return sQLException;
                    }
                    try {
                        this.syncGroupServersToReplicationConnectionGroup(ReplicationConnectionGroupManager.getConnectionGroup(groupName));
                        break block12;
                    }
                    catch (SQLException ex) {
                        SQLException sQLException = ex;
                        replConnGroupLocks.remove(this.serverGroup.getName());
                        return sQLException;
                    }
                }
                finally {
                    replConnGroupLocks.remove(this.serverGroup.getName());
                }
            }
            return SQLError.createSQLException("Fabric state syncing already in progress in another thread.", "08006", sqlEx, null);
        }
        return null;
    }

    private void refreshStateIfNecessary() throws SQLException {
        if (this.fabricConnection.isStateExpired()) {
            try {
                this.fabricConnection.refreshState();
            }
            catch (FabricCommunicationException ex) {
                throw SQLError.createSQLException("Unable to establish connection to the Fabric server", "08004", ex, this.getExceptionInterceptor(), this);
            }
            if (this.serverGroup != null) {
                this.setCurrentServerGroup(this.serverGroup.getName());
            }
        }
    }

    @Override
    public void setShardKey(String shardKey) throws SQLException {
        try {
            this.ensureNoTransactionInProgress();
            this.currentConnection = null;
            if (shardKey != null) {
                if (this.serverGroupName != null) {
                    throw SQLError.createSQLException("Shard key cannot be provided when server group is chosen directly.", "S1009", null, this.getExceptionInterceptor(), this);
                }
                if (this.shardTable == null) {
                    throw SQLError.createSQLException("Shard key cannot be provided without a shard table.", "S1009", null, this.getExceptionInterceptor(), this);
                }
                this.setCurrentServerGroup(this.shardMapping.getGroupNameForKey(shardKey));
            } else if (this.shardTable != null) {
                this.setCurrentServerGroup(this.shardMapping.getGlobalGroupName());
            }
            this.shardKey = shardKey;
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getShardKey() {
        return this.shardKey;
    }

    @Override
    public void setShardTable(String shardTable) throws SQLException {
        try {
            this.ensureNoTransactionInProgress();
            this.currentConnection = null;
            if (this.serverGroupName != null) {
                throw SQLError.createSQLException("Server group and shard table are mutually exclusive. Only one may be provided.", "S1009", null, this.getExceptionInterceptor(), this);
            }
            this.shardKey = null;
            this.serverGroup = null;
            this.shardTable = shardTable;
            if (shardTable == null) {
                this.shardMapping = null;
            } else {
                String table = shardTable;
                String db = this.database;
                if (shardTable.contains(".")) {
                    String[] pair = shardTable.split("\\.");
                    table = pair[0];
                    db = pair[1];
                }
                try {
                    this.shardMapping = this.fabricConnection.getShardMapping(db, table);
                    if (this.shardMapping == null) {
                        throw SQLError.createSQLException("Shard mapping not found for table `" + shardTable + "'", "S1009", null, this.getExceptionInterceptor(), this);
                    }
                    this.setCurrentServerGroup(this.shardMapping.getGlobalGroupName());
                }
                catch (FabricCommunicationException ex) {
                    throw SQLError.createSQLException("Fabric communication failure.", "08S01", ex, this.getExceptionInterceptor(), this);
                }
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getShardTable() {
        return this.shardTable;
    }

    @Override
    public void setServerGroupName(String serverGroupName) throws SQLException {
        try {
            this.ensureNoTransactionInProgress();
            this.currentConnection = null;
            if (serverGroupName != null) {
                this.setCurrentServerGroup(serverGroupName);
            }
            this.serverGroupName = serverGroupName;
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getServerGroupName() {
        return this.serverGroupName;
    }

    @Override
    public void clearServerSelectionCriteria() throws SQLException {
        try {
            this.ensureNoTransactionInProgress();
            this.shardTable = null;
            this.shardKey = null;
            this.serverGroupName = null;
            this.serverGroup = null;
            this.queryTables.clear();
            this.currentConnection = null;
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ServerGroup getCurrentServerGroup() {
        return this.serverGroup;
    }

    @Override
    public void clearQueryTables() throws SQLException {
        try {
            this.ensureNoTransactionInProgress();
            this.currentConnection = null;
            this.queryTables.clear();
            this.setShardTable(null);
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void addQueryTable(String tableName) throws SQLException {
        try {
            this.ensureNoTransactionInProgress();
            this.currentConnection = null;
            try {
                if (this.shardMapping == null) {
                    if (this.fabricConnection.getShardMapping(this.database, tableName) != null) {
                        this.setShardTable(tableName);
                    }
                } else {
                    ShardMapping mappingForTableName = this.fabricConnection.getShardMapping(this.database, tableName);
                    if (mappingForTableName != null && !mappingForTableName.equals(this.shardMapping)) {
                        throw SQLError.createSQLException("Cross-shard query not allowed", "S1009", null, this.getExceptionInterceptor(), this);
                    }
                }
                this.queryTables.add(tableName);
            }
            catch (FabricCommunicationException ex) {
                throw SQLError.createSQLException("Fabric communication failure.", "08S01", ex, this.getExceptionInterceptor(), this);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public Set<String> getQueryTables() {
        return this.queryTables;
    }

    protected void setCurrentServerGroup(String serverGroupName) throws SQLException {
        this.serverGroup = null;
        try {
            this.serverGroup = this.fabricConnection.getServerGroup(serverGroupName);
        }
        catch (FabricCommunicationException ex) {
            throw SQLError.createSQLException("Fabric communication failure.", "08S01", ex, this.getExceptionInterceptor(), this);
        }
        if (this.serverGroup == null) {
            throw SQLError.createSQLException("Cannot find server group: `" + serverGroupName + "'", "S1009", null, this.getExceptionInterceptor(), this);
        }
        ReplicationConnectionGroup replConnGroup = ReplicationConnectionGroupManager.getConnectionGroup(serverGroupName);
        if (replConnGroup != null && replConnGroupLocks.add(this.serverGroup.getName())) {
            try {
                this.syncGroupServersToReplicationConnectionGroup(replConnGroup);
            }
            finally {
                replConnGroupLocks.remove(this.serverGroup.getName());
            }
        }
    }

    protected JdbcConnection getActiveMySQLConnection() throws SQLException {
        ReplicationConnection c = (ReplicationConnection)this.getActiveConnection();
        JdbcConnection mc = c.getCurrentConnection();
        return mc;
    }

    protected JdbcConnection getActiveMySQLConnectionPassive() {
        try {
            return this.getActiveMySQLConnection();
        }
        catch (SQLException ex) {
            throw new IllegalStateException("Unable to determine active connection", ex);
        }
    }

    protected JdbcConnection getActiveConnectionPassive() {
        try {
            return this.getActiveConnection();
        }
        catch (SQLException ex) {
            throw new IllegalStateException("Unable to determine active connection", ex);
        }
    }

    private void syncGroupServersToReplicationConnectionGroup(ReplicationConnectionGroup replConnGroup) throws SQLException {
        Server newMaster;
        String currentMasterString = null;
        if (replConnGroup.getMasterHosts().size() == 1) {
            currentMasterString = replConnGroup.getMasterHosts().iterator().next();
        }
        if (!(currentMasterString == null || this.serverGroup.getMaster() != null && currentMasterString.equals(this.serverGroup.getMaster().getHostPortString()))) {
            try {
                replConnGroup.removeMasterHost(currentMasterString, false);
            }
            catch (SQLException ex) {
                this.getLog().logWarn("Unable to remove master: " + currentMasterString, ex);
            }
        }
        if ((newMaster = this.serverGroup.getMaster()) != null && replConnGroup.getMasterHosts().size() == 0) {
            this.getLog().logInfo("Changing master for group '" + replConnGroup.getGroupName() + "' to: " + newMaster);
            try {
                if (!replConnGroup.getSlaveHosts().contains(newMaster.getHostPortString())) {
                    replConnGroup.addSlaveHost(newMaster.getHostPortString());
                }
                replConnGroup.promoteSlaveToMaster(newMaster.getHostPortString());
            }
            catch (SQLException ex) {
                throw SQLError.createSQLException("Unable to promote new master '" + newMaster.toString() + "'", ex.getSQLState(), ex, null);
            }
        }
        for (Server s : this.serverGroup.getServers()) {
            if (!s.isSlave()) continue;
            try {
                replConnGroup.addSlaveHost(s.getHostPortString());
            }
            catch (SQLException ex) {
                this.getLog().logWarn("Unable to add slave: " + s.toString(), ex);
            }
        }
        for (String hostPortString : replConnGroup.getSlaveHosts()) {
            Server fabServer = this.serverGroup.getServer(hostPortString);
            if (fabServer != null && fabServer.isSlave()) continue;
            try {
                replConnGroup.removeSlaveHost(hostPortString, true);
            }
            catch (SQLException ex) {
                this.getLog().logWarn("Unable to remove slave: " + hostPortString, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JdbcConnection getActiveConnection() throws SQLException {
        if (!this.transactionInProgress) {
            this.refreshStateIfNecessary();
        }
        if (this.currentConnection != null) {
            return this.currentConnection;
        }
        if (this.getCurrentServerGroup() == null) {
            throw SQLError.createSQLException("No server group selected.", "08004", null, this.getExceptionInterceptor(), this);
        }
        this.currentConnection = this.serverConnections.get(this.serverGroup);
        if (this.currentConnection != null) {
            return this.currentConnection;
        }
        ArrayList<String> masterHost = new ArrayList<String>();
        ArrayList<String> slaveHosts = new ArrayList<String>();
        for (Server s : this.serverGroup.getServers()) {
            if (s.isMaster()) {
                masterHost.add(s.getHostPortString());
                continue;
            }
            if (!s.isSlave()) continue;
            slaveHosts.add(s.getHostPortString());
        }
        Properties info = this.getPropertySet().exposeAsProperties(null);
        ReplicationConnectionGroup replConnGroup = ReplicationConnectionGroupManager.getConnectionGroup(this.serverGroup.getName());
        if (replConnGroup != null && replConnGroupLocks.add(this.serverGroup.getName())) {
            try {
                this.syncGroupServersToReplicationConnectionGroup(replConnGroup);
            }
            finally {
                replConnGroupLocks.remove(this.serverGroup.getName());
            }
        }
        info.setProperty("replicationConnectionGroup", this.serverGroup.getName());
        info.setProperty("user", this.username);
        info.setProperty("password", this.password);
        info.setProperty("DBNAME", this.getCatalog());
        info.setProperty("connectionAttributes", "fabricHaGroup:" + this.serverGroup.getName());
        info.setProperty("retriesAllDown", "1");
        info.setProperty("allowMasterDownConnections", "true");
        info.setProperty("allowSlaveDownConnections", "true");
        info.setProperty("readFromMasterWhenNoSlaves", "true");
        this.currentConnection = ReplicationConnectionProxy.createProxyInstance(this.connectionString, masterHost, info, slaveHosts, info);
        this.serverConnections.put(this.serverGroup, this.currentConnection);
        this.currentConnection.setProxy(this);
        this.currentConnection.setAutoCommit(this.autoCommit);
        this.currentConnection.setReadOnly(this.readOnly);
        this.currentConnection.setTransactionIsolation(this.transactionIsolation);
        return this.currentConnection;
    }

    private void ensureOpen() throws SQLException {
        if (this.closed) {
            throw SQLError.createSQLException("No operations allowed after connection closed.", "08003", this.getExceptionInterceptor());
        }
    }

    private void ensureNoTransactionInProgress() throws SQLException {
        this.ensureOpen();
        if (this.transactionInProgress && !this.autoCommit) {
            throw SQLError.createSQLException("Not allow while a transaction is active.", "25000", this.getExceptionInterceptor());
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.closed = true;
            for (JdbcConnection jdbcConnection : this.serverConnections.values()) {
                try {
                    jdbcConnection.close();
                }
                catch (SQLException sQLException) {}
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean isClosed() {
        try {
            return this.closed;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        try {
            return !this.closed;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        try {
            this.readOnly = readOnly;
            for (ReplicationConnection conn : this.serverConnections.values()) {
                conn.setReadOnly(readOnly);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        try {
            return this.readOnly;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean isReadOnly(boolean useSessionStatus) throws SQLException {
        try {
            return this.readOnly;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        try {
            this.database = catalog;
            for (JdbcConnection jdbcConnection : this.serverConnections.values()) {
                jdbcConnection.setCatalog(catalog);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getCatalog() {
        try {
            return this.database;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void rollback() throws SQLException {
        try {
            this.getActiveConnection().rollback();
            this.transactionCompleted();
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        try {
            this.getActiveConnection().rollback();
            this.transactionCompleted();
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void commit() throws SQLException {
        try {
            this.getActiveConnection().commit();
            this.transactionCompleted();
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        try {
            this.autoCommit = autoCommit;
            for (JdbcConnection jdbcConnection : this.serverConnections.values()) {
                jdbcConnection.setAutoCommit(this.autoCommit);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void transactionBegun() throws SQLException {
        try {
            if (!this.autoCommit) {
                this.transactionInProgress = true;
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void transactionCompleted() throws SQLException {
        try {
            this.transactionInProgress = false;
            this.refreshStateIfNecessary();
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean getAutoCommit() {
        try {
            return this.autoCommit;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public JdbcConnection getMultiHostSafeProxy() {
        return this.getActiveMySQLConnectionPassive();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        try {
            this.transactionIsolation = level;
            for (JdbcConnection jdbcConnection : this.serverConnections.values()) {
                jdbcConnection.setTransactionIsolation(level);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        try {
            for (JdbcConnection jdbcConnection : this.serverConnections.values()) {
                jdbcConnection.setTypeMap(map);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        try {
            for (JdbcConnection jdbcConnection : this.serverConnections.values()) {
                jdbcConnection.setHoldability(holdability);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setProxy(JdbcConnection proxy) {
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        try {
            return this.getActiveConnection().setSavepoint();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        try {
            this.transactionInProgress = true;
            return this.getActiveConnection().setSavepoint(name);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) {
        try {
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        try {
            this.transactionBegun();
            return this.getActiveConnection().prepareCall(sql);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            this.transactionBegun();
            return this.getActiveConnection().prepareCall(sql, resultSetType, resultSetConcurrency);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            this.transactionBegun();
            return this.getActiveConnection().prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        try {
            this.transactionBegun();
            return this.getActiveConnection().prepareStatement(sql);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            this.transactionBegun();
            return this.getActiveConnection().prepareStatement(sql, autoGeneratedKeys);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        try {
            this.transactionBegun();
            return this.getActiveConnection().prepareStatement(sql, columnIndexes);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            this.transactionBegun();
            return this.getActiveConnection().prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            this.transactionBegun();
            return this.getActiveConnection().prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        try {
            this.transactionBegun();
            return this.getActiveConnection().prepareStatement(sql, columnNames);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement clientPrepareStatement(String sql) throws SQLException {
        try {
            this.transactionBegun();
            return this.getActiveConnection().clientPrepareStatement(sql);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement clientPrepareStatement(String sql, int autoGenKeyIndex) throws SQLException {
        try {
            this.transactionBegun();
            return this.getActiveConnection().clientPrepareStatement(sql, autoGenKeyIndex);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement clientPrepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            this.transactionBegun();
            return this.getActiveConnection().clientPrepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement clientPrepareStatement(String sql, int[] autoGenKeyIndexes) throws SQLException {
        try {
            this.transactionBegun();
            return this.getActiveConnection().clientPrepareStatement(sql, autoGenKeyIndexes);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement clientPrepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            this.transactionBegun();
            return this.getActiveConnection().clientPrepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement clientPrepareStatement(String sql, String[] autoGenKeyColNames) throws SQLException {
        try {
            this.transactionBegun();
            return this.getActiveConnection().clientPrepareStatement(sql, autoGenKeyColNames);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement serverPrepareStatement(String sql) throws SQLException {
        try {
            this.transactionBegun();
            return this.getActiveConnection().serverPrepareStatement(sql);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement serverPrepareStatement(String sql, int autoGenKeyIndex) throws SQLException {
        try {
            this.transactionBegun();
            return this.getActiveConnection().serverPrepareStatement(sql, autoGenKeyIndex);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement serverPrepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            this.transactionBegun();
            return this.getActiveConnection().serverPrepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement serverPrepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            this.transactionBegun();
            return this.getActiveConnection().serverPrepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement serverPrepareStatement(String sql, int[] autoGenKeyIndexes) throws SQLException {
        try {
            this.transactionBegun();
            return this.getActiveConnection().serverPrepareStatement(sql, autoGenKeyIndexes);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public PreparedStatement serverPrepareStatement(String sql, String[] autoGenKeyColNames) throws SQLException {
        try {
            this.transactionBegun();
            return this.getActiveConnection().serverPrepareStatement(sql, autoGenKeyColNames);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        try {
            this.transactionBegun();
            return this.getActiveConnection().createStatement();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        try {
            this.transactionBegun();
            return this.getActiveConnection().createStatement(resultSetType, resultSetConcurrency);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        try {
            this.transactionBegun();
            return this.getActiveConnection().createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSetInternalMethods execSQL(StatementImpl callingStatement, String sql, int maxRows, PacketPayload packet, int resultSetType, int resultSetConcurrency, boolean streamResults, String catalog, Field[] cachedMetadata) throws SQLException {
        try {
            return this.getActiveMySQLConnection().execSQL(callingStatement, sql, maxRows, packet, resultSetType, resultSetConcurrency, streamResults, catalog, cachedMetadata);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public ResultSetInternalMethods execSQL(StatementImpl callingStatement, String sql, int maxRows, PacketPayload packet, int resultSetType, int resultSetConcurrency, boolean streamResults, String catalog, Field[] cachedMetadata, boolean isBatch) throws SQLException {
        try {
            return this.getActiveMySQLConnection().execSQL(callingStatement, sql, maxRows, packet, resultSetType, resultSetConcurrency, streamResults, catalog, cachedMetadata, isBatch);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public StringBuilder generateConnectionCommentBlock(StringBuilder buf) {
        return this.getActiveMySQLConnectionPassive().generateConnectionCommentBlock(buf);
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        try {
            return this.getActiveConnection().getMetaData();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getCharacterSetMetadata() {
        return this.getActiveMySQLConnectionPassive().getCharacterSetMetadata();
    }

    @Override
    public Statement getMetadataSafeStatement() throws SQLException {
        try {
            return this.getActiveMySQLConnection().getMetadataSafeStatement();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) {
        try {
            return null;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void unSafeStatementInterceptors() throws SQLException {
        try {
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void createNewIO(boolean isForReconnect) {
        try {
            SQLException ex = SQLError.createSQLFeatureNotSupportedException();
            throw ExceptionFactory.createException(UnableToConnectException.class, ex.getMessage(), ex);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException);
        }
    }

    public void dumpTestcaseQuery(String query) {
    }

    @Override
    public void abortInternal() throws SQLException {
        try {
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean isServerLocal() throws SQLException {
        try {
            return false;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void shutdownServer() throws SQLException {
        try {
            throw SQLError.createSQLFeatureNotSupportedException();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    @Deprecated
    public void clearHasTriedMaster() {
    }

    @Override
    @Deprecated
    public boolean hasTriedMaster() {
        return false;
    }

    @Override
    public boolean isInGlobalTx() {
        return false;
    }

    @Override
    public void setInGlobalTx(boolean flag) {
        throw new RuntimeException("Global transactions not supported.");
    }

    @Override
    public void changeUser(String userName, String newPassword) throws SQLException {
        try {
            throw SQLError.createSQLException("User change not allowed.", this.getExceptionInterceptor());
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    public void setFabricShardKey(String value) {
        this.fabricShardKey = value;
    }

    public String getFabricShardKey() {
        return this.fabricShardKey;
    }

    public void setFabricShardTable(String value) {
        this.fabricShardTable = value;
    }

    public String getFabricShardTable() {
        return this.fabricShardTable;
    }

    public void setFabricServerGroup(String value) {
        this.fabricServerGroup = value;
    }

    public String getFabricServerGroup() {
        return this.fabricServerGroup;
    }

    public void setFabricProtocol(String value) {
        this.fabricProtocol = value;
    }

    public String getFabricProtocol() {
        return this.fabricProtocol;
    }

    public void setFabricUsername(String value) {
        this.fabricUsername = value;
    }

    public String getFabricUsername() {
        return this.fabricUsername;
    }

    public void setFabricPassword(String value) {
        this.fabricPassword = value;
    }

    public String getFabricPassword() {
        return this.fabricPassword;
    }

    public void setFabricReportErrors(boolean value) {
        this.reportErrors = value;
    }

    public boolean getFabricReportErrors() {
        return this.reportErrors;
    }

    @Override
    public int getActiveStatementCount() {
        return -1;
    }

    @Override
    public long getIdleFor() {
        return -1L;
    }

    public Log getLog() {
        return this.log;
    }

    @Override
    public boolean isMasterConnection() {
        return false;
    }

    @Override
    public boolean isNoBackslashEscapesSet() {
        return false;
    }

    @Override
    public boolean isSameResource(JdbcConnection c) {
        return false;
    }

    @Override
    public void ping() throws SQLException {
        try {
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void resetServerState() throws SQLException {
        try {
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setFailedOver(boolean flag) {
    }

    @Override
    public void setStatementComment(String comment) {
    }

    @Override
    public void reportQueryTime(long millisOrNanos) {
    }

    @Override
    public boolean isAbonormallyLongQuery(long millisOrNanos) {
        return false;
    }

    @Override
    public int getAutoIncrementIncrement() {
        return -1;
    }

    @Override
    public boolean hasSameProperties(JdbcConnection c) {
        return false;
    }

    @Override
    public Properties getProperties() {
        return null;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        try {
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getSchema() throws SQLException {
        try {
            return null;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        try {
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        try {
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        try {
            return -1;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void checkClosed() {
    }

    @Override
    public Object getConnectionMutex() {
        return this;
    }

    @Override
    public void setSessionMaxRows(int max) throws SQLException {
        try {
            for (JdbcConnection jdbcConnection : this.serverConnections.values()) {
                jdbcConnection.setSessionMaxRows(max);
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getSessionMaxRows() {
        return this.getActiveConnectionPassive().getSessionMaxRows();
    }

    @Override
    public boolean isProxySet() {
        return false;
    }

    @Override
    public JdbcConnection duplicate() throws SQLException {
        try {
            return null;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public CachedResultSetMetaData getCachedMetaData(String sql) {
        return null;
    }

    @Override
    public Timer getCancelTimer() {
        return null;
    }

    @Deprecated
    public String getCharsetNameForIndex(int charsetIndex) throws SQLException {
        return this.getEncodingForIndex(charsetIndex);
    }

    public String getEncodingForIndex(int charsetIndex) {
        return null;
    }

    public TimeZone getDefaultTimeZone() {
        return null;
    }

    public String getErrorMessageEncoding() {
        return null;
    }

    @Override
    public ExceptionInterceptor getExceptionInterceptor() {
        if (this.currentConnection == null) {
            return null;
        }
        return this.getActiveConnectionPassive().getExceptionInterceptor();
    }

    @Override
    public String getHost() {
        return null;
    }

    @Override
    public long getId() {
        return -1L;
    }

    public int getMaxBytesPerChar(String javaCharsetName) {
        return -1;
    }

    public int getMaxBytesPerChar(Integer charsetIndex, String javaCharsetName) {
        return -1;
    }

    public int getNetBufferLength() {
        return -1;
    }

    @Override
    public boolean getRequiresEscapingEncoder() {
        return false;
    }

    @Override
    public MysqlaSession getSession() {
        try {
            return this.getActiveConnection().getSession();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public ServerVersion getServerVersion() {
        return this.getActiveMySQLConnectionPassive().getServerVersion();
    }

    @Override
    public String getStatementComment() {
        return null;
    }

    @Override
    public List<StatementInterceptorV2> getStatementInterceptorsInstances() {
        return null;
    }

    @Override
    public String getURL() {
        return null;
    }

    @Override
    public String getUser() {
        return null;
    }

    @Override
    public void incrementNumberOfPreparedExecutes() {
    }

    @Override
    public void incrementNumberOfPrepares() {
    }

    @Override
    public void incrementNumberOfResultSetsCreated() {
    }

    @Override
    public void initializeResultsMetadataFromCache(String sql, CachedResultSetMetaData cachedMetaData, ResultSetInternalMethods resultSet) throws SQLException {
        try {
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void initializeSafeStatementInterceptors() throws SQLException {
        try {
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    public boolean isCursorFetchEnabled() throws SQLException {
        return false;
    }

    @Override
    public boolean isReadInfoMsgEnabled() {
        return false;
    }

    @Override
    public boolean lowerCaseTableNames() {
        return false;
    }

    public void maxRowsChanged(com.mysql.cj.api.jdbc.Statement stmt) {
    }

    @Override
    public void pingInternal(boolean checkForClosedConnection, int timeoutMillis) throws SQLException {
        try {
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void realClose(boolean calledExplicitly, boolean issueRollback, boolean skipLocalTeardown, Throwable reason) throws SQLException {
        try {
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void recachePreparedStatement(ServerPreparedStatement pstmt) throws SQLException {
        try {
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void registerQueryExecutionTime(long queryTimeMs) {
    }

    @Override
    public void registerStatement(com.mysql.cj.api.jdbc.Statement stmt) {
    }

    @Override
    public void reportNumberOfTablesAccessed(int numTablesAccessed) {
    }

    public boolean serverSupportsConvertFn() throws SQLException {
        return false;
    }

    @Override
    public void setReadInfoMsgEnabled(boolean flag) {
    }

    @Override
    public void setReadOnlyInternal(boolean readOnlyFlag) throws SQLException {
        try {
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public boolean storesLowerCaseTableName() {
        return false;
    }

    @Override
    public void throwConnectionClosedException() throws SQLException {
        try {
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void unregisterStatement(com.mysql.cj.api.jdbc.Statement stmt) {
    }

    public void unsetMaxRows(com.mysql.cj.api.jdbc.Statement stmt) throws SQLException {
    }

    @Override
    public boolean useAnsiQuotedIdentifiers() {
        return false;
    }

    public boolean useMaxRows() {
        return false;
    }

    @Override
    public void clearWarnings() {
        try {
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public Properties getClientInfo() {
        try {
            return null;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getClientInfo(String name) {
        try {
            return null;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getHoldability() {
        try {
            return -1;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public int getTransactionIsolation() {
        try {
            return -1;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public Map<String, Class<?>> getTypeMap() {
        try {
            return null;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public SQLWarning getWarnings() {
        try {
            return null;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String nativeSQL(String sql) {
        try {
            return null;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    public ProfilerEventHandler getProfilerEventHandlerInstance() {
        return null;
    }

    public void setProfilerEventHandlerInstance(ProfilerEventHandler h) {
    }

    @Override
    public void decachePreparedStatement(ServerPreparedStatement pstmt) throws SQLException {
        try {
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public Blob createBlob() {
        try {
            try {
                this.transactionBegun();
                return this.getActiveConnection().createBlob();
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public Clob createClob() {
        try {
            try {
                this.transactionBegun();
                return this.getActiveConnection().createClob();
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public NClob createNClob() {
        try {
            try {
                this.transactionBegun();
                return this.getActiveConnection().createNClob();
            }
            catch (SQLException ex) {
                throw new RuntimeException(ex);
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        try {
            this.transactionBegun();
            return this.getActiveConnection().createSQLXML();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        for (JdbcConnection jdbcConnection : this.serverConnections.values()) {
            jdbcConnection.setClientInfo(properties);
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        for (JdbcConnection jdbcConnection : this.serverConnections.values()) {
            jdbcConnection.setClientInfo(name, value);
        }
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        try {
            return this.getActiveConnection().createArrayOf(typeName, elements);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        try {
            this.transactionBegun();
            return this.getActiveConnection().createStruct(typeName, attributes);
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getProcessHost() {
        try {
            return this.getActiveConnection().getProcessHost();
        }
        catch (SQLException ex) {
            throw ExceptionFactory.createException(ex.getMessage(), ex);
        }
    }

    @Override
    public ClientInfoProvider getClientInfoProviderImpl() throws SQLException {
        try {
            return this.getActiveConnection().getClientInfoProviderImpl();
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.getExceptionInterceptor());
        }
    }

    @Override
    public String getHostPortPair() {
        return null;
    }
}

