/*
 * Decompiled with CFR 0.152.
 */
package me.saharnooby.lib.query.util;

import lombok.NonNull;

public final class SQLUtil {
    public static void validateIdentifier(@NonNull String s) {
        if (s == null) {
            throw new NullPointerException("s is marked non-null but is null");
        }
        if (s.isEmpty()) {
            throw new IllegalArgumentException("An empty string can't be an identifier");
        }
        if (s.contains("`")) {
            throw new IllegalArgumentException("Invalid identifier \"" + s + "\"");
        }
    }

    public static void validatePlaceholderCount(@NonNull String expr, @NonNull Object[] values) {
        if (expr == null) {
            throw new NullPointerException("expr is marked non-null but is null");
        }
        if (values == null) {
            throw new NullPointerException("values is marked non-null but is null");
        }
        int count = SQLUtil.placeholderCount(expr);
        if (count != values.length) {
            throw new IllegalArgumentException("Expected " + values.length + " placeholders, got " + count + " in expression \"" + expr + "\"");
        }
    }

    private static int placeholderCount(@NonNull String expr) {
        if (expr == null) {
            throw new NullPointerException("expr is marked non-null but is null");
        }
        int count = 0;
        for (int i = 0; i < expr.length(); ++i) {
            if (expr.charAt(i) != '?') continue;
            ++count;
        }
        return count;
    }
}

