/*
 * Decompiled with CFR 0.152.
 */
package me.saharnooby.lib.query.set;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import me.saharnooby.lib.query.set.ResultSetMapper;

public final class ResultSetWrapper
implements AutoCloseable {
    private final ResultSet set;

    public ResultSetWrapper(@NonNull ResultSet set) {
        if (set == null) {
            throw new NullPointerException("set is marked non-null but is null");
        }
        this.set = set;
    }

    public ResultSet set() {
        return this.set;
    }

    @Override
    public void close() throws SQLException {
        this.set.close();
    }

    public <T> List<T> mapAll(@NonNull ResultSetMapper<T> mapper) throws SQLException {
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        ArrayList<T> list = new ArrayList<T>();
        try (ResultSet set = this.set();){
            while (set.next()) {
                list.add(mapper.map(set));
            }
        }
        return list;
    }

    public <T> Optional<T> map(@NonNull ResultSetMapper<T> mapper) throws SQLException {
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        try (ResultSet set = this.set();){
            Optional optional = set.next() ? Optional.ofNullable(mapper.map(set)) : Optional.empty();
            return optional;
        }
    }
}

