/*
 * Decompiled with CFR 0.152.
 */
package me.saharnooby.lib.query.query.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import me.saharnooby.lib.query.query.ConditionalQuery;
import me.saharnooby.lib.query.query.Expression;
import me.saharnooby.lib.query.util.SQLUtil;

public final class Update
extends ConditionalQuery<Update> {
    private final String database;
    private final String table;
    private final Map<String, Expression> expressions = new LinkedHashMap<String, Expression>();

    public Update value(@NonNull String column, @NonNull Object value) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        SQLUtil.validateIdentifier(column);
        return this.valueExpr(column, "?", value);
    }

    public Update valueExpr(@NonNull String column, @NonNull String expr, Object ... params) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        if (expr == null) {
            throw new NullPointerException("expr is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        SQLUtil.validateIdentifier(column);
        SQLUtil.validatePlaceholderCount(expr, params);
        this.expressions.put(column, new Expression(expr, params));
        return this;
    }

    public Update valueNull(@NonNull String column) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        return this.valueExpr(column, "NULL", new Object[0]);
    }

    public Update valueNullable(@NonNull String column, Object value) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        return value == null ? this.valueNull(column) : this.value(column, value);
    }

    @Override
    public String getSQL() {
        if (this.expressions.isEmpty()) {
            throw new IllegalStateException("No values specified");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("UPDATE ");
        if (this.database != null) {
            sb.append("`").append(this.database).append("`.");
        }
        sb.append("`").append(this.table).append("` SET ");
        this.expressions.forEach((k, v) -> sb.append("`").append((String)k).append("` = ").append(v.expr).append(", "));
        sb.setLength(sb.length() - 2);
        sb.append(" ");
        this.appendConditions(sb);
        sb.append(";");
        return sb.toString();
    }

    @Override
    public List<Object> getParams() {
        ArrayList<Object> params = new ArrayList<Object>();
        for (Expression expression : this.expressions.values()) {
            Collections.addAll(params, expression.params);
        }
        for (Expression condition : this.conditions) {
            Collections.addAll(params, condition.params);
        }
        return params;
    }

    public Update(String database, String table) {
        this.database = database;
        this.table = table;
    }
}

