/*
 * Decompiled with CFR 0.152.
 */
package me.saharnooby.lib.query.query.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import me.saharnooby.lib.query.query.ConditionalQuery;
import me.saharnooby.lib.query.query.Expression;
import me.saharnooby.lib.query.util.SQLUtil;

public final class Select
extends ConditionalQuery<Select> {
    private final List<Expression> expressions = new ArrayList<Expression>();
    private boolean all;
    private String database;
    private String table;
    private String orderBy;
    private Object[] orderByParams;
    private boolean desc;
    private Long limit;
    private Long offset;
    private boolean forUpdate;

    public Select all() {
        if (!this.expressions.isEmpty()) {
            throw new IllegalStateException("Some columns were added");
        }
        this.all = true;
        return this;
    }

    public Select col(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        SQLUtil.validateIdentifier(name);
        return this.expr("`" + name + "`", new Object[0]);
    }

    public Select expr(@NonNull String expr, Object ... params) {
        if (expr == null) {
            throw new NullPointerException("expr is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        SQLUtil.validatePlaceholderCount(expr, params);
        if (this.all) {
            throw new IllegalStateException("Can't add expressions to SELECT when selecting all columns");
        }
        this.expressions.add(new Expression(expr, params));
        return this;
    }

    public Select from(@NonNull String tableName) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        SQLUtil.validateIdentifier(tableName);
        this.table = tableName;
        return this;
    }

    public Select from(@NonNull String database, @NonNull String tableName) {
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        SQLUtil.validateIdentifier(tableName);
        this.database = database;
        this.table = tableName;
        return this;
    }

    public Select orderBy(@NonNull String column) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        SQLUtil.validateIdentifier(column);
        return this.orderByExpr("`" + column + "`", new Object[0]);
    }

    public Select orderByExpr(@NonNull String expr, Object ... params) {
        if (expr == null) {
            throw new NullPointerException("expr is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        SQLUtil.validatePlaceholderCount(expr, params);
        this.orderBy = expr;
        this.orderByParams = params;
        return this;
    }

    public Select desc() {
        if (this.orderBy == null) {
            throw new IllegalStateException("Specify order expression first");
        }
        this.desc = true;
        return this;
    }

    public Select limit(long limit) {
        if (limit < 1L) {
            throw new IllegalArgumentException("" + limit);
        }
        this.limit = limit;
        return this;
    }

    public Select offset(long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException("" + offset);
        }
        this.offset = offset;
        return this;
    }

    public Select forUpdate() {
        this.forUpdate = true;
        return this;
    }

    @Override
    public String getSQL() {
        if (!this.all && this.expressions.isEmpty()) {
            throw new IllegalStateException("Selected expression list is empty");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT ");
        if (this.all) {
            sb.append("* ");
        } else {
            for (Expression expression : this.expressions) {
                sb.append(expression.expr).append(", ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(" ");
        }
        if (this.table != null) {
            sb.append("FROM ");
            if (this.database != null) {
                sb.append("`").append(this.database).append("`.");
            }
            sb.append("`").append(this.table).append("` ");
        }
        this.appendConditions(sb);
        if (this.orderBy != null) {
            sb.append("ORDER BY (").append(this.orderBy).append(") ").append(this.desc ? "DESC" : "ASC").append(' ');
        }
        if (this.limit != null) {
            sb.append("LIMIT ").append(this.limit).append(' ');
        }
        if (this.offset != null) {
            sb.append("OFFSET ").append(this.offset).append(' ');
        }
        if (this.forUpdate) {
            sb.append("FOR UPDATE");
        }
        sb.append(";");
        return sb.toString();
    }

    @Override
    public List<Object> getParams() {
        ArrayList<Object> params = new ArrayList<Object>();
        for (Expression expression : this.expressions) {
            Collections.addAll(params, expression.params);
        }
        for (Expression condition : this.conditions) {
            Collections.addAll(params, condition.params);
        }
        if (this.orderByParams != null) {
            Collections.addAll(params, this.orderByParams);
        }
        return params;
    }
}

