/*
 * Decompiled with CFR 0.152.
 */
package me.saharnooby.lib.query.query.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import me.saharnooby.lib.query.query.AbstractQuery;
import me.saharnooby.lib.query.query.Expression;
import me.saharnooby.lib.query.util.SQLUtil;

public final class Insert
extends AbstractQuery {
    private final String database;
    private final String table;
    private boolean ignore;
    private final Map<String, Expression> insert = new LinkedHashMap<String, Expression>();
    private final Map<String, Expression> update = new LinkedHashMap<String, Expression>();

    public Insert ignore() {
        this.ignore = true;
        return this;
    }

    public Insert value(@NonNull String column, @NonNull Object value) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        SQLUtil.validateIdentifier(column);
        return this.valueExpr(column, "?", value);
    }

    public Insert valueExpr(@NonNull String column, @NonNull String expr, Object ... params) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        if (expr == null) {
            throw new NullPointerException("expr is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        SQLUtil.validateIdentifier(column);
        SQLUtil.validatePlaceholderCount(expr, params);
        this.insert.put(column, new Expression(expr, params));
        return this;
    }

    public Insert valueNull(@NonNull String column) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        return this.valueExpr(column, "NULL", new Object[0]);
    }

    public Insert valueNullable(@NonNull String column, Object value) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        return value == null ? this.valueNull(column) : this.value(column, value);
    }

    public Insert onDuplicateKeyUpdateExcept(String ... keys) {
        if (keys == null) {
            throw new NullPointerException("keys is marked non-null but is null");
        }
        this.update.clear();
        HashSet keySet = new HashSet();
        Collections.addAll(keySet, keys);
        this.insert.forEach((k, v) -> {
            if (!keySet.contains(k)) {
                this.update.put((String)k, (Expression)v);
            }
        });
        return this;
    }

    @Override
    public String getSQL() {
        if (this.insert.isEmpty()) {
            throw new IllegalStateException("No values specified");
        }
        if (this.ignore && !this.update.isEmpty()) {
            throw new IllegalStateException("Can't use INGORE with ON DUPLICATE KEY UPDATE");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT");
        if (this.ignore) {
            sb.append(" IGNORE");
        }
        sb.append(" INTO ");
        if (this.database != null) {
            sb.append("`").append(this.database).append("`.");
        }
        sb.append("`").append(this.table).append("` (");
        this.insert.forEach((k, v) -> sb.append("`").append((String)k).append("`, "));
        sb.setLength(sb.length() - 2);
        sb.append(") VALUES (");
        this.insert.forEach((k, v) -> sb.append(v.expr).append(", "));
        sb.setLength(sb.length() - 2);
        sb.append(")");
        if (!this.update.isEmpty()) {
            sb.append(" ON DUPLICATE KEY UPDATE ");
            this.update.forEach((k, v) -> sb.append("`").append((String)k).append("` = ").append(v.expr).append(", "));
            sb.setLength(sb.length() - 2);
        }
        sb.append(";");
        return sb.toString();
    }

    @Override
    public List<Object> getParams() {
        ArrayList<Object> params = new ArrayList<Object>();
        for (Expression expression : this.insert.values()) {
            Collections.addAll(params, expression.params);
        }
        for (Expression expression : this.update.values()) {
            Collections.addAll(params, expression.params);
        }
        return params;
    }

    public Insert(String database, String table) {
        this.database = database;
        this.table = table;
    }
}

