/*
 * Decompiled with CFR 0.152.
 */
package me.saharnooby.lib.query.query.impl;

import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import me.saharnooby.lib.query.query.AbstractQuery;
import me.saharnooby.lib.query.util.SQLUtil;

public final class CreateTable
extends AbstractQuery {
    private final String database;
    private final String table;
    private boolean ifNotExists;
    private final List<Column> columns = new ArrayList<Column>();

    public CreateTable ifNotExists() {
        this.ifNotExists = true;
        return this;
    }

    public CreateTable col(@NonNull String name, @NonNull String type) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        SQLUtil.validateIdentifier(name);
        if (this.columns.stream().anyMatch(c -> c.name.equals(name))) {
            throw new IllegalArgumentException("Column " + name + " already exists");
        }
        this.columns.add(new Column(name, type));
        return this;
    }

    public CreateTable integer(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.col(name, "INT");
    }

    public CreateTable bigint(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.col(name, "BIGINT");
    }

    public CreateTable bool(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.col(name, "TINYINT(1)");
    }

    public CreateTable varchar(@NonNull String name, int size) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.col(name, "VARCHAR(" + size + ")");
    }

    public CreateTable character(@NonNull String name, int size) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.col(name, "CHAR(" + size + ")");
    }

    public CreateTable text(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.col(name, "TEXT");
    }

    public CreateTable NN() {
        this.lastColumn().notNull = true;
        return this;
    }

    public CreateTable AI() {
        this.lastColumn().autoIncrement = true;
        return this;
    }

    public CreateTable PK() {
        this.lastColumn().primaryKey = true;
        return this;
    }

    public CreateTable defaultValue(@NonNull Object value) {
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        this.lastColumn().defaultValue = value;
        return this;
    }

    public CreateTable intKey(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        return this.integer(name).AI().PK();
    }

    private Column lastColumn() {
        if (this.columns.isEmpty()) {
            throw new IllegalStateException("No columns added");
        }
        return this.columns.get(this.columns.size() - 1);
    }

    @Override
    public String getSQL() {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TABLE ");
        if (this.ifNotExists) {
            sb.append("IF NOT EXISTS ");
        }
        if (this.database != null) {
            sb.append("`").append(this.database).append("`.");
        }
        sb.append("`").append(this.table).append("` (");
        ArrayList<String> primaryKeys = new ArrayList<String>();
        for (Column column : this.columns) {
            sb.append("`").append(column.name).append("` ").append(column.type);
            if (column.notNull) {
                sb.append(" NOT NULL");
            }
            if (column.autoIncrement) {
                sb.append(" AUTO_INCREMENT");
            }
            if (column.defaultValue != null) {
                sb.append(" DEFAULT ?");
            }
            sb.append(", ");
            if (!column.primaryKey) continue;
            primaryKeys.add(column.name);
        }
        if (!primaryKeys.isEmpty()) {
            sb.append("PRIMARY KEY (");
            for (String string : primaryKeys) {
                sb.append("`").append(string).append("`, ");
            }
            sb.setLength(sb.length() - 2);
            sb.append(")");
        } else if (!this.columns.isEmpty()) {
            sb.setLength(sb.length() - 2);
        }
        sb.append(");");
        return sb.toString();
    }

    @Override
    public List<Object> getParams() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Column col : this.columns) {
            if (col.defaultValue == null) continue;
            list.add(col.defaultValue);
        }
        return list;
    }

    public CreateTable(String database, String table) {
        this.database = database;
        this.table = table;
    }

    private static final class Column {
        final String name;
        final String type;
        boolean notNull;
        boolean autoIncrement;
        boolean primaryKey;
        Object defaultValue;

        public Column(String name, String type) {
            this.name = name;
            this.type = type;
        }
    }
}

