/*
 * Decompiled with CFR 0.152.
 */
package me.saharnooby.lib.query.query;

import java.util.Arrays;
import lombok.NonNull;
import me.saharnooby.lib.query.query.AbstractQuery;
import me.saharnooby.lib.query.query.impl.CreateTable;
import me.saharnooby.lib.query.query.impl.Delete;
import me.saharnooby.lib.query.query.impl.Insert;
import me.saharnooby.lib.query.query.impl.Raw;
import me.saharnooby.lib.query.query.impl.Select;
import me.saharnooby.lib.query.query.impl.Update;
import me.saharnooby.lib.query.util.SQLUtil;

public final class Query {
    public static CreateTable createTable(@NonNull String tableName) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        SQLUtil.validateIdentifier(tableName);
        return new CreateTable(null, tableName);
    }

    public static Insert insertInto(@NonNull String tableName) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        SQLUtil.validateIdentifier(tableName);
        return new Insert(null, tableName);
    }

    public static Update update(@NonNull String tableName) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        SQLUtil.validateIdentifier(tableName);
        return new Update(null, tableName);
    }

    public static Delete deleteFrom(@NonNull String tableName) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        SQLUtil.validateIdentifier(tableName);
        return new Delete(null, tableName);
    }

    public static Select select(String ... columns) {
        if (columns == null) {
            throw new NullPointerException("columns is marked non-null but is null");
        }
        Select select = new Select();
        for (String column : columns) {
            select.col(column);
        }
        return select;
    }

    public static CreateTable createTable(@NonNull String database, @NonNull String tableName) {
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        SQLUtil.validateIdentifier(database);
        SQLUtil.validateIdentifier(tableName);
        return new CreateTable(database, tableName);
    }

    public static Insert insertInto(@NonNull String database, @NonNull String tableName) {
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        SQLUtil.validateIdentifier(database);
        SQLUtil.validateIdentifier(tableName);
        return new Insert(database, tableName);
    }

    public static Update update(@NonNull String database, @NonNull String tableName) {
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        SQLUtil.validateIdentifier(database);
        SQLUtil.validateIdentifier(tableName);
        return new Update(database, tableName);
    }

    public static Delete deleteFrom(@NonNull String database, @NonNull String tableName) {
        if (database == null) {
            throw new NullPointerException("database is marked non-null but is null");
        }
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        SQLUtil.validateIdentifier(database);
        SQLUtil.validateIdentifier(tableName);
        return new Delete(database, tableName);
    }

    public static AbstractQuery of(@NonNull String sql, Object ... params) {
        if (sql == null) {
            throw new NullPointerException("sql is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        SQLUtil.validatePlaceholderCount(sql, params);
        return new Raw(sql, Arrays.asList(params));
    }
}

