/*
 * Decompiled with CFR 0.152.
 */
package me.saharnooby.lib.query.query;

import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import me.saharnooby.lib.query.query.AbstractQuery;
import me.saharnooby.lib.query.query.Expression;
import me.saharnooby.lib.query.util.SQLUtil;

public abstract class ConditionalQuery<T extends ConditionalQuery<T>>
extends AbstractQuery {
    protected final List<Expression> conditions = new ArrayList<Expression>();

    public final T where(@NonNull String column, @NonNull Object value) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        if (value == null) {
            throw new NullPointerException("value is marked non-null but is null");
        }
        SQLUtil.validateIdentifier(column);
        return this.whereExpr("`" + column + "` = ?", value);
    }

    public final T whereExpr(@NonNull String expr, Object ... params) {
        if (expr == null) {
            throw new NullPointerException("expr is marked non-null but is null");
        }
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        SQLUtil.validatePlaceholderCount(expr, params);
        this.conditions.add(new Expression(expr, params));
        return (T)this;
    }

    public final T whereNull(@NonNull String column) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        return this.whereExpr("`" + column + "` IS NULL", new Object[0]);
    }

    public final T whereNullable(@NonNull String column, Object value) {
        if (column == null) {
            throw new NullPointerException("column is marked non-null but is null");
        }
        return value == null ? this.whereNull(column) : this.where(column, value);
    }

    protected void appendConditions(@NonNull StringBuilder sb) {
        if (sb == null) {
            throw new NullPointerException("sb is marked non-null but is null");
        }
        if (this.conditions.isEmpty()) {
            return;
        }
        sb.append("WHERE ");
        for (Expression condition : this.conditions) {
            sb.append("(").append(condition.expr).append(") AND ");
        }
        sb.setLength(sb.length() - 5);
        sb.append(" ");
    }
}

