/*
 * Decompiled with CFR 0.152.
 */
package me.saharnooby.lib.query.query;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.NonNull;
import me.saharnooby.lib.query.set.ResultSetMapper;
import me.saharnooby.lib.query.set.ResultSetWrapper;

public abstract class AbstractQuery {
    public abstract String getSQL();

    public abstract List<Object> getParams();

    public PreparedStatement prepareStatement(@NonNull Connection con) throws SQLException {
        if (con == null) {
            throw new NullPointerException("con is marked non-null but is null");
        }
        return this.prepareStatement(con, 2);
    }

    public PreparedStatement prepareStatement(@NonNull Connection con, int autoGeneratedKeys) throws SQLException {
        if (con == null) {
            throw new NullPointerException("con is marked non-null but is null");
        }
        PreparedStatement s = con.prepareStatement(this.getSQL(), autoGeneratedKeys);
        List<Object> params = this.getParams();
        for (int i = 0; i < params.size(); ++i) {
            s.setObject(i + 1, params.get(i));
        }
        return s;
    }

    public int update(@NonNull Connection con) throws SQLException {
        if (con == null) {
            throw new NullPointerException("con is marked non-null but is null");
        }
        try (PreparedStatement s = this.prepareStatement(con);){
            int n = s.executeUpdate();
            return n;
        }
    }

    public int update(@NonNull DataSource source) throws SQLException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        try (Connection con = source.getConnection();){
            int n = this.update(con);
            return n;
        }
    }

    public ResultSetWrapper updateWithKeys(@NonNull Connection con) throws SQLException {
        if (con == null) {
            throw new NullPointerException("con is marked non-null but is null");
        }
        PreparedStatement p = this.prepareStatement(con, 1);
        p.closeOnCompletion();
        p.executeUpdate();
        return new ResultSetWrapper(p.getGeneratedKeys());
    }

    public <T> Optional<T> updateWithKeysAndMap(@NonNull DataSource source, @NonNull ResultSetMapper<T> mapper) throws SQLException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        try (Connection con = source.getConnection();){
            Optional<T> optional = this.updateWithKeys(con).map(mapper);
            return optional;
        }
    }

    public <T> List<T> updateWithKeysAndMapAll(@NonNull DataSource source, @NonNull ResultSetMapper<T> mapper) throws SQLException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        try (Connection con = source.getConnection();){
            List<T> list = this.updateWithKeys(con).mapAll(mapper);
            return list;
        }
    }

    public ResultSetWrapper query(@NonNull Connection con) throws SQLException {
        if (con == null) {
            throw new NullPointerException("con is marked non-null but is null");
        }
        PreparedStatement p = this.prepareStatement(con);
        ResultSetWrapper wrapper = new ResultSetWrapper(p.executeQuery());
        p.closeOnCompletion();
        return wrapper;
    }

    public <T> Optional<T> queryAndMap(@NonNull DataSource source, @NonNull ResultSetMapper<T> mapper) throws SQLException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        try (Connection con = source.getConnection();){
            Optional<T> optional = this.query(con).map(mapper);
            return optional;
        }
    }

    public <T> List<T> queryAndMapAll(@NonNull DataSource source, @NonNull ResultSetMapper<T> mapper) throws SQLException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        if (mapper == null) {
            throw new NullPointerException("mapper is marked non-null but is null");
        }
        try (Connection con = source.getConnection();){
            List<T> list = this.query(con).mapAll(mapper);
            return list;
        }
    }
}

