/*
 * Decompiled with CFR 0.152.
 */
package me.saharnooby.lib.query.batch;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import lombok.NonNull;
import me.saharnooby.lib.query.query.AbstractQuery;
import me.saharnooby.lib.query.query.impl.Raw;

public final class BatchBuilder {
    private final List<AbstractQuery> queries = new ArrayList<AbstractQuery>();

    public BatchBuilder add(@NonNull AbstractQuery query) {
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        Raw raw = new Raw(query.getSQL(), query.getParams());
        if (!this.queries.isEmpty()) {
            String first = this.queries.get(0).getSQL();
            if (!((AbstractQuery)raw).getSQL().equals(first)) {
                throw new IllegalArgumentException("Can't add a query '" + ((AbstractQuery)raw).getSQL() + "' to a batch. Expected the query to be '" + first + "'");
            }
        }
        this.queries.add(raw);
        return this;
    }

    public int[] execute(@NonNull Connection con) throws SQLException {
        if (con == null) {
            throw new NullPointerException("con is marked non-null but is null");
        }
        if (this.queries.isEmpty()) {
            return new int[0];
        }
        try (PreparedStatement s = con.prepareStatement(this.queries.get(0).getSQL());){
            for (AbstractQuery query : this.queries) {
                List<Object> params = query.getParams();
                for (int i = 0; i < params.size(); ++i) {
                    s.setObject(i + 1, params.get(i));
                }
                s.addBatch();
            }
            Object object = s.executeBatch();
            return object;
        }
    }

    public int[] execute(@NonNull DataSource source) throws SQLException {
        if (source == null) {
            throw new NullPointerException("source is marked non-null but is null");
        }
        try (Connection con = source.getConnection();){
            int[] nArray = this.execute(con);
            return nArray;
        }
    }
}

