/*
 * Decompiled with CFR 0.152.
 */
package me.minidigger.minimessage.text;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.kyori.text.Component;
import net.kyori.text.KeybindComponent;
import net.kyori.text.TextComponent;
import net.kyori.text.TranslatableComponent;
import net.kyori.text.event.ClickEvent;
import net.kyori.text.event.HoverEvent;
import net.kyori.text.format.TextColor;
import net.kyori.text.format.TextDecoration;

public final class MiniMessageSerializer {
    private MiniMessageSerializer() {
    }

    @Nonnull
    public static String serialize(@Nonnull Component component) {
        StringBuilder sb = new StringBuilder();
        ArrayList<Component> components = new ArrayList<Component>();
        components.add(component);
        for (int i = 0; i < components.size(); ++i) {
            String insert;
            ClickEvent click;
            HoverEvent hov;
            Component comp = (Component)components.get(i);
            components.addAll(comp.children());
            Component prevComp = null;
            if (i > 0) {
                prevComp = (Component)components.get(i - 1);
            }
            if (!(TextColor.WHITE.equals((Object)comp.color()) || comp.color() == null || prevComp != null && prevComp.color() == comp.color())) {
                sb.append(MiniMessageSerializer.startColor(Objects.requireNonNull(comp.color())));
            }
            if (comp.hasDecoration(TextDecoration.BOLD) && (prevComp == null || !prevComp.hasDecoration(TextDecoration.BOLD))) {
                sb.append(MiniMessageSerializer.startTag("bold"));
            }
            if (comp.hasDecoration(TextDecoration.ITALIC) && (prevComp == null || !prevComp.hasDecoration(TextDecoration.ITALIC))) {
                sb.append(MiniMessageSerializer.startTag("italic"));
            }
            if (comp.hasDecoration(TextDecoration.OBFUSCATED) && (prevComp == null || !prevComp.hasDecoration(TextDecoration.OBFUSCATED))) {
                sb.append(MiniMessageSerializer.startTag("obfuscated"));
            }
            if (comp.hasDecoration(TextDecoration.STRIKETHROUGH) && (prevComp == null || !prevComp.hasDecoration(TextDecoration.STRIKETHROUGH))) {
                sb.append(MiniMessageSerializer.startTag("strikethrough"));
            }
            if (comp.hasDecoration(TextDecoration.UNDERLINED) && (prevComp == null || !prevComp.hasDecoration(TextDecoration.UNDERLINED))) {
                sb.append(MiniMessageSerializer.startTag("underlined"));
            }
            if ((hov = comp.hoverEvent()) != null && (prevComp == null || MiniMessageSerializer.areDifferent(hov, prevComp.hoverEvent()))) {
                sb.append(MiniMessageSerializer.startTag(String.format("%s:%s:\"%s\"", "hover", hov.action().name().toLowerCase(), MiniMessageSerializer.serialize(hov.value()))));
            }
            if ((click = comp.clickEvent()) != null && (prevComp == null || MiniMessageSerializer.areDifferent(click, prevComp.clickEvent()))) {
                sb.append(MiniMessageSerializer.startTag(String.format("%s:%s:\"%s\"", "click", click.action().name().toLowerCase(), click.value())));
            }
            if (!((insert = comp.insertion()) == null || prevComp != null && insert.equals(prevComp.insertion()))) {
                sb.append(MiniMessageSerializer.startTag("insert:" + insert));
            }
            if (comp instanceof TextComponent) {
                sb.append(((TextComponent)comp).content());
            } else {
                MiniMessageSerializer.handleDifferentComponent(comp, sb);
            }
            Component nextComp = null;
            if (i + 1 < components.size()) {
                nextComp = (Component)components.get(i + 1);
            }
            if (nextComp != null && comp.color() != TextColor.WHITE && comp.color() != null && (nextComp.color() == TextColor.WHITE || nextComp.color() == null)) {
                sb.append(MiniMessageSerializer.endColor(Objects.requireNonNull(comp.color())));
            }
            if (nextComp != null) {
                if (comp.hasDecoration(TextDecoration.BOLD) && !nextComp.hasDecoration(TextDecoration.BOLD)) {
                    sb.append(MiniMessageSerializer.endTag("bold"));
                }
                if (comp.hasDecoration(TextDecoration.ITALIC) && !nextComp.hasDecoration(TextDecoration.ITALIC)) {
                    sb.append(MiniMessageSerializer.endTag("italic"));
                }
                if (comp.hasDecoration(TextDecoration.OBFUSCATED) && !nextComp.hasDecoration(TextDecoration.OBFUSCATED)) {
                    sb.append(MiniMessageSerializer.endTag("obfuscated"));
                }
                if (comp.hasDecoration(TextDecoration.STRIKETHROUGH) && !nextComp.hasDecoration(TextDecoration.STRIKETHROUGH)) {
                    sb.append(MiniMessageSerializer.endTag("strikethrough"));
                }
                if (comp.hasDecoration(TextDecoration.UNDERLINED) && !nextComp.hasDecoration(TextDecoration.UNDERLINED)) {
                    sb.append(MiniMessageSerializer.endTag("underlined"));
                }
            }
            if (nextComp != null && comp.hoverEvent() != null && MiniMessageSerializer.areDifferent(Objects.requireNonNull(comp.hoverEvent()), nextComp.hoverEvent())) {
                sb.append(MiniMessageSerializer.endTag("hover"));
            }
            if (nextComp != null && comp.clickEvent() != null && MiniMessageSerializer.areDifferent(Objects.requireNonNull(comp.clickEvent()), nextComp.clickEvent())) {
                sb.append(MiniMessageSerializer.endTag("click"));
            }
            if (nextComp == null || comp.insertion() == null || Objects.equals(comp.insertion(), nextComp.insertion())) continue;
            sb.append(MiniMessageSerializer.endTag("insert"));
        }
        return sb.toString();
    }

    private static boolean areDifferent(@Nonnull ClickEvent c1, @Nullable ClickEvent c2) {
        if (c2 == null) {
            return true;
        }
        return !c1.equals((Object)c2) && (!c1.action().equals((Object)c2.action()) || !c1.value().equals(c2.value()));
    }

    private static boolean areDifferent(@Nonnull HoverEvent h1, @Nullable HoverEvent h2) {
        if (h2 == null) {
            return true;
        }
        return !h1.equals((Object)h2) && !h1.action().equals((Object)h2.action());
    }

    @Nonnull
    private static String startColor(@Nonnull TextColor color) {
        return MiniMessageSerializer.startTag(color.name().toLowerCase());
    }

    @Nonnull
    private static String endColor(@Nonnull TextColor color) {
        return MiniMessageSerializer.endTag(color.name().toLowerCase());
    }

    @Nonnull
    private static String startTag(@Nonnull String content) {
        return "<" + content + ">";
    }

    @Nonnull
    private static String endTag(@Nonnull String content) {
        return "</" + content + ">";
    }

    private static void handleDifferentComponent(@Nonnull Component component, @Nonnull StringBuilder sb) {
        if (component instanceof KeybindComponent) {
            sb.append(MiniMessageSerializer.startTag("key:" + ((KeybindComponent)component).keybind()));
        } else if (component instanceof TranslatableComponent) {
            sb.append(MiniMessageSerializer.startTag("lang:" + ((TranslatableComponent)component).key()));
        }
    }
}

