/*
 * Decompiled with CFR 0.152.
 */
package me.minidigger.minimessage.text;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.kyori.text.Component;
import net.kyori.text.KeybindComponent;
import net.kyori.text.TextComponent;
import net.kyori.text.TranslatableComponent;
import net.kyori.text.event.ClickEvent;
import net.kyori.text.event.HoverEvent;
import net.kyori.text.format.TextColor;
import net.kyori.text.format.TextDecoration;

public class MiniMessageParser {
    private static final String START = "start";
    private static final String TOKEN = "token";
    private static final String INNER = "inner";
    private static final String END = "end";
    private static final Pattern pattern = Pattern.compile("((?<start><)(?<token>([^<>]+)|([^<>]+\"(?<inner>[^\"]+)\"))(?<end>>))+?");

    @Nonnull
    public static String escapeTokens(@Nonnull String richMessage) {
        StringBuilder sb = new StringBuilder();
        Matcher matcher = pattern.matcher(richMessage);
        int lastEnd = 0;
        while (matcher.find()) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            if (startIndex > lastEnd) {
                sb.append(richMessage, lastEnd, startIndex);
            }
            lastEnd = endIndex;
            String start = matcher.group(START);
            String token = matcher.group(TOKEN);
            String inner = matcher.group(INNER);
            String end = matcher.group(END);
            if (inner != null) {
                token = token.replace(inner, MiniMessageParser.escapeTokens(inner));
            }
            sb.append("\\").append(start).append(token).append("\\").append(end);
        }
        if (richMessage.length() > lastEnd) {
            sb.append(richMessage.substring(lastEnd));
        }
        return sb.toString();
    }

    @Nonnull
    public static String stripTokens(@Nonnull String richMessage) {
        StringBuilder sb = new StringBuilder();
        Matcher matcher = pattern.matcher(richMessage);
        int lastEnd = 0;
        while (matcher.find()) {
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            if (startIndex > lastEnd) {
                sb.append(richMessage, lastEnd, startIndex);
            }
            lastEnd = endIndex;
        }
        if (richMessage.length() > lastEnd) {
            sb.append(richMessage.substring(lastEnd));
        }
        return sb.toString();
    }

    @Nonnull
    public static String handlePlaceholders(@Nonnull String richMessage, String ... placeholders) {
        if (placeholders.length % 2 != 0) {
            throw new ParseException("Invalid number placeholders defined, usage: parseFormat(format, key, value, key, value...)");
        }
        for (int i = 0; i < placeholders.length; i += 2) {
            richMessage = richMessage.replace("<" + placeholders[i] + ">", placeholders[i + 1]);
        }
        return richMessage;
    }

    @Nonnull
    public static String handlePlaceholders(@Nonnull String richMessage, @Nonnull Map<String, String> placeholders) {
        for (Map.Entry<String, String> entry : placeholders.entrySet()) {
            richMessage = richMessage.replace("<" + entry.getKey() + ">", entry.getValue());
        }
        return richMessage;
    }

    @Nonnull
    public static Component parseFormat(@Nonnull String richMessage, String ... placeholders) {
        return MiniMessageParser.parseFormat(MiniMessageParser.handlePlaceholders(richMessage, placeholders));
    }

    @Nonnull
    public static Component parseFormat(@Nonnull String richMessage, @Nonnull Map<String, String> placeholders) {
        return MiniMessageParser.parseFormat(MiniMessageParser.handlePlaceholders(richMessage, placeholders));
    }

    @Nonnull
    public static Component parseFormat(@Nonnull String richMessage) {
        TextComponent comp;
        TextComponent.Builder parent = TextComponent.builder((String)"");
        ArrayDeque<ClickEvent> clickEvents = new ArrayDeque<ClickEvent>();
        ArrayDeque<HoverEvent> hoverEvents = new ArrayDeque<HoverEvent>();
        ArrayDeque<TextColor> colors = new ArrayDeque<TextColor>();
        ArrayDeque<String> insertions = new ArrayDeque<String>();
        EnumSet<HelperTextDecoration> decorations = EnumSet.noneOf(HelperTextDecoration.class);
        Matcher matcher = pattern.matcher(richMessage);
        int lastEnd = 0;
        while (matcher.find()) {
            TextComponent current = null;
            int startIndex = matcher.start();
            int endIndex = matcher.end();
            String msg = null;
            if (startIndex > lastEnd) {
                msg = richMessage.substring(lastEnd, startIndex);
            }
            lastEnd = endIndex;
            if (msg != null && msg.length() != 0) {
                current = TextComponent.of((String)msg);
                current = MiniMessageParser.applyFormatting(clickEvents, hoverEvents, colors, insertions, decorations, (Component)current);
            }
            String token = matcher.group(TOKEN);
            String inner = matcher.group(INNER);
            if (token.startsWith("click:")) {
                clickEvents.push(MiniMessageParser.handleClick(token, inner));
            } else if (token.equals("/click")) {
                clickEvents.pollFirst();
            } else if (token.startsWith("hover:")) {
                hoverEvents.push(MiniMessageParser.handleHover(token, inner));
            } else if (token.equals("/hover")) {
                hoverEvents.pollFirst();
            } else {
                Optional<HelperTextDecoration> deco = MiniMessageParser.resolveDecoration(token);
                if (deco.isPresent()) {
                    decorations.add(deco.get());
                } else if (token.startsWith("/") && (deco = MiniMessageParser.resolveDecoration(token.replace("/", ""))).isPresent()) {
                    decorations.remove((Object)deco.get());
                } else {
                    Optional<TextColor> color = MiniMessageParser.resolveColor(token);
                    if (color.isPresent()) {
                        colors.push(color.get());
                    } else if (token.startsWith("/") && MiniMessageParser.resolveColor(token.replace("/", "")).isPresent()) {
                        colors.pollFirst();
                    } else if (token.startsWith("key:")) {
                        if (current != null) {
                            parent.append((Component)current);
                        }
                        current = MiniMessageParser.handleKeybind(token);
                        current = MiniMessageParser.applyFormatting(clickEvents, hoverEvents, colors, insertions, decorations, (Component)current);
                    } else if (token.startsWith("lang:")) {
                        if (current != null) {
                            parent.append((Component)current);
                        }
                        current = MiniMessageParser.handleTranslatable(token);
                        current = MiniMessageParser.applyFormatting(clickEvents, hoverEvents, colors, insertions, decorations, (Component)current);
                    } else if (token.startsWith("insert:")) {
                        insertions.push(MiniMessageParser.handleInsertion(token));
                    } else if (token.startsWith("/insert")) {
                        insertions.pop();
                    } else {
                        if (current != null) {
                            parent.append((Component)current);
                        }
                        current = TextComponent.of((String)("<" + token + ">"));
                        current = MiniMessageParser.applyFormatting(clickEvents, hoverEvents, colors, insertions, decorations, (Component)current);
                    }
                }
            }
            if (current == null) continue;
            parent.append((Component)current);
        }
        if (richMessage.length() > lastEnd) {
            String msg = richMessage.substring(lastEnd);
            TextComponent current = TextComponent.of((String)msg);
            current = MiniMessageParser.applyFormatting(clickEvents, hoverEvents, colors, insertions, decorations, (Component)current);
            parent.append((Component)current);
        }
        if ((comp = (TextComponent)parent.build()).content().equals("") && comp.children().size() == 1) {
            return (Component)comp.children().get(0);
        }
        return comp;
    }

    @Nonnull
    private static Component applyFormatting(@Nonnull Deque<ClickEvent> clickEvents, @Nonnull Deque<HoverEvent> hoverEvents, @Nonnull Deque<TextColor> colors, @Nonnull Deque<String> insertions, @Nonnull EnumSet<HelperTextDecoration> decorations, @Nonnull Component current) {
        if (!clickEvents.isEmpty()) {
            current = current.clickEvent(clickEvents.peek());
        }
        if (!hoverEvents.isEmpty()) {
            current = current.hoverEvent(hoverEvents.peek());
        }
        if (!colors.isEmpty()) {
            current = current.color(colors.peek());
        }
        if (!decorations.isEmpty()) {
            for (HelperTextDecoration decor : decorations) {
                current = decor.apply(current);
            }
        }
        if (!insertions.isEmpty()) {
            current = current.insertion(insertions.peek());
        }
        return current;
    }

    @Nonnull
    private static String handleInsertion(@Nonnull String token) {
        String[] args = token.split(":");
        if (args.length < 2) {
            throw new ParseException("Can't parse insertion (too few args) " + token);
        }
        return token.replace(args[0] + ":", "");
    }

    @Nonnull
    private static Component handleTranslatable(@Nonnull String token) {
        String[] args = token.split(":");
        if (args.length < 2) {
            throw new ParseException("Can't parse translatable (too few args) " + token);
        }
        return TranslatableComponent.of((String)args[1]);
    }

    @Nonnull
    private static KeybindComponent handleKeybind(@Nonnull String token) {
        String[] args = token.split(":");
        if (args.length < 2) {
            throw new ParseException("Can't parse keybind (too few args) " + token);
        }
        return KeybindComponent.of((String)args[1]);
    }

    @Nonnull
    private static ClickEvent handleClick(@Nonnull String token, @Nonnull String inner) {
        String[] args = token.split(":");
        if (args.length < 2) {
            throw new ParseException("Can't parse click action (too few args) " + token);
        }
        ClickEvent.Action action = ClickEvent.Action.valueOf((String)args[1].toUpperCase());
        return ClickEvent.of((ClickEvent.Action)action, (String)token.replace("click:" + args[1] + ":", ""));
    }

    @Nonnull
    private static HoverEvent handleHover(@Nonnull String token, @Nonnull String inner) {
        String[] args = token.split(":");
        if (args.length < 2) {
            throw new ParseException("Can't parse hover action (too few args) " + token);
        }
        HoverEvent.Action action = HoverEvent.Action.valueOf((String)args[1].toUpperCase());
        return HoverEvent.of((HoverEvent.Action)action, (Component)MiniMessageParser.parseFormat(inner));
    }

    @Nonnull
    private static Optional<TextColor> resolveColor(@Nonnull String token) {
        try {
            return Optional.of(TextColor.valueOf((String)token.toUpperCase()));
        }
        catch (IllegalArgumentException ex) {
            return Optional.empty();
        }
    }

    @Nonnull
    private static Optional<HelperTextDecoration> resolveDecoration(@Nonnull String token) {
        try {
            return Optional.of(HelperTextDecoration.valueOf(token.toUpperCase()));
        }
        catch (IllegalArgumentException ex) {
            return Optional.empty();
        }
    }

    static class ParseException
    extends RuntimeException {
        public ParseException(@Nonnull String message) {
            super(message);
        }
    }

    static enum HelperTextDecoration {
        BOLD(b -> b.decoration(TextDecoration.BOLD, true)),
        ITALIC(b -> b.decoration(TextDecoration.ITALIC, true)),
        UNDERLINED(b -> b.decoration(TextDecoration.UNDERLINED, true)),
        STRIKETHROUGH(b -> b.decoration(TextDecoration.STRIKETHROUGH, true)),
        OBFUSCATED(b -> b.decoration(TextDecoration.OBFUSCATED, true));

        private final UnaryOperator<Component> builder;

        private HelperTextDecoration(UnaryOperator<Component> builder) {
            this.builder = builder;
        }

        @Nonnull
        public Component apply(@Nonnull Component comp) {
            return (Component)this.builder.apply(comp);
        }
    }
}

